/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.UnknownHostException;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.MultiplexingOutputStream;
import org.jboss.remoting.transport.multiplex.Protocol;
import org.jboss.remoting.transport.multiplex.SocketId;

public class VirtualSocket
extends Socket {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$VirtualSocket == null ? (class$org$jboss$remoting$transport$multiplex$VirtualSocket = VirtualSocket.class$("org.jboss.remoting.transport.multiplex.VirtualSocket")) : class$org$jboss$remoting$transport$multiplex$VirtualSocket));
    private MultiplexingManager manager;
    private Protocol protocol;
    private Socket actualSocket;
    private SocketId remoteSocketId;
    private SocketId localSocketId;
    private MultiplexingInputStream inputStream;
    private MultiplexingOutputStream outputStream;
    private boolean connected = false;
    private boolean bound = false;
    private boolean inputShutdown = false;
    private boolean outputShutdown = false;
    private boolean receivedDisconnectMessage = false;
    private boolean closed = false;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$VirtualSocket;

    public VirtualSocket(MultiplexingManager manager, SocketId remoteSocketId) throws IOException {
        this.manager = manager;
        this.actualSocket = manager.getSocket();
        this.remoteSocketId = remoteSocketId;
        this.protocol = manager.getProtocol();
        this.localSocketId = new SocketId();
        MultiplexingManager.StreamPair streamPair = manager.registerSocket(this);
        this.inputStream = streamPair.getInputStream();
        this.outputStream = streamPair.getOutputStream();
        this.bound = true;
        this.connected = true;
        log.info((Object)("created virtual socket on port: " + this.localSocketId.getPort()));
    }

    public VirtualSocket() {
        log.info((Object)"created unbound virtual socket");
    }

    public VirtualSocket(String host, int port) throws UnknownHostException, IOException {
        InetSocketAddress address = null;
        address = host == null ? new InetSocketAddress(InetAddress.getByName(null), port) : new InetSocketAddress(host, port);
        this.connect(address);
        log.info((Object)("created virtual socket on port: " + this.localSocketId.getPort()));
    }

    public VirtualSocket(String host, int port, boolean stream) throws IOException {
        if (!stream) {
            throw new SocketException("Deprecated: use DataGramSocket instead of stream = false");
        }
        InetSocketAddress address = null;
        address = host == null ? new InetSocketAddress(InetAddress.getByName(null), port) : new InetSocketAddress(host, port);
        this.connect(address);
        log.info((Object)("created virtual socket on port: " + this.localSocketId.getPort()));
    }

    public VirtualSocket(InetAddress address, int port) throws IOException {
        this.connect(new InetSocketAddress(address, port));
        log.info((Object)("created virtual socket on port: " + this.localSocketId.getPort()));
    }

    public VirtualSocket(InetAddress host, int port, boolean stream) throws IOException {
        if (!stream) {
            throw new SocketException("Deprecated: use DataGramSocket instead of stream = false");
        }
        this.connect(new InetSocketAddress(host, port));
        log.info((Object)("created virtual socket on port: " + this.localSocketId.getPort()));
    }

    public VirtualSocket(SocketImpl impl) throws SocketException {
        throw new SocketException("VirtualSocket does not use SocketImpl");
    }

    public VirtualSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        this(InetAddress.getByName(host), port, localAddr, localPort);
    }

    public VirtualSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this();
        this.bind(new InetSocketAddress(localAddr, localPort));
        this.connect(new InetSocketAddress(address, port));
        log.info((Object)("created virtual socket on port: " + this.localSocketId.getPort()));
    }

    public synchronized void bind(SocketAddress address) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (address != null && !(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetAddress = (InetSocketAddress)address;
        if (inetAddress != null && inetAddress.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        this.manager = MultiplexingManager.getaManagerByLocalAddress(inetAddress);
        this.localSocketId = new SocketId();
        log.info((Object)("bound virtual socket to port: " + this.localSocketId.getPort()));
        this.bound = true;
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.receivedDisconnectMessage) {
            this.protocol.disconnect(this.localSocketId);
        }
        this.inputStream.close();
        this.inputStream = null;
        this.outputStream.flush();
        this.outputStream.close();
        this.outputStream = null;
        this.manager.unRegisterSocket(this);
        log.info((Object)("virtual socket closed on port: " + this.localSocketId.getPort()));
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    public synchronized void connect(SocketAddress socketAddress, int timeout) throws IOException {
        if (timeout > 0) {
            throw new SocketException("timeout not yet implemented");
        }
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isConnected()) {
            throw new SocketException("already connected");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (this.manager == null) {
            this.manager = MultiplexingManager.getaManagerByRemoteAddress(inetSocketAddress);
        }
        this.manager.connect(inetSocketAddress);
        this.protocol = this.manager.getProtocol();
        this.actualSocket = this.manager.getSocket();
        if (!this.bound) {
            this.localSocketId = new SocketId();
            this.bound = true;
        }
        this.remoteSocketId = this.protocol.connect(this.localSocketId);
        MultiplexingManager.StreamPair streamPair = this.manager.registerSocket(this);
        this.inputStream = streamPair.getInputStream();
        this.outputStream = streamPair.getOutputStream();
        this.connected = true;
    }

    public synchronized InetAddress getInetAddress() {
        if (this.actualSocket == null) {
            return null;
        }
        return this.actualSocket.getInetAddress();
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        return this.inputStream;
    }

    public synchronized InetAddress getLocalAddress() {
        if (this.actualSocket == null) {
            return null;
        }
        return this.actualSocket.getLocalAddress();
    }

    public synchronized int getLocalPort() {
        if (this.actualSocket == null) {
            return -1;
        }
        return this.actualSocket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        if (this.actualSocket == null) {
            return null;
        }
        return this.actualSocket.getLocalSocketAddress();
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        return this.outputStream;
    }

    public synchronized int getPort() {
        if (this.actualSocket == null) {
            return 0;
        }
        return this.actualSocket.getPort();
    }

    public SocketAddress getRemoteSocketAddress() {
        if (this.actualSocket == null) {
            return null;
        }
        return this.actualSocket.getRemoteSocketAddress();
    }

    public synchronized boolean isBound() {
        return this.bound;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public synchronized boolean isInputShutdown() {
        return this.inputShutdown;
    }

    public synchronized boolean isOutputShutdown() {
        return this.outputShutdown;
    }

    public synchronized void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        this.inputStream.setEOF();
        this.inputShutdown = true;
        this.protocol.notifyInputShutdown(this.localSocketId);
    }

    public synchronized void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        this.outputStream.shutdown();
        this.outputShutdown = true;
        this.protocol.notifyOutputShutdown(this.localSocketId);
    }

    public synchronized int getVirtualPort() {
        return this.remoteSocketId.getPort();
    }

    public synchronized int getLocalVirtualPort() {
        return this.localSocketId.getPort();
    }

    public synchronized SocketId getLocalSocketId() {
        return this.localSocketId;
    }

    public synchronized SocketId getRemoteSocketId() {
        return this.localSocketId;
    }

    public void handleRemoteInputShutDown() throws IOException {
        try {
            this.outputStream.handleRemoteInputShutdown();
        }
        catch (NullPointerException e) {
            log.info((Object)e);
        }
    }

    public void handleRemoteOutputShutDown() throws IOException {
        try {
            this.inputStream.handleRemoteShutdown();
        }
        catch (NullPointerException e) {
            log.info((Object)e);
        }
    }

    public void handleRemoteDisconnect() throws IOException {
        if (this.isClosed()) {
            return;
        }
        log.info((Object)("remote virtual socket disconnecting: local port: " + this.getLocalVirtualPort()));
        this.receivedDisconnectMessage = true;
        try {
            this.inputStream.handleRemoteShutdown();
        }
        catch (NullPointerException e) {
            log.info((Object)e);
        }
        try {
            this.outputStream.flush();
            this.outputStream.handleRemoteInputShutdown();
        }
        catch (NullPointerException e) {
            log.info((Object)e);
        }
        log.info((Object)"handleRemoteDisconnect(): done.");
    }

    protected synchronized Socket getActualSocket() {
        return this.actualSocket;
    }

    protected synchronized void setActualSocket(Socket actualSocket) {
        this.actualSocket = actualSocket;
    }

    protected synchronized void setBound(boolean bound) {
        this.bound = bound;
    }

    protected synchronized MultiplexingManager getManager() {
        return this.manager;
    }

    protected synchronized void setManager(MultiplexingManager manager) {
        this.manager = manager;
    }

    protected synchronized Protocol getProtocol() {
        return this.protocol;
    }

    protected synchronized void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    protected synchronized void setClosed(boolean closed) {
        this.closed = closed;
    }

    protected synchronized void setConnected(boolean connected) {
        this.connected = connected;
    }

    protected synchronized void setInputShutdown(boolean inputShutdown) {
        this.inputShutdown = inputShutdown;
    }

    protected synchronized void setInputStream(MultiplexingInputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected synchronized void setLocalSocketId(SocketId localSocketId) {
        this.localSocketId = localSocketId;
    }

    protected synchronized void setOutputShutdown(boolean outputShutdown) {
        this.outputShutdown = outputShutdown;
    }

    protected synchronized void setOutputStream(MultiplexingOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected synchronized void setRemoteSocketId(SocketId remoteSocketId) {
        this.remoteSocketId = remoteSocketId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

