/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.jdbc.Batcher;
import org.hibernate.util.JDBCExceptionReporter;

public class ConnectionManager
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)ConnectionManager.class);
    private transient SessionFactoryImplementor factory;
    private final Callback callback;
    private final ConnectionReleaseMode releaseMode;
    private transient Connection connection;
    private final boolean wasConnectionSupplied;
    private transient Batcher batcher;
    private transient Interceptor interceptor;
    private boolean isClosed;

    public ConnectionManager(SessionFactoryImplementor factory, Callback callback, ConnectionReleaseMode releaseMode, Connection connection, Interceptor interceptor) {
        this.factory = factory;
        this.callback = callback;
        this.interceptor = interceptor;
        this.batcher = factory.getSettings().getBatcherFactory().createBatcher(this, interceptor);
        this.releaseMode = releaseMode;
        this.connection = connection;
        this.wasConnectionSupplied = connection != null;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public Batcher getBatcher() {
        return this.batcher;
    }

    public Connection getConnection() throws HibernateException {
        if (this.connection == null && !this.isClosed) {
            this.openConnection();
        }
        return this.connection;
    }

    public boolean isAutoCommit() throws SQLException {
        return this.connection == null || this.connection.getAutoCommit();
    }

    public boolean isAggressiveRelease() {
        boolean inAutoCommitState;
        try {
            inAutoCommitState = !this.callback.isTransactionInProgress() && this.isAutoCommit();
        }
        catch (SQLException e) {
            inAutoCommitState = true;
        }
        return this.releaseMode == ConnectionReleaseMode.AFTER_STATEMENT || this.releaseMode == ConnectionReleaseMode.AFTER_TRANSACTION && inAutoCommitState;
    }

    public boolean isCurrentlyConnected() {
        return this.wasConnectionSupplied ? this.connection != null : !this.isClosed;
    }

    public void afterStatement() {
        if (this.isAggressiveRelease()) {
            if (this.batcher.hasOpenResources()) {
                log.info((Object)"Skipping aggresive-release due to open resources on batcher");
            } else {
                this.aggressiveRelease();
            }
        }
    }

    public void afterTransaction() {
        if (this.isAfterTransactionRelease()) {
            this.aggressiveRelease();
        }
        this.batcher.unsetTransactionTimeout();
    }

    private boolean isAfterTransactionRelease() {
        return this.releaseMode == ConnectionReleaseMode.AFTER_TRANSACTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection close() {
        try {
            Connection connection = this.cleanup();
            return connection;
        }
        finally {
            this.isClosed = true;
        }
    }

    public Connection manualDisconnect() {
        return this.cleanup();
    }

    public void manualReconnect() {
    }

    public void manualReconnect(Connection suppliedConnection) {
        this.connection = suppliedConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection cleanup() throws HibernateException {
        if (this.connection == null) {
            log.trace((Object)"connection already null in cleanup : no action");
            return null;
        }
        try {
            log.trace((Object)"performing cleanup");
            this.batcher.closeStatements();
            Connection c = null;
            if (!this.wasConnectionSupplied) {
                this.closeConnection();
            } else {
                c = this.connection;
            }
            this.connection = null;
            Connection connection = c;
            return connection;
        }
        finally {
            this.callback.connectionCleanedUp();
        }
    }

    private void aggressiveRelease() {
        if (!this.wasConnectionSupplied) {
            log.debug((Object)"aggressively releasing JDBC connection");
            if (this.connection != null) {
                this.closeConnection();
            }
        }
    }

    private void openConnection() throws HibernateException {
        if (this.connection != null) {
            return;
        }
        log.debug((Object)"opening JDBC connection");
        try {
            this.connection = this.factory.getConnectionProvider().getConnection();
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "Cannot open connection");
        }
        this.callback.connectionOpened();
    }

    private void closeConnection() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing JDBC connection [" + this.batcher.openResourceStatsAsString() + "]"));
        }
        try {
            if (!this.connection.isClosed()) {
                JDBCExceptionReporter.logAndClearWarnings(this.connection);
            }
            this.factory.getConnectionProvider().closeConnection(this.connection);
            this.connection = null;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "Cannot close connection");
        }
    }

    public boolean isReadyForSerialization() {
        return this.wasConnectionSupplied ? this.connection == null : !this.batcher.hasOpenResources();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (!this.isReadyForSerialization()) {
            throw new IllegalStateException("Cannot serialize a ConnectionManager while connected");
        }
        if (this.connection != null) {
            this.closeConnection();
        }
        oos.writeObject(this.factory);
        oos.writeObject(this.interceptor);
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.factory = (SessionFactoryImplementor)ois.readObject();
        this.interceptor = (Interceptor)ois.readObject();
        ois.defaultReadObject();
        this.batcher = this.factory.getSettings().getBatcherFactory().createBatcher(this, this.interceptor);
    }

    protected void finalize() throws Throwable {
        log.debug((Object)"running Session.finalize()");
        if (this.connection != null) {
            if (this.connection.isClosed()) {
                log.warn((Object)"finalizing with closed connection");
            } else {
                log.warn((Object)"unclosed connection, forgot to call close() on your session?");
                if (!this.wasConnectionSupplied) {
                    this.connection.close();
                }
            }
        }
        super.finalize();
    }

    public static interface Callback {
        public void connectionOpened();

        public void connectionCleanedUp();

        public boolean isTransactionInProgress();
    }
}

