/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.List;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.loader.custom.SQLQueryReturn;
import org.hibernate.loader.custom.SQLQueryScalarReturn;

public class NamedSQLQueryDefinition
extends NamedQueryDefinition {
    private SQLQueryReturn[] queryReturns;
    private SQLQueryScalarReturn[] scalarReturns;
    private final List querySpaces;
    private final boolean callable;
    private String resultSetRef;

    public NamedSQLQueryDefinition(String query, SQLQueryReturn[] queryReturns, SQLQueryScalarReturn[] scalarReturns, List querySpaces, boolean cacheable, String cacheRegion, Integer timeout, Integer fetchSize, FlushMode flushMode, Map parameterTypes, boolean callable) {
        this(query, queryReturns, scalarReturns, querySpaces, cacheable, cacheRegion, timeout, fetchSize, flushMode, null, false, null, parameterTypes, callable);
    }

    public NamedSQLQueryDefinition(String query, SQLQueryReturn[] queryReturns, SQLQueryScalarReturn[] scalarReturns, List querySpaces, boolean cacheable, String cacheRegion, Integer timeout, Integer fetchSize, FlushMode flushMode, CacheMode cacheMode, boolean readOnly, String comment, Map parameterTypes, boolean callable) {
        super(query.trim(), cacheable, cacheRegion, timeout, fetchSize, flushMode, cacheMode, readOnly, comment, parameterTypes);
        this.queryReturns = queryReturns;
        this.scalarReturns = scalarReturns;
        this.querySpaces = querySpaces;
        this.callable = callable;
    }

    public NamedSQLQueryDefinition(String query, String resultSetRef, List querySpaces, boolean cacheable, String cacheRegion, Integer timeout, Integer fetchSize, FlushMode flushMode, Map parameterTypes, boolean callable) {
        this(query, resultSetRef, querySpaces, cacheable, cacheRegion, timeout, fetchSize, flushMode, null, false, null, parameterTypes, callable);
    }

    public NamedSQLQueryDefinition(String query, String resultSetRef, List querySpaces, boolean cacheable, String cacheRegion, Integer timeout, Integer fetchSize, FlushMode flushMode, CacheMode cacheMode, boolean readOnly, String comment, Map parameterTypes, boolean callable) {
        super(query.trim(), cacheable, cacheRegion, timeout, fetchSize, flushMode, cacheMode, readOnly, comment, parameterTypes);
        this.resultSetRef = resultSetRef;
        this.querySpaces = querySpaces;
        this.callable = callable;
    }

    public SQLQueryReturn[] getQueryReturns() {
        return this.queryReturns;
    }

    public SQLQueryScalarReturn[] getScalarQueryReturns() {
        return this.scalarReturns;
    }

    public List getQuerySpaces() {
        return this.querySpaces;
    }

    public boolean isCallable() {
        return this.callable;
    }

    public String getResultSetRef() {
        return this.resultSetRef;
    }
}

