/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.server;

import java.lang.reflect.Method;
import java.security.Principal;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.axis.AxisFault;
import org.jboss.axis.MessageContext;
import org.jboss.axis.handlers.soap.SOAPService;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.InvocationType;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.security.SecurityAssociation;
import org.jboss.webservice.Constants;
import org.jboss.webservice.server.InvokerProvider;
import org.jboss.webservice.server.ServiceException;

public class InvokerProviderEJB
extends InvokerProvider {
    static final long serialVersionUID = 7848928202043133442L;
    private Logger log = Logger.getLogger((Class)InvokerProviderEJB.class);
    private String jndiName;
    private ObjectName containerName;

    public void initServiceDesc(SOAPService service, MessageContext msgContext) throws AxisFault {
        String serviceEndpoint;
        super.initServiceDesc(service, msgContext);
        String ejbLink = this.portComponentInfo.getPortComponentMetaData().getEjbLink();
        if (ejbLink == null) {
            throw new ServiceException("Cannot obtain ejb-link from port component");
        }
        ApplicationMetaData applMetaData = (ApplicationMetaData)this.portComponentInfo.getDeploymentInfo().metaData;
        BeanMetaData beanMetaData = applMetaData.getBeanByEjbName(ejbLink);
        if (beanMetaData == null) {
            throw new ServiceException("Cannot obtain ejb meta data for: " + ejbLink);
        }
        String sei = this.portComponentInfo.getPortComponentMetaData().getServiceEndpointInterface();
        if (!sei.equals(serviceEndpoint = beanMetaData.getServiceEndpoint())) {
            throw new ServiceException("The <" + sei + "> does not correspond to <" + serviceEndpoint + "> in ejb-jar.xml");
        }
        this.jndiName = beanMetaData.getContainerObjectNameJndiName();
        if (this.jndiName == null) {
            throw new ServiceException("Cannot obtain JNDI name for: " + ejbLink);
        }
        try {
            this.containerName = new ObjectName("jboss.j2ee:jndiName=" + this.jndiName + ",service=EJB");
        }
        catch (MalformedObjectNameException e) {
            throw new ServiceException(e.toString());
        }
    }

    protected ClassLoader getContextClassLoader() {
        return this.portComponentInfo.getDeploymentInfo().ucl;
    }

    protected Object makeNewServiceObject(MessageContext msgContext, String className) throws Exception {
        this.log.debug((Object)("makeNewServiceObject: class=" + className));
        return null;
    }

    protected Object invokeServiceEndpoint(MessageContext msgContext, Method method, Object obj, Object[] argValues) throws Exception {
        this.log.debug((Object)("Invoke EJB: " + method));
        Principal principal = SecurityAssociation.getPrincipal();
        Object credential = SecurityAssociation.getCredential();
        msgContext.setProperty(Constants.HANDLER_CHAIN, (Object)this.handlerChain);
        Invocation inv = new Invocation(null, method, argValues, null, principal, credential);
        inv.setValue((Object)InvocationKey.SOAP_MESSAGE_CONTEXT, (Object)msgContext);
        inv.setValue((Object)InvocationKey.SOAP_MESSAGE, (Object)msgContext.getMessage());
        inv.setType(InvocationType.SERVICE_ENDPOINT);
        Object[] invArgs = new Object[]{inv};
        String[] sig = new String[]{Invocation.class.getName()};
        Object ret = this.server.invoke(this.containerName, "invoke", invArgs, sig);
        return ret;
    }

    protected void processException(Exception ex) throws AxisFault {
        Exception cause = ex;
        if (ex instanceof MBeanException && ex.getCause() instanceof Exception) {
            cause = (Exception)ex.getCause();
        }
        super.processException(cause);
    }
}

