/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionManagerService;
import org.jboss.tm.TxManager;
import org.jboss.util.NestedRuntimeException;

public class TransactionManagerLocator {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$tm$TransactionManagerLocator == null ? (class$org$jboss$tm$TransactionManagerLocator = TransactionManagerLocator.class$("org.jboss.tm.TransactionManagerLocator")) : class$org$jboss$tm$TransactionManagerLocator));
    private static TransactionManagerLocator instance = new TransactionManagerLocator();
    private TransactionManager tm;
    static /* synthetic */ Class class$org$jboss$tm$TransactionManagerLocator;

    private TransactionManagerLocator() {
    }

    public static TransactionManagerLocator getInstance() {
        return instance;
    }

    public TransactionManager locate() {
        if (this.tm != null) {
            return this.tm;
        }
        TransactionManager result = this.tryJNDI();
        if (result == null) {
            result = this.usePrivateAPI();
        }
        if (result == null) {
            throw new NestedRuntimeException("Unable to locate the transaction manager");
        }
        return result;
    }

    protected TransactionManager tryJNDI() {
        try {
            InitialContext ctx = new InitialContext();
            this.tm = (TransactionManager)ctx.lookup(TransactionManagerService.JNDI_NAME);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Got a transaction manager from jndi " + this.tm));
            }
        }
        catch (NamingException e) {
            log.trace((Object)("Unable to lookup: " + TransactionManagerService.JNDI_NAME), (Throwable)e);
        }
        return this.tm;
    }

    protected TransactionManager usePrivateAPI() {
        log.trace((Object)"Using the JBoss transaction manager");
        return TxManager.getInstance();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

