/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmppoller.job;

import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.snmppoller.bean.PollingConfig;
import com.clustercontrol.snmppoller.job.PollingThread;
import com.clustercontrol.snmppoller.util.JNDIConnectionManager;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SnmpPollingJob
implements Job {
    protected static Log m_log = LogFactory.getLog(SnmpPollingJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        m_log.debug((Object)"execute start : ");
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String jndiName = dataMap.getString("jndiName");
        int interval = dataMap.getInt("interval");
        List oids = (List)dataMap.get((Object)"oidList");
        HashMap snmpConfMap = (HashMap)dataMap.get((Object)"snmpConfMap");
        try {
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Object obj = iniCtx.lookup(jndiName);
            SnmpSharedTable table = (SnmpSharedTable)PortableRemoteObject.narrow((Object)obj, SnmpSharedTable.class);
            for (String facilityId : snmpConfMap.keySet()) {
                table.setPollingInterval(facilityId, interval);
            }
            table.checkAll();
            for (String facilityId : snmpConfMap.keySet()) {
                PollingConfig pConfig = table.getConfig(facilityId);
                if (pConfig == null) continue;
                PollingThread pt = new PollingThread(pConfig.getSnmpConfig(), oids, jndiName, facilityId);
                Thread th = new Thread(pt);
                th.start();
            }
        }
        catch (NamingException e) {
            m_log.error((Object)e);
        }
        m_log.debug((Object)("execute end   : " + jndiName));
    }
}

