/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.util.Log;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.Comments;
import org.jfree.xml.generator.model.MappingModel;

public class DescriptionModel {
    private ArrayList sources;
    private ArrayList classes = new ArrayList();
    private HashMap classesMap = new HashMap();
    private MappingModel mappingModel = new MappingModel();
    private Comments modelComments;
    private HashMap includeComments;

    public DescriptionModel() {
        this.sources = new ArrayList();
        this.includeComments = new HashMap();
    }

    public void addClassDescription(ClassDescription classDescription) {
        this.classesMap.put(classDescription.getObjectClass(), classDescription);
        if (!this.classes.contains(classDescription)) {
            this.classes.add(classDescription);
        }
    }

    public void removeClassDescription(ClassDescription classDescription) {
        this.classesMap.remove(classDescription.getObjectClass());
        this.classes.remove(classDescription);
    }

    public ClassDescription get(int n) {
        return (ClassDescription)this.classes.get(n);
    }

    public ClassDescription get(Class clazz) {
        return (ClassDescription)this.classesMap.get(clazz);
    }

    public int size() {
        return this.classes.size();
    }

    public MappingModel getMappingModel() {
        return this.mappingModel;
    }

    public void addSource(String string) {
        this.sources.add(string);
    }

    public String[] getSources() {
        return this.sources.toArray(new String[this.sources.size()]);
    }

    public void prune() {
        ClassDescription[] classDescriptionArray = this.classes.toArray(new ClassDescription[0]);
        for (int i = 0; i < classDescriptionArray.length; ++i) {
            if (!classDescriptionArray[i].isUndefined()) continue;
            this.removeClassDescription(classDescriptionArray[i]);
            Log.debug("Pruned: " + classDescriptionArray[i].getName());
        }
    }

    public void addIncludeComment(String string, Comments comments) {
        this.includeComments.put(string, comments);
    }

    public Comments getIncludeComment(String string) {
        return (Comments)this.includeComments.get(string);
    }

    public Comments getModelComments() {
        return this.modelComments;
    }

    public void setModelComments(Comments comments) {
        Log.debug("Model: Comment set: " + comments);
        this.modelComments = comments;
    }
}

