/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.providers.java;

import java.lang.reflect.Method;
import java.util.Vector;
import org.jboss.axis.AxisFault;
import org.jboss.axis.MessageContext;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.i18n.Messages;
import org.jboss.axis.message.SOAPBodyElementAxisImpl;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.providers.java.JavaProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MsgProvider
extends JavaProvider {
    public void processMessage(MessageContext msgContext, SOAPEnvelopeAxisImpl reqEnv, SOAPEnvelopeAxisImpl resEnv, Object obj) throws Exception {
        OperationDesc operation = msgContext.getOperation();
        if (operation == null) {
            throw new AxisFault(Messages.getMessage("noOperationForQName", reqEnv.getFirstBody().getQName().toString()));
        }
        Method method = operation.getMethod();
        int methodType = operation.getMessageOperationStyle();
        if (methodType != 2) {
            Vector bodies = reqEnv.getBodyElements();
            Object[] argObjects = new Object[1];
            switch (methodType) {
                case 1: {
                    SOAPBodyElementAxisImpl[] bodyElements = new SOAPBodyElementAxisImpl[bodies.size()];
                    bodies.toArray(bodyElements);
                    argObjects[0] = bodyElements;
                    SOAPBodyElementAxisImpl[] bodyResult = (SOAPBodyElementAxisImpl[])method.invoke(obj, argObjects);
                    if (bodyResult != null) {
                        for (int i = 0; i < bodyResult.length; ++i) {
                            SOAPBodyElementAxisImpl bodyElement = bodyResult[i];
                            resEnv.addBodyElement(bodyElement);
                        }
                    }
                    return;
                }
                case 3: {
                    Element[] elements = new Element[bodies.size()];
                    for (int i = 0; i < elements.length; ++i) {
                        SOAPBodyElementAxisImpl body = (SOAPBodyElementAxisImpl)bodies.get(i);
                        elements[i] = body.getAsDOM();
                    }
                    argObjects[0] = elements;
                    Element[] elemResult = (Element[])method.invoke(obj, argObjects);
                    if (elemResult != null) {
                        for (int i = 0; i < elemResult.length; ++i) {
                            if (elemResult[i] == null) continue;
                            resEnv.addBodyElement(new SOAPBodyElementAxisImpl(elemResult[i]));
                        }
                    }
                    return;
                }
                case 4: {
                    Document doc = ((SOAPBodyElementAxisImpl)bodies.get(0)).getAsDocument();
                    argObjects[0] = doc;
                    Document resultDoc = (Document)method.invoke(obj, argObjects);
                    if (resultDoc != null) {
                        resEnv.addBodyElement(new SOAPBodyElementAxisImpl(resultDoc.getDocumentElement()));
                    }
                    return;
                }
            }
        } else {
            Object[] argObjects = new Object[]{reqEnv, resEnv};
            method.invoke(obj, argObjects);
            return;
        }
        throw new AxisFault(Messages.getMessage("badMsgMethodStyle"));
    }
}

