/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.message;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.jboss.axis.AxisFault;
import org.jboss.axis.MessagePart;
import org.jboss.axis.message.CDATAImpl;
import org.jboss.axis.message.CommentImpl;
import org.jboss.axis.message.SOAPBodyAxisImpl;
import org.jboss.axis.message.SOAPElementAxisImpl;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.message.SOAPFaultImpl;
import org.jboss.axis.message.SOAPHeaderAxisImpl;
import org.jboss.axis.message.TextImpl;
import org.jboss.axis.soap.SOAPConstants;
import org.jboss.axis.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class SOAPDocumentImpl
implements Document {
    Document delegate = null;
    MessagePart soapPart = null;
    private String[] features = new String[]{"foo", "bar"};
    private String version = "version 2.0";

    public SOAPDocumentImpl(MessagePart sp) {
        try {
            this.delegate = XMLUtils.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        this.soapPart = sp;
    }

    public DocumentType getDoctype() {
        return this.delegate.getDoctype();
    }

    public DOMImplementation getImplementation() {
        return this.delegate.getImplementation();
    }

    public Element getDocumentElement() {
        return this.soapPart.getDocumentElement();
    }

    public Element createElement(String tagName) throws DOMException {
        String localname;
        String prefix;
        int index = tagName.indexOf(":");
        if (index < 0) {
            prefix = "";
            localname = tagName;
        } else {
            prefix = tagName.substring(0, index);
            localname = tagName.substring(index + 1);
        }
        try {
            SOAPEnvelopeAxisImpl soapenv = (SOAPEnvelopeAxisImpl)this.soapPart.getEnvelope();
            if (soapenv != null) {
                if (tagName.equalsIgnoreCase("Envelope")) {
                    new SOAPEnvelopeAxisImpl();
                }
                if (tagName.equalsIgnoreCase("Header")) {
                    return new SOAPHeaderAxisImpl(soapenv, soapenv.getSOAPConstants());
                }
                if (tagName.equalsIgnoreCase("Body")) {
                    return new SOAPBodyAxisImpl(soapenv, soapenv.getSOAPConstants());
                }
                if (tagName.equalsIgnoreCase("Fault")) {
                    return new SOAPEnvelopeAxisImpl();
                }
                if (tagName.equalsIgnoreCase("detail")) {
                    return new SOAPFaultImpl(new AxisFault(tagName));
                }
                return new SOAPElementAxisImpl("", prefix, localname);
            }
            return new SOAPElementAxisImpl("", prefix, localname);
        }
        catch (SOAPException se) {
            throw new DOMException(11, "");
        }
    }

    public DocumentFragment createDocumentFragment() {
        return this.delegate.createDocumentFragment();
    }

    public Text createTextNode(String data) {
        return new TextImpl(this.delegate.createTextNode(data));
    }

    public Comment createComment(String data) {
        return new CommentImpl(this.createTextNode(data));
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return new CDATAImpl(this.createTextNode(data));
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new UnsupportedOperationException("createProcessingInstruction");
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.delegate.createAttribute(name);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        throw new UnsupportedOperationException("createEntityReference");
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw new UnsupportedOperationException("importNode");
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        SOAPConstants soapConstants = null;
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceURI)) {
            soapConstants = SOAPConstants.SOAP11_CONSTANTS;
        } else if ("http://www.w3.org/2002/12/soap-envelope".equals(namespaceURI)) {
            soapConstants = SOAPConstants.SOAP12_CONSTANTS;
        }
        SOAPElementAxisImpl me = null;
        if (soapConstants != null) {
            if (qualifiedName.equals("Envelope")) {
                me = new SOAPEnvelopeAxisImpl(soapConstants);
            } else if (qualifiedName.equals("Header")) {
                me = new SOAPHeaderAxisImpl(null, soapConstants);
            } else if (qualifiedName.equals("Body")) {
                me = new SOAPBodyAxisImpl(null, soapConstants);
            } else if (qualifiedName.equals("Fault")) {
                me = null;
            } else if (qualifiedName.equals("detail")) {
                me = null;
            } else {
                throw new DOMException(11, "No such Localname for SOAP URI");
            }
            return null;
        }
        me = new SOAPElementAxisImpl(namespaceURI, qualifiedName);
        if (me != null) {
            me.setOwnerDocument(this.soapPart);
        }
        return me;
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.delegate.createAttributeNS(namespaceURI, qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        try {
            if (this.soapPart != null) {
                SOAPEnvelopeAxisImpl soapEnv = (SOAPEnvelopeAxisImpl)this.soapPart.getEnvelope();
                SOAPHeaderAxisImpl header = (SOAPHeaderAxisImpl)soapEnv.getHeader();
                if (header != null) {
                    return header.getElementsByTagNameNS(namespaceURI, localName);
                }
                SOAPBodyAxisImpl body = (SOAPBodyAxisImpl)soapEnv.getHeader();
                if (body != null) {
                    return header.getElementsByTagNameNS(namespaceURI, localName);
                }
            }
            return null;
        }
        catch (SOAPException se) {
            throw new DOMException(11, "");
        }
    }

    public NodeList getElementsByTagName(String localName) {
        try {
            if (this.soapPart != null) {
                SOAPEnvelopeAxisImpl soapEnv = (SOAPEnvelopeAxisImpl)this.soapPart.getEnvelope();
                SOAPHeaderAxisImpl header = (SOAPHeaderAxisImpl)soapEnv.getHeader();
                if (header != null) {
                    return header.getElementsByTagName(localName);
                }
                SOAPBodyAxisImpl body = (SOAPBodyAxisImpl)soapEnv.getHeader();
                if (body != null) {
                    return header.getElementsByTagName(localName);
                }
            }
            return null;
        }
        catch (SOAPException se) {
            throw new DOMException(11, "");
        }
    }

    public Element getElementById(String elementId) {
        return this.delegate.getElementById(elementId);
    }

    public String getNodeName() {
        return null;
    }

    public String getNodeValue() throws DOMException {
        throw new DOMException(6, "Cannot use TextNode.get in " + this);
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        throw new DOMException(6, "Cannot use TextNode.set in " + this);
    }

    public short getNodeType() {
        return 9;
    }

    public Node getParentNode() {
        return null;
    }

    public NodeList getChildNodes() {
        throw new DOMException(9, "");
    }

    public Node getFirstChild() {
        try {
            if (this.soapPart != null) {
                return (SOAPEnvelopeAxisImpl)this.soapPart.getEnvelope();
            }
            return null;
        }
        catch (SOAPException se) {
            throw new DOMException(11, "");
        }
    }

    public Node getLastChild() {
        try {
            if (this.soapPart != null) {
                return (SOAPEnvelopeAxisImpl)this.soapPart.getEnvelope();
            }
            return null;
        }
        catch (SOAPException se) {
            throw new DOMException(11, "");
        }
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(9, "");
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DOMException(9, "");
    }

    public Node removeChild(Node oldChild) throws DOMException {
        try {
            SOAPEnvelope envNode;
            if (this.soapPart != null && (envNode = this.soapPart.getEnvelope()).equals(oldChild)) {
                return envNode;
            }
            throw new DOMException(9, "");
        }
        catch (SOAPException se) {
            throw new DOMException(11, "");
        }
    }

    public Node appendChild(Node newChild) throws DOMException {
        throw new DOMException(9, "");
    }

    public boolean hasChildNodes() {
        try {
            return this.soapPart != null && this.soapPart.getEnvelope() != null;
        }
        catch (SOAPException se) {
            throw new DOMException(11, "");
        }
    }

    public Node cloneNode(boolean deep) {
        throw new DOMException(9, "");
    }

    public void normalize() {
        throw new DOMException(9, "");
    }

    public boolean isSupported(String feature, String version) {
        return version.equalsIgnoreCase(version);
    }

    public String getPrefix() {
        throw new DOMException(9, "");
    }

    public void setPrefix(String prefix) {
        throw new DOMException(9, "");
    }

    public String getNamespaceURI() {
        throw new DOMException(9, "");
    }

    public void setNamespaceURI(String nsURI) {
        throw new DOMException(9, "");
    }

    public String getLocalName() {
        throw new DOMException(9, "");
    }

    public boolean hasAttributes() {
        throw new DOMException(9, "");
    }

    public String getInputEncoding() {
        return null;
    }

    public String getXmlEncoding() {
        return null;
    }

    public boolean getXmlStandalone() {
        return false;
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    public String getXmlVersion() {
        return null;
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    public String getDocumentURI() {
        return null;
    }

    public void setDocumentURI(String documentURI) {
    }

    public Node adoptNode(Node source) throws DOMException {
        return null;
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public void normalizeDocument() {
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
    }

    public boolean isSameNode(Node other) {
        return false;
    }

    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    public boolean isEqualNode(Node arg) {
        return false;
    }

    public Object getFeature(String feature, String version) {
        return null;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    public Object getUserData(String key) {
        return null;
    }
}

