/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.encoding.ser;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.jboss.axis.Constants;
import org.jboss.axis.encoding.SerializationContext;
import org.jboss.axis.encoding.ser.SimpleSerializer;
import org.jboss.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class DateSerializer
extends SimpleSerializer {
    private static SimpleDateFormat zuluDate = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat zuluDateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static Calendar calendar = Calendar.getInstance();
    protected QName defaultXmlType = Constants.XSD_DATE;

    public DateSerializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    private String convertToZoneString(long offset) {
        if (offset == 0L) {
            return "Z";
        }
        StringBuffer buffer = new StringBuffer();
        DecimalFormat hourFormat = new DecimalFormat("'+'00;-00");
        DecimalFormat minuteFormat = new DecimalFormat("00");
        int minutes = (int)offset / 60000;
        int hours = minutes / 60;
        return hourFormat.format(hours) + ":" + minuteFormat.format(minutes -= hours * 60);
    }

    private SimpleDateFormat getDateFormatForType(QName type) {
        if (type.equals(Constants.XSD_DATE)) {
            return zuluDate;
        }
        if (type.equals(Constants.XSD_DATETIME)) {
            return zuluDateTime;
        }
        return null;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        context.startElement(name, attributes);
        context.writeString(this.getValueAsString(value, context));
        context.endElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValueAsString(Object value, SerializationContext context) {
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat zulu = this.getDateFormatForType(this.xmlType);
        if (zulu == null) {
            zulu = this.getDateFormatForType(this.defaultXmlType);
        }
        if (zulu == null) {
            zulu = zuluDate;
        }
        if (value instanceof Calendar) {
            Calendar calendarValue = (Calendar)value;
            if (calendarValue.get(0) == 0) {
                buf.append("-");
            }
            SimpleDateFormat simpleDateFormat = zulu;
            synchronized (simpleDateFormat) {
                zulu.setCalendar(calendarValue);
                buf.append(zulu.format(calendarValue.getTime()));
            }
            buf.append(this.convertToZoneString(calendarValue.get(15) + calendarValue.get(16)));
        } else {
            Calendar calendar = DateSerializer.calendar;
            synchronized (calendar) {
                DateSerializer.calendar.setTime((Date)value);
                if (DateSerializer.calendar.get(0) == 0) {
                    buf.append("-");
                    DateSerializer.calendar.set(0, 1);
                    value = DateSerializer.calendar.getTime();
                }
                SimpleDateFormat simpleDateFormat = zulu;
                synchronized (simpleDateFormat) {
                    zulu.setCalendar(DateSerializer.calendar);
                    zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
                    buf.append(zulu.format((Date)value));
                }
                buf.append("Z");
            }
        }
        return buf.toString();
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        return null;
    }
}

