/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util.threadpool;

import java.util.LinkedList;
import org.jacorb.util.threadpool.ConsumerFactory;
import org.jacorb.util.threadpool.ConsumerTie;

public class ThreadPool {
    private int max_threads = 0;
    private int max_idle_threads = 0;
    private int total_threads = 0;
    private int idle_threads = 0;
    private LinkedList job_queue = null;
    private ConsumerFactory factory = null;

    public ThreadPool(ConsumerFactory consumerFactory) {
        this(new LinkedList(), consumerFactory, 10, 10);
    }

    public ThreadPool(ConsumerFactory consumerFactory, int n, int n2) {
        this(new LinkedList(), consumerFactory, n, n2);
    }

    private ThreadPool(LinkedList linkedList, ConsumerFactory consumerFactory, int n, int n2) {
        this.job_queue = linkedList;
        this.factory = consumerFactory;
        this.max_threads = n;
        this.max_idle_threads = n2;
    }

    protected synchronized Object getJob() {
        if (this.idle_threads >= this.max_idle_threads) {
            --this.total_threads;
            return null;
        }
        ++this.idle_threads;
        while (this.job_queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.job_queue.removeFirst();
    }

    public synchronized void putJob(Object object) {
        this.job_queue.add(object);
        this.notifyAll();
        if (this.idle_threads <= 0) {
            if (this.total_threads < this.max_threads) {
                this.createNewThread();
                --this.idle_threads;
            }
        } else {
            --this.idle_threads;
        }
    }

    private void createNewThread() {
        Thread thread = new Thread(new ConsumerTie(this, this.factory.create()));
        thread.setDaemon(true);
        thread.start();
        ++this.total_threads;
    }
}

