/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.EncapsInfo;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;

public class CDRInputStream
extends InputStream {
    private int uniqueValue;
    private Stack encaps_stack;
    private Map recursiveTCMap;
    private Map cachedTypecodes;
    private int marked_pos;
    private int marked_index;
    private boolean closed;
    private Logger logger;
    private boolean useBOM;
    private boolean cometInteropFix;
    private boolean laxBooleanEncoding;
    private boolean cacheTypecodes;
    private int codeSet = CodeSet.getTCSDefault();
    private int codeSetW = CodeSet.getTCSWDefault();
    protected int giop_minor = 2;
    private Map valueMap;
    private int currentValueIndex;
    private Map repIdMap;
    private Map codebaseMap;
    public boolean littleEndian = false;
    protected byte[] buffer = null;
    protected int pos = 0;
    protected int index = 0;
    private boolean chunkedValue = false;
    private int valueNestingLevel = 0;
    private int chunk_end_pos = -1;
    private org.omg.CORBA.ORB orb = null;
    static /* synthetic */ Class class$org$omg$CORBA$portable$ObjectImpl;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;
    static /* synthetic */ Class class$org$omg$CORBA$Any;
    static /* synthetic */ Class class$org$omg$CORBA$portable$InputStream;

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray) {
        this.buffer = byArray;
        if (oRB != null) {
            this.orb = oRB;
            if (oRB instanceof ORB) {
                try {
                    this.configure((Configuration)((ORB)oRB).getConfiguration());
                }
                catch (ConfigurationException configurationException) {
                    throw new INTERNAL("ConfigurationException: " + configurationException.getMessage());
                }
            }
        } else {
            this.orb = org.omg.CORBA.ORB.init();
        }
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, boolean bl) {
        this(oRB, byArray);
        this.littleEndian = bl;
    }

    private void configure(Configuration configuration) throws ConfigurationException {
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.orb.cdr");
        this.useBOM = configuration.getAttribute("jacorb.use_bom", "off").equals("on");
        this.cometInteropFix = configuration.getAttribute("jacorb.interop.comet", "off").equals("on");
        this.laxBooleanEncoding = configuration.getAttribute("jacorb.interop.lax_boolean_encoding", "off").equals("on");
        this.cacheTypecodes = configuration.getAttribute("jacorb.cacheTypecodes", "off").equals("on");
    }

    private Stack getEncapsStack() {
        if (this.encaps_stack == null) {
            this.encaps_stack = new Stack();
        }
        return this.encaps_stack;
    }

    private Map getRecursiveTCMap() {
        if (this.recursiveTCMap == null) {
            this.recursiveTCMap = new HashMap();
        }
        return this.recursiveTCMap;
    }

    private Map getValueMap() {
        if (this.valueMap == null) {
            this.valueMap = new HashMap();
        }
        return this.valueMap;
    }

    private Map getRepIdMap() {
        if (this.repIdMap == null) {
            this.repIdMap = new HashMap();
        }
        return this.repIdMap;
    }

    private Map getCodebaseMap() {
        if (this.codebaseMap == null) {
            this.codebaseMap = new HashMap();
        }
        return this.codebaseMap;
    }

    private org.omg.CORBA.TypeCode getCachedTypecode(String string) {
        org.omg.CORBA.TypeCode typeCode = null;
        if (this.cacheTypecodes) {
            if (this.cachedTypecodes == null) {
                this.cachedTypecodes = new HashMap();
            } else {
                typeCode = (org.omg.CORBA.TypeCode)this.cachedTypecodes.get(string);
            }
        }
        return typeCode;
    }

    private void putCachedTypecode(String string, org.omg.CORBA.TypeCode typeCode) {
        if (this.cacheTypecodes) {
            this.cachedTypecodes.put(string, typeCode);
        }
    }

    public void setGIOPMinor(int n) {
        this.giop_minor = n;
    }

    public int getGIOPMinor() {
        return this.giop_minor;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        BufferManager.getInstance().returnBuffer(this.buffer);
        this.encaps_stack = null;
        this.recursiveTCMap = null;
        this.closed = true;
    }

    public org.omg.CORBA.ORB orb() {
        if (this.orb == null) {
            this.orb = org.omg.CORBA.ORB.init(new String[0], null);
        }
        return this.orb;
    }

    public void setCodeSet(int n, int n2) {
        this.codeSet = n;
        this.codeSetW = n2;
    }

    private static final int _read4int(boolean bl, byte[] byArray, int n) {
        if (bl) {
            return ((byArray[n + 3] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n] & 0xFF) << 0);
        }
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 3] & 0xFF) << 0);
    }

    private static final short _read2int(boolean bl, byte[] byArray, int n) {
        if (bl) {
            return (short)(((byArray[n + 1] & 0xFF) << 8) + ((byArray[n] & 0xFF) << 0));
        }
        return (short)(((byArray[n] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 0));
    }

    private final int _read_long() {
        int n = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return n;
    }

    private final long _read_longlong() {
        if (this.littleEndian) {
            return ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
        }
        return ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
    }

    private final void handle_chunking() {
        int n;
        int n2 = 4 - this.index % 4;
        int n3 = n = n2 != 4 ? this.pos + n2 : this.pos;
        if (this.chunk_end_pos >= this.pos && this.chunk_end_pos <= n) {
            this.chunk_end_pos = -1;
            int n4 = this.pos;
            int n5 = this.index;
            int n6 = this.read_long();
            if (n6 < 0) {
                if (-n6 > this.valueNestingLevel) {
                    throw new INTERNAL("received end tag " + n6 + " with value nesting level " + this.valueNestingLevel);
                }
                this.valueNestingLevel = -n6;
                --this.valueNestingLevel;
                if (this.valueNestingLevel > 0) {
                    this.chunk_end_pos = this.pos;
                    this.handle_chunking();
                }
            } else if (n6 < 0x7FFFFF00) {
                this.chunk_end_pos = this.pos + n6;
            } else {
                this.pos = n4;
                this.index = n5;
            }
        }
    }

    protected final void skip(int n) {
        this.pos += n;
        this.index += n;
    }

    public final void closeEncapsulation() {
        if (this.encaps_stack == null) {
            throw new MARSHAL("Internal Error - closeEncapsulation failed");
        }
        EncapsInfo encapsInfo = (EncapsInfo)this.encaps_stack.pop();
        this.littleEndian = encapsInfo.littleEndian;
        int n = encapsInfo.start;
        int n2 = encapsInfo.size;
        if (this.pos < n + n2) {
            this.pos = n + n2;
        }
        this.index = encapsInfo.index + n2;
    }

    public final int openEncapsulation() {
        boolean bl = this.littleEndian;
        int n = this.pos;
        int n2 = this.read_long();
        if (this.cometInteropFix && (n2 < 0 || n2 > this.buffer.length)) {
            int n3 = (n2 >> 24 & 0xFF) + (n2 >> 8 & 0xFF00) + (n2 << 8 & 0xFF0000) + (n2 << 24 & 0xFF000000);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Size of CDR encapsulation larger than buffer, swapping byte order\nSize of CDR encapsulation was " + n2 + ", is now " + n3);
            }
            n2 = n3;
        }
        if (this.encaps_stack == null) {
            this.encaps_stack = new Stack();
        }
        this.encaps_stack.push(new EncapsInfo(bl, this.index, this.pos, n2));
        this.openEncapsulatedArray();
        return n2;
    }

    public final void openEncapsulatedArray() {
        this.resetIndex();
        this.littleEndian = this.read_boolean();
    }

    public byte[] getBufferCopy() {
        byte[] byArray = new byte[this.buffer.length];
        System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
        return byArray;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        if (this.available() < 1) {
            return -1;
        }
        ++this.index;
        return this.buffer[this.pos++];
    }

    public int available() {
        return this.buffer.length - this.index;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.available() < 1) {
            return -1;
        }
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        int n3 = n2 < this.available() ? n2 : this.available();
        System.arraycopy(this.buffer, this.index, byArray, n, n3);
        this.pos += n3;
        this.index += n3;
        return n3;
    }

    public final Any read_any() {
        org.omg.CORBA.TypeCode typeCode = this.read_TypeCode();
        Any any = this.orb.create_any();
        any.read_value(this, typeCode);
        return any;
    }

    public final boolean read_boolean() {
        this.handle_chunking();
        ++this.index;
        byte by = this.buffer[this.pos++];
        if (by == 0) {
            return false;
        }
        if (by == 1) {
            return true;
        }
        if (this.laxBooleanEncoding) {
            return true;
        }
        throw new MARSHAL("Unexpected boolean value: " + by + " pos: " + this.pos + " index: " + this.index);
    }

    public final void read_boolean_array(boolean[] blArray, int n, int n2) {
        this.handle_chunking();
        for (int i = n; i < n + n2; ++i) {
            byte by;
            ++this.index;
            if ((by = this.buffer[this.pos++]) == 1) {
                blArray[i] = true;
                continue;
            }
            if (by == 0) {
                blArray[i] = false;
                continue;
            }
            throw new MARSHAL("Unexpected boolean value: " + by + " pos: " + this.pos + " index: " + this.index);
        }
    }

    public final char read_char() {
        this.handle_chunking();
        ++this.index;
        return (char)(0xFF & this.buffer[this.pos++]);
    }

    public final void read_char_array(char[] cArray, int n, int n2) {
        this.handle_chunking();
        for (int i = n; i < n + n2; ++i) {
            ++this.index;
            cArray[i] = (char)(0xFF & this.buffer[this.pos++]);
        }
    }

    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public final void read_double_array(double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 8 - this.index % 8;
        if (n3 != 8) {
            this.index += n3;
            this.pos += n3;
        }
        for (int i = n; i < n + n2; ++i) {
            dArray[i] = Double.longBitsToDouble(this._read_longlong());
        }
    }

    public final BigDecimal read_fixed() {
        this.handle_chunking();
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.buffer[this.pos++];
        int n = by & 0xF;
        ++this.index;
        while (true) {
            n = (by & 0xF0) >>> 4;
            stringBuffer.append(n);
            n = by & 0xF;
            if (n == 12 || n == 13) break;
            stringBuffer.append(n);
            by = this.buffer[this.pos++];
            ++this.index;
        }
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(stringBuffer.toString()));
        if (n == 13) {
            return bigDecimal.negate();
        }
        return bigDecimal;
    }

    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public final void read_float_array(float[] fArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 4 - this.index % 4;
        if (n3 != 4) {
            this.index += n3;
            this.pos += n3;
        }
        for (int i = n; i < n + n2; ++i) {
            fArray[i] = Float.intBitsToFloat(this._read_long());
        }
    }

    public final int read_long() {
        this.handle_chunking();
        int n = 4 - this.index % 4;
        if (n != 4) {
            this.index += n;
            this.pos += n;
        }
        int n2 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return n2;
    }

    public final void read_long_array(int[] nArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 4 - this.index % 4;
        if (n3 != 4) {
            this.index += n3;
            this.pos += n3;
        }
        for (int i = n; i < n + n2; ++i) {
            nArray[i] = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.pos += 4;
        }
        this.index += 4 * n2;
    }

    public final long read_longlong() {
        this.handle_chunking();
        int n = 8 - this.index % 8;
        if (n != 8) {
            this.index += n;
            this.pos += n;
        }
        if (this.littleEndian) {
            return ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
        }
        return ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
    }

    public final void read_longlong_array(long[] lArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 8 - this.index % 8;
        if (n3 != 8) {
            this.index += n3;
            this.pos += n3;
        }
        if (this.littleEndian) {
            for (int i = n; i < n + n2; ++i) {
                lArray[i] = ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
            }
        } else {
            for (int i = n; i < n + n2; ++i) {
                lArray[i] = ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
            }
        }
    }

    public final Object read_Object() {
        this.handle_chunking();
        IOR iOR = IORHelper.read(this);
        ParsedIOR parsedIOR = new ParsedIOR(iOR, (ORB)this.orb, this.logger);
        if (parsedIOR.isNull()) {
            return null;
        }
        if (!(this.orb instanceof ORB)) {
            throw new MARSHAL("Cannot use the singleton ORB to receive object references, please initialize a full ORB instead.");
        }
        return ((ORB)this.orb)._getObject(parsedIOR);
    }

    public Object read_Object(Class clazz) {
        if ((class$org$omg$CORBA$portable$ObjectImpl == null ? (class$org$omg$CORBA$portable$ObjectImpl = CDRInputStream.class$("org.omg.CORBA.portable.ObjectImpl")) : class$org$omg$CORBA$portable$ObjectImpl).isAssignableFrom(clazz)) {
            Object object = this.read_Object();
            if (object instanceof ObjectImpl) {
                ObjectImpl objectImpl = null;
                try {
                    objectImpl = (ObjectImpl)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new MARSHAL("Exception in stub instantiation: " + instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new MARSHAL("Exception in stub instantiation: " + illegalAccessException);
                }
                objectImpl._set_delegate(((ObjectImpl)object)._get_delegate());
                return objectImpl;
            }
            return object;
        }
        if (clazz.isInterface() && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = CDRInputStream.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
            return (Object)ValueHandler.portableRemoteObject_narrow(this.read_Object(), clazz);
        }
        return this.read_Object();
    }

    public final byte read_octet() {
        this.handle_chunking();
        ++this.index;
        return this.buffer[this.pos++];
    }

    public final void read_octet_array(byte[] byArray, int n, int n2) {
        this.handle_chunking();
        System.arraycopy(this.buffer, this.pos, byArray, n, n2);
        this.index += n2;
        this.pos += n2;
    }

    public final Principal read_Principal() {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    public final short read_short() {
        this.handle_chunking();
        int n = 2 - this.index % 2;
        if (n != 2) {
            this.index += n;
            this.pos += n;
        }
        short s = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
        this.pos += 2;
        this.index += 2;
        return s;
    }

    public final void read_short_array(short[] sArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 2 - this.index % 2;
        if (n3 != 2) {
            this.index += n3;
            this.pos += n3;
        }
        for (int i = n; i < n + n2; ++i) {
            sArray[i] = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
            this.pos += 2;
        }
        this.index += n2 * 2;
    }

    public final String read_string() {
        String string = null;
        this.handle_chunking();
        int n = 4 - this.index % 4;
        if (n != 4) {
            this.index += n;
            this.pos += n;
        }
        int n2 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = (char)(0xFF & this.buffer[this.pos++]);
        }
        this.index += n2;
        string = n2 > 0 && cArray[n2 - 1] == '\u0000' ? new String(cArray, 0, n2 - 1) : new String(cArray);
        cArray = null;
        return string;
    }

    public final org.omg.CORBA.TypeCode read_TypeCode() {
        HashMap hashMap = new HashMap();
        org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(hashMap);
        hashMap = null;
        return typeCode;
    }

    private final org.omg.CORBA.TypeCode read_TypeCode(Map map) {
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        org.omg.CORBA.TypeCode typeCode = null;
        org.omg.CORBA.TypeCode typeCode2 = null;
        String[] stringArray = null;
        int n4 = this.read_long();
        int n5 = this.pos - 4;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Read Type code of kind " + n4 + " at pos: " + n5);
        }
        switch (n4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 26: {
                typeCode = this.orb.get_primitive_tc(TCKind.from_int(n4));
                break;
            }
            case 14: {
                n3 = this.openEncapsulation();
                string = this.validateID(this.read_string());
                typeCode = this.getCachedTypecode(string);
                if (typeCode != null) {
                    this.skip(n3 - (this.pos - n5 - 4 - 4));
                } else {
                    string2 = this.validateName(this.read_string());
                    typeCode = this.orb.create_interface_tc(string, string2);
                    this.putCachedTypecode(string, typeCode);
                }
                this.closeEncapsulation();
                break;
            }
            case 15: {
                n3 = this.openEncapsulation();
                string = this.validateID(this.read_string());
                typeCode = this.getCachedTypecode(string);
                if (typeCode != null) {
                    this.skip(n3 - (this.pos - n5 - 4 - 4));
                    map.put(new Integer(n5), string);
                } else {
                    string2 = this.validateName(this.read_string());
                    n = this.read_long();
                    map.put(new Integer(n5), string);
                    StructMember[] structMemberArray = new StructMember[n];
                    for (int i = 0; i < n; ++i) {
                        structMemberArray[i] = new StructMember(this.validateMember(this.read_string()), this.read_TypeCode(map), null);
                    }
                    typeCode = this.orb.create_struct_tc(string, string2, structMemberArray);
                    this.putCachedTypecode(string, typeCode);
                }
                this.getRecursiveTCMap().put(string, typeCode);
                this.closeEncapsulation();
                break;
            }
            case 22: {
                n3 = this.openEncapsulation();
                string = this.validateID(this.read_string());
                typeCode = this.getCachedTypecode(string);
                if (typeCode != null) {
                    this.skip(n3 - (this.pos - n5 - 4 - 4));
                    map.put(new Integer(n5), string);
                } else {
                    string2 = this.validateName(this.read_string());
                    n = this.read_long();
                    map.put(new Integer(n5), string);
                    StructMember[] structMemberArray = new StructMember[n];
                    for (int i = 0; i < n; ++i) {
                        structMemberArray[i] = new StructMember(this.validateMember(this.read_string()), this.read_TypeCode(), null);
                    }
                    typeCode = this.orb.create_struct_tc(string, string2, structMemberArray);
                    this.putCachedTypecode(string, typeCode);
                }
                this.getRecursiveTCMap().put(string, typeCode);
                this.closeEncapsulation();
                break;
            }
            case 17: {
                n3 = this.openEncapsulation();
                string = this.validateID(this.read_string());
                typeCode = this.getCachedTypecode(string);
                if (typeCode != null) {
                    this.skip(n3 - (this.pos - n5 - 4 - 4));
                    map.put(new Integer(n5), string);
                } else {
                    string2 = this.validateName(this.read_string());
                    n = this.read_long();
                    map.put(new Integer(n5), string);
                    stringArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = this.validateMember(this.read_string());
                    }
                    typeCode = this.orb.create_enum_tc(string, string2, stringArray);
                    this.putCachedTypecode(string, typeCode);
                }
                this.getRecursiveTCMap().put(string, typeCode);
                this.closeEncapsulation();
                break;
            }
            case 16: {
                n3 = this.openEncapsulation();
                string = this.validateID(this.read_string());
                typeCode = this.getCachedTypecode(string);
                if (typeCode != null) {
                    this.skip(n3 - (this.pos - n5 - 4 - 4));
                    map.put(new Integer(n5), string);
                } else {
                    string2 = this.validateName(this.read_string());
                    map.put(new Integer(n5), string);
                    org.omg.CORBA.TypeCode typeCode3 = this.read_TypeCode(map);
                    org.omg.CORBA.TypeCode typeCode4 = TypeCode.originalType(typeCode3);
                    int n6 = this.read_long();
                    n = this.read_long();
                    UnionMember[] unionMemberArray = new UnionMember[n];
                    for (int i = 0; i < n; ++i) {
                        Any any = this.orb.create_any();
                        if (i == n6) {
                            any.insert_octet(this.read_octet());
                        } else {
                            any.read_value(this, typeCode4);
                        }
                        unionMemberArray[i] = new UnionMember(this.validateMember(this.read_string()), any, this.read_TypeCode(map), null);
                    }
                    typeCode = this.orb.create_union_tc(string, string2, typeCode3, unionMemberArray);
                    this.putCachedTypecode(string, typeCode);
                }
                this.getRecursiveTCMap().put(string, typeCode);
                this.closeEncapsulation();
                break;
            }
            case 18: {
                typeCode = this.orb.create_string_tc(this.read_long());
                break;
            }
            case 27: {
                typeCode = this.orb.create_wstring_tc(this.read_long());
                break;
            }
            case 28: {
                typeCode = this.orb.create_fixed_tc(this.read_ushort(), this.read_short());
                break;
            }
            case 20: {
                this.openEncapsulation();
                typeCode2 = this.read_TypeCode(map);
                n2 = this.read_long();
                this.closeEncapsulation();
                typeCode = this.orb.create_array_tc(n2, typeCode2);
                break;
            }
            case 19: {
                this.openEncapsulation();
                typeCode2 = this.read_TypeCode(map);
                n2 = this.read_long();
                this.closeEncapsulation();
                typeCode = this.orb.create_sequence_tc(n2, typeCode2);
                break;
            }
            case 21: {
                n3 = this.openEncapsulation();
                string = this.validateID(this.read_string());
                typeCode = this.getCachedTypecode(string);
                if (typeCode != null) {
                    this.skip(n3 - (this.pos - n5 - 4 - 4));
                    map.put(new Integer(n5), string);
                } else {
                    string2 = this.validateName(this.read_string());
                    map.put(new Integer(n5), string);
                    typeCode2 = this.read_TypeCode(map);
                    typeCode = this.orb.create_alias_tc(string, string2, typeCode2);
                    this.putCachedTypecode(string, typeCode);
                }
                this.getRecursiveTCMap().put(string, typeCode);
                this.closeEncapsulation();
                break;
            }
            case 29: {
                n3 = this.openEncapsulation();
                string = this.validateID(this.read_string());
                typeCode = this.getCachedTypecode(string);
                if (typeCode != null) {
                    this.skip(n3 - (this.pos - n5 - 4 - 4));
                    map.put(new Integer(n5), string);
                } else {
                    string2 = this.validateName(this.read_string());
                    map.put(new Integer(n5), string);
                    short s = this.read_short();
                    org.omg.CORBA.TypeCode typeCode5 = this.read_TypeCode(map);
                    n = this.read_long();
                    ValueMember[] valueMemberArray = new ValueMember[n];
                    for (int i = 0; i < n; ++i) {
                        valueMemberArray[i] = new ValueMember(this.validateMember(this.read_string()), null, null, null, this.read_TypeCode(map), null, this.read_short());
                    }
                    typeCode = this.orb.create_value_tc(string, string2, s, typeCode5, valueMemberArray);
                    this.putCachedTypecode(string, typeCode);
                }
                this.getRecursiveTCMap().put(string, typeCode);
                this.closeEncapsulation();
                break;
            }
            case 30: {
                n3 = this.openEncapsulation();
                string = this.validateID(this.read_string());
                typeCode = this.getCachedTypecode(string);
                if (typeCode != null) {
                    this.skip(n3 - (this.pos - n5 - 4 - 4));
                    map.put(new Integer(n5), string);
                } else {
                    string2 = this.validateName(this.read_string());
                    map.put(new Integer(n5), string);
                    typeCode2 = this.read_TypeCode(map);
                    typeCode = this.orb.create_value_box_tc(string, string2, typeCode2);
                    this.putCachedTypecode(string, typeCode);
                }
                this.getRecursiveTCMap().put(string, typeCode);
                this.closeEncapsulation();
                break;
            }
            case 32: {
                n3 = this.openEncapsulation();
                string = this.validateID(this.read_string());
                typeCode = this.getCachedTypecode(string);
                if (typeCode != null) {
                    this.skip(n3 - (this.pos - n5 - 4 - 4));
                } else {
                    string2 = this.validateName(this.read_string());
                    typeCode = this.orb.create_abstract_interface_tc(string, string2);
                    this.putCachedTypecode(string, typeCode);
                }
                this.closeEncapsulation();
                break;
            }
            case -1: {
                int n7 = this.read_long();
                String string3 = (String)map.get(new Integer(this.pos - 4 + n7));
                if (string3 == null) {
                    throw new INTERNAL("No recursive TypeCode! (pos: " + (this.pos - 4 + n7) + ")");
                }
                org.omg.CORBA.TypeCode typeCode6 = (org.omg.CORBA.TypeCode)this.getRecursiveTCMap().get(string3);
                if (typeCode6 == null) {
                    typeCode6 = this.orb.create_recursive_tc(string3);
                }
                typeCode = typeCode6;
                break;
            }
            default: {
                throw new MARSHAL("Cannot handle TypeCode with kind " + n4);
            }
        }
        return typeCode;
    }

    public final int read_ulong() {
        this.handle_chunking();
        int n = 4 - this.index % 4;
        if (n != 4) {
            this.index += n;
            this.pos += n;
        }
        int n2 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return n2;
    }

    public final void read_ulong_array(int[] nArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 4 - this.index % 4;
        if (n3 != 4) {
            this.index += n3;
            this.pos += n3;
        }
        for (int i = n; i < n + n2; ++i) {
            nArray[i] = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.pos += 4;
        }
        this.index += 4 * n2;
    }

    public final long read_ulonglong() {
        this.handle_chunking();
        int n = 8 - this.index % 8;
        if (n != 8) {
            this.index += n;
            this.pos += n;
        }
        if (this.littleEndian) {
            return ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
        }
        return ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
    }

    public final void read_ulonglong_array(long[] lArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 8 - this.index % 8;
        if (n3 != 8) {
            this.index += n3;
            this.pos += n3;
        }
        if (this.littleEndian) {
            for (int i = n; i < n + n2; ++i) {
                lArray[i] = ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
            }
        } else {
            for (int i = n; i < n + n2; ++i) {
                lArray[i] = ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
            }
        }
    }

    public final short read_ushort() {
        this.handle_chunking();
        int n = 2 - this.index % 2;
        if (n != 2) {
            this.index += n;
            this.pos += n;
        }
        short s = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
        this.pos += 2;
        this.index += 2;
        return s;
    }

    public final void read_ushort_array(short[] sArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 2 - this.index % 2;
        if (n3 != 2) {
            this.index += n3;
            this.pos += n3;
        }
        for (int i = n; i < n + n2; ++i) {
            sArray[i] = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
            this.pos += 2;
        }
        this.index += n2 * 2;
    }

    public final char read_wchar() {
        this.handle_chunking();
        if (this.giop_minor == 2) {
            this.read_wchar_size();
            boolean bl = this.readBOM();
            return this.read_wchar(bl);
        }
        return this.read_wchar(this.littleEndian);
    }

    private final int read_wchar_size() {
        ++this.index;
        return this.buffer[this.pos++];
    }

    private final char read_wchar(boolean bl) {
        switch (this.codeSetW) {
            case 0x5010001: {
                if (this.giop_minor < 2) {
                    throw new MARSHAL("GIOP 1." + this.giop_minor + " only allows 2 Byte encodings for wchar, but the selected TCSW is UTF-8");
                }
                short s = (short)(0xFF & this.buffer[this.pos++]);
                ++this.index;
                if ((s & 0x80) == 0) {
                    return (char)s;
                }
                if ((s & 0xE0) == 192) {
                    ++this.index;
                    return (char)((s & 0x1F) << 6 | (short)this.buffer[this.pos++] & 0x3F);
                }
                this.index += 2;
                short s2 = (short)(0xFF & this.buffer[this.pos++]);
                return (char)((s & 0xF) << 12 | (s2 & 0x3F) << 6 | (short)this.buffer[this.pos++] & 0x3F);
            }
            case 65801: {
                char c = bl ? (char)(this.buffer[this.pos++] & 0xFF | this.buffer[this.pos++] << 8) : (char)(this.buffer[this.pos++] << 8 | this.buffer[this.pos++] & 0xFF);
                this.index += 2;
                return c;
            }
        }
        throw new MARSHAL("Bad CodeSet: " + this.codeSetW);
    }

    private final boolean readBOM() {
        if (this.buffer[this.pos] == -2 && this.buffer[this.pos + 1] == -1) {
            this.pos += 2;
            this.index += 2;
            return false;
        }
        if (this.buffer[this.pos] == -1 && this.buffer[this.pos + 1] == -2) {
            this.pos += 2;
            this.index += 2;
            return true;
        }
        return false;
    }

    public final void read_wchar_array(char[] cArray, int n, int n2) {
        this.handle_chunking();
        for (int i = n; i < n + n2; ++i) {
            cArray[i] = this.read_wchar();
        }
    }

    public final String read_wstring() {
        String string = null;
        char[] cArray = null;
        this.handle_chunking();
        int n = 4 - this.index % 4;
        if (n != 4) {
            this.index += n;
            this.pos += n;
        }
        if (this.giop_minor == 2) {
            int n2 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.index += 4;
            this.pos += 4;
            if (n2 == 0) {
                return "";
            }
            cArray = new char[n2];
            int n3 = 0;
            int n4 = this.pos + n2;
            boolean bl = this.readBOM();
            while (this.pos < n4) {
                cArray[n3++] = this.read_wchar(bl);
            }
            string = new String(cArray, 0, n3);
        } else {
            int n5 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.index += 4;
            this.pos += 4;
            cArray = new char[n5];
            int n6 = this.pos + n5;
            if (this.codeSetW == 65801) {
                n6 += n5;
            }
            int n7 = 0;
            while (this.pos < n6) {
                cArray[n7++] = this.read_wchar(this.littleEndian);
            }
            string = n7 != 0 && cArray[n7 - 1] == '\u0000' ? new String(cArray, 0, n7 - 1) : new String(cArray, 0, n7);
        }
        cArray = null;
        return string;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.marked_pos = this.pos;
        this.marked_index = this.index;
    }

    public void reset() throws IOException {
        if (this.pos < 0) {
            throw new MARSHAL("Mark has not been set!");
        }
        this.pos = this.marked_pos;
        this.index = this.marked_index;
    }

    private final void resetIndex() {
        this.index = 0;
    }

    public final void setLittleEndian(boolean bl) {
        this.littleEndian = bl;
    }

    final void read_value(org.omg.CORBA.TypeCode typeCode, org.omg.CORBA.portable.OutputStream outputStream) {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        int n = typeCode.kind().value();
        try {
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                case 8: {
                    outputStream.write_boolean(this.read_boolean());
                    break;
                }
                case 9: {
                    outputStream.write_char(this.read_char());
                    break;
                }
                case 26: {
                    outputStream.write_wchar(this.read_wchar());
                    break;
                }
                case 10: {
                    outputStream.write_octet(this.read_octet());
                    break;
                }
                case 4: {
                    outputStream.write_ushort(this.read_ushort());
                    break;
                }
                case 2: {
                    outputStream.write_short(this.read_short());
                    break;
                }
                case 3: {
                    outputStream.write_long(this.read_long());
                    break;
                }
                case 5: {
                    outputStream.write_ulong(this.read_ulong());
                    break;
                }
                case 6: {
                    outputStream.write_float(this.read_float());
                    break;
                }
                case 7: {
                    outputStream.write_double(this.read_double());
                    break;
                }
                case 23: {
                    outputStream.write_longlong(this.read_longlong());
                    break;
                }
                case 24: {
                    outputStream.write_ulonglong(this.read_ulonglong());
                    break;
                }
                case 11: {
                    outputStream.write_any(this.read_any());
                    break;
                }
                case 12: {
                    outputStream.write_TypeCode(this.read_TypeCode());
                    break;
                }
                case 13: {
                    throw new NO_IMPLEMENT("Principal deprecated");
                }
                case 14: {
                    outputStream.write_Object(this.read_Object());
                    break;
                }
                case 18: {
                    outputStream.write_string(this.read_string());
                    break;
                }
                case 27: {
                    outputStream.write_wstring(this.read_wstring());
                    break;
                }
                case 28: {
                    outputStream.write_fixed(this.read_fixed());
                    break;
                }
                case 20: {
                    int n2 = typeCode.length();
                    for (int i = 0; i < n2; ++i) {
                        this.read_value(typeCode.content_type(), outputStream);
                    }
                    break;
                }
                case 19: {
                    int n3 = this.read_long();
                    outputStream.write_long(n3);
                    for (int i = 0; i < n3; ++i) {
                        this.read_value(typeCode.content_type(), outputStream);
                    }
                    break;
                }
                case 22: {
                    outputStream.write_string(this.read_string());
                }
                case 15: {
                    for (int i = 0; i < typeCode.member_count(); ++i) {
                        this.read_value(typeCode.member_type(i), outputStream);
                    }
                    break;
                }
                case 17: {
                    outputStream.write_long(this.read_long());
                    break;
                }
                case 21: {
                    this.read_value(typeCode.content_type(), outputStream);
                    break;
                }
                case 30: {
                    String string = typeCode.id();
                    BoxedValueHelper boxedValueHelper = ((ORB)this.orb).getBoxedValueHelper(string);
                    if (boxedValueHelper == null) {
                        throw new MARSHAL("No BoxedValueHelper for id " + string);
                    }
                    Serializable serializable = this.read_value(boxedValueHelper);
                    ((OutputStream)outputStream).write_value(serializable, boxedValueHelper);
                    break;
                }
                case 16: {
                    org.omg.CORBA.TypeCode typeCode2 = typeCode.discriminator_type();
                    typeCode2 = TypeCode.originalType(typeCode2);
                    int n4 = typeCode.default_index();
                    int n5 = -1;
                    block32 : switch (typeCode2.kind().value()) {
                        case 2: {
                            short s = this.read_short();
                            outputStream.write_short(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || s != typeCode.member_label(i).extract_short()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 3: {
                            int n6 = this.read_long();
                            outputStream.write_long(n6);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || n6 != typeCode.member_label(i).extract_long()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 4: {
                            short s = this.read_ushort();
                            outputStream.write_ushort(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || s != typeCode.member_label(i).extract_ushort()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 5: {
                            int n7 = this.read_ulong();
                            outputStream.write_ulong(n7);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || n7 != typeCode.member_label(i).extract_ulong()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 23: {
                            long l = this.read_longlong();
                            outputStream.write_longlong(l);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || l != typeCode.member_label(i).extract_longlong()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 24: {
                            long l = this.read_ulonglong();
                            outputStream.write_ulonglong(l);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || l != typeCode.member_label(i).extract_ulonglong()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 9: {
                            char c = this.read_char();
                            outputStream.write_char(c);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || c != typeCode.member_label(i).extract_char()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 8: {
                            boolean bl = this.read_boolean();
                            outputStream.write_boolean(bl);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n4 || bl != typeCode.member_label(i).extract_boolean()) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        case 17: {
                            int n8 = this.read_long();
                            outputStream.write_long(n8);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                int n9;
                                if (i == n4 || n8 != (n9 = typeCode.member_label(i).create_input_stream().read_long())) continue;
                                n5 = i;
                                break block32;
                            }
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid union discriminator type: " + typeCode2);
                        }
                    }
                    if (n5 != -1) {
                        this.read_value(typeCode.member_type(n5), outputStream);
                        break;
                    }
                    if (n4 != -1) {
                        this.read_value(typeCode.member_type(n4), outputStream);
                    }
                    break;
                }
                case -1: {
                    org.omg.CORBA.TypeCode typeCode3 = (org.omg.CORBA.TypeCode)this.getRecursiveTCMap().get(typeCode.id());
                    if (typeCode3 == null) {
                        throw new MARSHAL("No recursive TC found for " + typeCode.id());
                    }
                    this.read_value(typeCode3, outputStream);
                    break;
                }
                default: {
                    throw new MARSHAL("Cannot handle TypeCode with kind " + n);
                }
            }
        }
        catch (BadKind badKind) {
            throw new MARSHAL("When processing TypeCode with kind: " + n + " caught " + badKind);
        }
        catch (Bounds bounds) {
            throw new MARSHAL("When processing TypeCode with kind: " + n + " caught " + bounds);
        }
    }

    public Serializable read_value() {
        int n = this.read_long();
        int n2 = this.pos - 4;
        if (n == -1) {
            return this.read_indirect_value();
        }
        if (n == 0) {
            return null;
        }
        String string = (n & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (n & 8) != 0;
        int n3 = n;
        if ((n &= 0xFFFFFFF6) == 0x7FFFFF00) {
            throw new MARSHAL("missing value type information");
        }
        if (n == 2147483394) {
            return this.read_typed_value(n2, string);
        }
        if (n == 2147483398) {
            return this.read_multi_typed_value(n2, string);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(n3) + " (offset=0x" + Integer.toHexString(n2) + ")");
    }

    public Serializable read_value(String string) {
        int n = this.read_long();
        int n2 = this.pos - 4;
        if (n == -1) {
            return this.read_indirect_value();
        }
        if (n == 0) {
            return null;
        }
        String string2 = (n & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (n & 8) != 0;
        int n3 = n;
        if ((n &= 0xFFFFFFF6) == 0x7FFFFF00) {
            return this.read_untyped_value(new String[]{string}, n2, string2);
        }
        if (n == 2147483394) {
            return this.read_typed_value(n2, string2);
        }
        if (n == 2147483398) {
            return this.read_multi_typed_value(n2, string2);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(n3) + " (offset=0x" + Integer.toHexString(n2) + ")");
    }

    public Serializable read_value(Serializable serializable) {
        if (serializable instanceof Streamable) {
            this.register_value(serializable);
            ((Streamable)((java.lang.Object)serializable))._read(this);
            return serializable;
        }
        throw new BAD_PARAM("read_value is only implemented for Streamables");
    }

    public Serializable read_value(Class clazz) {
        int n = this.read_long();
        int n2 = this.pos - 4;
        if (n == -1) {
            return this.read_indirect_value();
        }
        if (n == 0) {
            return null;
        }
        String string = (n & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (n & 8) != 0;
        int n3 = n;
        if ((n &= 0xFFFFFFF6) == 0x7FFFFF00) {
            return this.read_untyped_value(new String[]{ValueHandler.getRMIRepositoryID(clazz)}, n2, string);
        }
        if (n == 2147483394) {
            return this.read_typed_value(n2, string);
        }
        if (n == 2147483398) {
            return this.read_multi_typed_value(n2, string);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(n3) + " (offset=0x" + Integer.toHexString(n2) + ")");
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        int n = this.read_long();
        int n2 = this.pos - 4;
        if (n == -1) {
            return this.read_indirect_value();
        }
        if (n == 0) {
            return null;
        }
        String string = (n & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (n & 8) != 0;
        int n3 = n;
        if ((n &= 0xFFFFFFF6) == 0x7FFFFF00) {
            Serializable serializable = boxedValueHelper.read_value(this);
            if (serializable != null) {
                this.getValueMap().put(new Integer(n2), serializable);
            }
            return serializable;
        }
        if (n == 2147483394) {
            return this.read_typed_value(n2, string);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(n3) + " (offset=0x" + Integer.toHexString(n2) + ")");
    }

    private Serializable read_untyped_value(String[] stringArray, int n, String string) {
        int n2;
        Serializable serializable = null;
        if (this.chunkedValue || this.valueNestingLevel > 0) {
            ++this.valueNestingLevel;
            n2 = this.read_long();
            this.chunk_end_pos = this.pos + n2;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            java.lang.Object object;
            java.lang.Object object2;
            java.lang.Object object3;
            java.lang.Object object4;
            if (stringArray[n2].equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
                serializable = this.read_wstring();
                break;
            }
            if (stringArray[n2].startsWith("RMI:javax.rmi.CORBA.ClassDesc:")) {
                object4 = (String)((java.lang.Object)this.read_value(class$java$lang$String == null ? CDRInputStream.class$("java.lang.String") : class$java$lang$String));
                object3 = (String)((java.lang.Object)this.read_value(class$java$lang$String == null ? CDRInputStream.class$("java.lang.String") : class$java$lang$String));
                object2 = RepositoryID.className((String)object3, null);
                object = Thread.currentThread().getContextClassLoader();
                try {
                    if (object != null) {
                        try {
                            serializable = ((ClassLoader)object).loadClass((String)object2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            serializable = ValueHandler.loadClass((String)object2, (String)object4, null);
                        }
                        break;
                    }
                    serializable = ValueHandler.loadClass((String)object2, (String)object4, null);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (n2 < stringArray.length - 1) continue;
                    throw new MARSHAL("class not found: " + (String)object2);
                }
            }
            if (stringArray[n2].startsWith("IDL:")) {
                object4 = ((org.omg.CORBA_2_3.ORB)this.orb()).lookup_value_factory(stringArray[n2]);
                if (object4 != null) {
                    this.currentValueIndex = n;
                    serializable = object4.read_value(this);
                    break;
                }
                if (n2 < stringArray.length - 1) continue;
                throw new MARSHAL("No factory found for: " + stringArray[0]);
            }
            object4 = RepositoryID.className(stringArray[n2], null);
            object3 = null;
            object2 = Thread.currentThread().getContextClassLoader();
            try {
                if (object2 != null) {
                    try {
                        object3 = ((ClassLoader)object2).loadClass((String)object4);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        object3 = ValueHandler.loadClass((String)object4, string, null);
                    }
                } else {
                    object3 = ValueHandler.loadClass((String)object4, string, null);
                }
                if ((class$org$omg$CORBA$portable$IDLEntity == null ? CDRInputStream.class$("org.omg.CORBA.portable.IDLEntity") : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom((Class<?>)object3)) {
                    object = null;
                    if (object3 != (class$org$omg$CORBA$Any == null ? CDRInputStream.class$("org.omg.CORBA.Any") : class$org$omg$CORBA$Any)) {
                        String string2 = ((Class)object3).getName() + "Helper";
                        try {
                            Class<?> clazz = ((Class)object3).getClassLoader().loadClass(string2);
                            Class[] classArray = new Class[]{class$org$omg$CORBA$portable$InputStream == null ? CDRInputStream.class$("org.omg.CORBA.portable.InputStream") : class$org$omg$CORBA$portable$InputStream};
                            object = clazz.getMethod("read", classArray);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new MARSHAL("Error loading class " + string2 + ": " + classNotFoundException);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new MARSHAL("No read method in helper class " + string2 + ": " + noSuchMethodException);
                        }
                    }
                    if (object == null) {
                        serializable = this.read_any();
                        continue;
                    }
                    try {
                        serializable = (Serializable)((Method)object).invoke(null, this);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new MARSHAL("Internal error: " + illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new MARSHAL("Exception unmarshaling IDLEntity: " + invocationTargetException.getTargetException());
                    }
                }
                serializable = ValueHandler.readValue(this, n, (Class)object3, stringArray[n2], null);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (n2 < stringArray.length - 1) continue;
                throw new MARSHAL("class not found: " + (String)object4);
            }
        }
        if (serializable != null) {
            this.getValueMap().put(new Integer(n), serializable);
        }
        return serializable;
    }

    private Serializable read_typed_value(int n, String string) {
        return this.read_untyped_value(new String[]{this.read_repository_id()}, n, string);
    }

    private Serializable read_multi_typed_value(int n, String string) {
        int n2 = this.read_long();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = this.read_repository_id();
        }
        return this.read_untyped_value(stringArray, n, string);
    }

    private String read_repository_id() {
        int n = this.read_long();
        if (n == -1) {
            int n2 = this.read_long();
            n2 = n2 + this.pos - 4;
            String string = (String)this.getRepIdMap().get(new Integer(n2));
            if (string == null) {
                throw new MARSHAL("stale RepositoryID indirection");
            }
            return string;
        }
        this.pos -= 4;
        this.index -= 4;
        int n3 = this.pos;
        String string = this.read_string();
        this.getRepIdMap().put(new Integer(n3), string);
        return string;
    }

    private String read_codebase() {
        int n = this.read_long();
        if (n == -1) {
            int n2 = this.read_long();
            n2 = n2 + this.pos - 4;
            String string = (String)this.getCodebaseMap().get(new Integer(n2));
            if (string == null) {
                throw new MARSHAL("stale codebase indirection");
            }
            return string;
        }
        this.pos -= 4;
        this.index -= 4;
        int n3 = this.pos;
        String string = this.read_string();
        this.getCodebaseMap().put(new Integer(n3), string);
        return string;
    }

    private Serializable read_indirect_value() {
        int n = this.read_long();
        n = n + this.pos - 4;
        java.lang.Object v = this.getValueMap().get(new Integer(n));
        if (v == null) {
            throw new IndirectionException(n);
        }
        return (Serializable)v;
    }

    private String validateName(String string) {
        if (string != null && string.length() == 0) {
            return null;
        }
        return string;
    }

    private String validateMember(String string) {
        if (string == null || string.length() == 0) {
            ++this.uniqueValue;
            this.uniqueValue %= Integer.MAX_VALUE;
            return "DUMMY_NAME_".concat(String.valueOf(this.uniqueValue));
        }
        return string;
    }

    private String validateID(String string) {
        if (string == null || string.length() == 0) {
            string = "IDL:";
        }
        return string;
    }

    public java.lang.Object read_abstract_interface() {
        return this.read_boolean() ? this.read_Object() : this.read_value();
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        return this.read_boolean() ? this.read_Object(clazz) : this.read_value(clazz);
    }

    public int get_pos() {
        return this.pos;
    }

    public void register_value(Serializable serializable) {
        this.getValueMap().put(new Integer(this.currentValueIndex), serializable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

