/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.AbstractFilter;
import org.jacorb.notification.ApplicationContext;
import org.jacorb.notification.interfaces.Disposable;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TypeCode;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.ConstraintInfo;
import org.omg.CosNotifyFilter.ConstraintNotFound;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.InvalidValue;
import org.omg.CosNotifyFilter.MappingConstraintInfo;
import org.omg.CosNotifyFilter.MappingConstraintPair;
import org.omg.CosNotifyFilter.MappingFilterPOA;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;

public class MappingFilterImpl
extends MappingFilterPOA
implements Disposable {
    private AbstractFilter filterImpl_;
    private Any defaultValue_;
    private ValueMap valueMap_ = new ValueMap();
    private Logger logger_ = null;
    private org.jacorb.config.Configuration config_ = null;

    public MappingFilterImpl(ApplicationContext applicationContext, AbstractFilter abstractFilter, Any any) {
        this.filterImpl_ = abstractFilter;
        this.defaultValue_ = any;
    }

    public void configure(Configuration configuration) {
        this.config_ = (org.jacorb.config.Configuration)configuration;
        this.logger_ = this.config_.getNamedLogger(this.getClass().getName());
    }

    public void destroy() {
        this.dispose();
    }

    public void dispose() {
        this.filterImpl_.dispose();
        this.valueMap_.dispose();
        this.defaultValue_ = null;
    }

    public String constraint_grammar() {
        return this.filterImpl_.constraint_grammar();
    }

    public TypeCode value_type() {
        return this.defaultValue_.type();
    }

    public Any default_value() {
        return this.defaultValue_;
    }

    public MappingConstraintInfo[] add_mapping_constraints(MappingConstraintPair[] mappingConstraintPairArray) throws InvalidValue, InvalidConstraint {
        ConstraintExp[] constraintExpArray = new ConstraintExp[mappingConstraintPairArray.length];
        for (int i = 0; i < mappingConstraintPairArray.length; ++i) {
            constraintExpArray[i] = mappingConstraintPairArray[i].constraint_expression;
        }
        ConstraintInfo[] constraintInfoArray = this.filterImpl_.add_constraints(constraintExpArray);
        MappingConstraintInfo[] mappingConstraintInfoArray = new MappingConstraintInfo[constraintInfoArray.length];
        for (int i = 0; i < constraintInfoArray.length; ++i) {
            mappingConstraintInfoArray[i] = new MappingConstraintInfo(constraintInfoArray[i].constraint_expression, constraintInfoArray[i].constraint_id, mappingConstraintPairArray[i].result_to_set);
            this.valueMap_.put(constraintInfoArray[i].constraint_id, mappingConstraintPairArray[i].result_to_set);
        }
        return mappingConstraintInfoArray;
    }

    public void modify_mapping_constraints(int[] nArray, MappingConstraintInfo[] mappingConstraintInfoArray) throws ConstraintNotFound, InvalidValue, InvalidConstraint {
        int n;
        ConstraintInfo[] constraintInfoArray = new ConstraintInfo[mappingConstraintInfoArray.length];
        for (n = 0; n < constraintInfoArray.length; ++n) {
            constraintInfoArray[n] = new ConstraintInfo(mappingConstraintInfoArray[n].constraint_expression, mappingConstraintInfoArray[n].constraint_id);
            this.valueMap_.remove(mappingConstraintInfoArray[n].constraint_id);
        }
        this.filterImpl_.modify_constraints(nArray, constraintInfoArray);
        for (n = 0; n < mappingConstraintInfoArray.length; ++n) {
            this.valueMap_.put(mappingConstraintInfoArray[n].constraint_id, mappingConstraintInfoArray[n].value);
        }
    }

    public MappingConstraintInfo[] get_mapping_constraints(int[] nArray) throws ConstraintNotFound {
        ConstraintInfo[] constraintInfoArray = this.filterImpl_.get_constraints(nArray);
        MappingConstraintInfo[] mappingConstraintInfoArray = new MappingConstraintInfo[constraintInfoArray.length];
        for (int i = 0; i < constraintInfoArray.length; ++i) {
            mappingConstraintInfoArray[i] = new MappingConstraintInfo(constraintInfoArray[i].constraint_expression, constraintInfoArray[i].constraint_id, this.valueMap_.get(constraintInfoArray[i].constraint_id));
        }
        return mappingConstraintInfoArray;
    }

    public MappingConstraintInfo[] get_all_mapping_constraints() {
        ConstraintInfo[] constraintInfoArray = this.filterImpl_.get_all_constraints();
        MappingConstraintInfo[] mappingConstraintInfoArray = new MappingConstraintInfo[constraintInfoArray.length];
        for (int i = 0; i < constraintInfoArray.length; ++i) {
            mappingConstraintInfoArray[i] = new MappingConstraintInfo(constraintInfoArray[i].constraint_expression, constraintInfoArray[i].constraint_id, this.valueMap_.get(constraintInfoArray[i].constraint_id));
        }
        return mappingConstraintInfoArray;
    }

    public void remove_all_mapping_constraints() {
        this.filterImpl_.remove_all_constraints();
        this.valueMap_.dispose();
    }

    public boolean match(Any any, AnyHolder anyHolder) throws UnsupportedFilterableData {
        int n = this.filterImpl_.match_internal(any);
        if (n >= 0) {
            anyHolder.value = this.valueMap_.get(n);
            return true;
        }
        return false;
    }

    public boolean match_structured(StructuredEvent structuredEvent, AnyHolder anyHolder) throws UnsupportedFilterableData {
        int n = this.filterImpl_.match_structured_internal(structuredEvent);
        if (n >= 0) {
            anyHolder.value = this.valueMap_.get(n);
            return true;
        }
        return false;
    }

    public boolean match_typed(Property[] propertyArray, AnyHolder anyHolder) throws UnsupportedFilterableData {
        throw new NO_IMPLEMENT();
    }

    private static class ValueMap {
        private Map valueMap_ = new Hashtable();

        private ValueMap() {
        }

        public void put(int n, Any any) {
            this.valueMap_.put(new Integer(n), any);
        }

        public Any get(int n) {
            return (Any)this.valueMap_.get(new Integer(n));
        }

        public Any remove(int n) {
            return (Any)this.valueMap_.remove(new Integer(n));
        }

        public void dispose() {
            this.valueMap_.clear();
        }
    }
}

