/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Properties;
import org.jacorb.notification.AbstractChannelFactory;

public class ConsoleMain {
    private static void help() {
        System.out.println("Usage: ntfy [-printIOR] [-printCorbaloc] [-writeIOR <filename>] [-registerName <nameId>[.<nameKind>]] [-port <oaPort>] [-channels <channels>] [-help]");
        System.exit(0);
    }

    public static AbstractChannelFactory newFactory(String[] stringArray) throws Exception {
        CmdLineParser cmdLineParser = new CmdLineParser(stringArray);
        if (cmdLineParser.getDoHelp()) {
            ConsoleMain.help();
            System.exit(0);
        }
        Properties properties = cmdLineParser.getProps();
        AbstractChannelFactory abstractChannelFactory = AbstractChannelFactory.newFactory(properties);
        return abstractChannelFactory;
    }

    public static final void main(String[] stringArray) throws Exception {
        ConsoleMain.newFactory(stringArray);
    }

    private static class CmdLineParser {
        private boolean doHelp = false;
        private Properties props = new Properties();

        public boolean getDoHelp() {
            return this.doHelp;
        }

        public Properties getProps() {
            return this.props;
        }

        CmdLineParser(String[] stringArray) {
            this.perform(stringArray);
        }

        private void perform(String[] stringArray) throws IllegalArgumentException {
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("-printIOR")) {
                        this.props.put("jacorb.notification.print_ior", "on");
                        continue;
                    }
                    if (stringArray[i].equals("-printCorbaloc")) {
                        this.props.put("jacorb.notification.print_corbaloc", "on");
                        continue;
                    }
                    if (stringArray[i].equals("-help")) {
                        this.doHelp = true;
                        continue;
                    }
                    if (stringArray[i].equals("-port")) {
                        this.props.put("OAPort", stringArray[++i]);
                        continue;
                    }
                    if (stringArray[i].equals("-channels")) {
                        this.props.put("jacorb.notification.start_channels", stringArray[++i]);
                        continue;
                    }
                    if (stringArray[i].equals("-writeIOR")) {
                        this.props.put("jacorb.notification.ior_file", stringArray[++i]);
                        continue;
                    }
                    if (stringArray[i].equals("-registerName")) {
                        String string = stringArray[++i];
                        int n = string.indexOf(".");
                        if (string.lastIndexOf(".") != n) {
                            throw new IllegalArgumentException(string + ": argument to -registerName should be " + "<nameId> or <nameId>.<nameKind>");
                        }
                        if (n != -1) {
                            this.props.put("jacorb.notification.register_name.id", string.substring(0, n));
                            this.props.put("jacorb.notification.register_name.kind", string.substring(n + 1));
                            continue;
                        }
                        this.props.put("jacorb.notification.register_name.id", string);
                        continue;
                    }
                    if (stringArray[i].equals("-typed")) {
                        this.props.put("jacorb.notification.enable_typed_channel", "on");
                        continue;
                    }
                    System.out.println("Unknown argument: " + stringArray[i]);
                    this.doHelp = true;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.doHelp = true;
            }
        }
    }
}

