/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.ChannelContextDependency;
import org.jacorb.notification.Dependant;
import org.jacorb.notification.EventChannelFactoryDependency;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.interfaces.AdminEvent;
import org.jacorb.notification.interfaces.AdminEventListener;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.FilterStageSource;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractSupplierAdmin;
import org.jacorb.notification.servant.FilterStageListManager;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.AdminPropertySet;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimit;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.AdminNotFound;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class AbstractEventChannel
implements Disposable,
ManageableServant,
Configurable,
ChannelContextDependency,
Dependant,
EventChannelFactoryDependency {
    protected Logger logger_ = null;
    protected Servant thisServant_;
    protected Configuration configuration_ = null;
    private ORB orb_;
    private POA poa_;
    private ChannelContext channelContext_;
    private FilterFactory defaultFilterFactory_;
    private String ior_;
    private int key_;
    private FilterStageListManager listManager_;
    private final Object modifyConsumerAdminsLock_ = new Object();
    private final Object modifySupplierAdminsLock_ = new Object();
    private final Map consumerAdminServants_ = new HashMap();
    private final Map supplierAdminServants_ = new HashMap();
    private final SynchronizedInt adminIdPool_ = new SynchronizedInt(1);
    public static final Integer DEFAULT_ADMIN_KEY = new Integer(0);
    private final SynchronizedInt numberOfConsumers_ = new SynchronizedInt(0);
    private final SynchronizedInt numberOfSuppliers_ = new SynchronizedInt(0);
    private int maxNumberOfConsumers_;
    private boolean lazyDefaultAdminInit_;
    private int maxNumberOfSuppliers_;
    private final SubscriptionManager subscriptionManager_ = new SubscriptionManager();
    private final OfferManager offerManager_ = new OfferManager();
    private AdminPropertySet adminSettings_;
    private QoSPropertySet qosSettings_;
    private List listAdminEventListeners_ = new ArrayList();
    private Runnable disposeHook_;
    private ProxyEventListener proxyConsumerEventListener_ = new ProxyEventListener(){

        public void actionProxyCreationRequest(ProxyEvent proxyEvent) throws AdminLimitExceeded {
            AbstractEventChannel.this.addConsumer();
        }

        public void actionProxyCreated(ProxyEvent proxyEvent) {
        }

        public void actionProxyDisposed(ProxyEvent proxyEvent) {
            AbstractEventChannel.this.removeConsumer();
        }
    };
    private ProxyEventListener proxySupplierEventListener_ = new ProxyEventListener(){

        public void actionProxyCreationRequest(ProxyEvent proxyEvent) throws AdminLimitExceeded {
            AbstractEventChannel.this.addSupplier();
        }

        public void actionProxyCreated(ProxyEvent proxyEvent) {
        }

        public void actionProxyDisposed(ProxyEvent proxyEvent) {
            AbstractEventChannel.this.removeSupplier();
        }
    };

    public final void setDefaultFilterFactory(FilterFactory filterFactory) {
        this.defaultFilterFactory_ = filterFactory;
    }

    public AbstractEventChannel() {
        this.listManager_ = new FilterStageListManager(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fetchListData(FilterStageListManager.List list) {
                Object object = AbstractEventChannel.this.modifyConsumerAdminsLock_;
                synchronized (object) {
                    Iterator iterator = AbstractEventChannel.this.consumerAdminServants_.keySet().iterator();
                    while (iterator.hasNext()) {
                        Integer n = (Integer)iterator.next();
                        list.add((FilterStage)AbstractEventChannel.this.consumerAdminServants_.get(n));
                    }
                }
            }
        };
    }

    public final void setChannelContext(ChannelContext channelContext) {
        this.channelContext_ = channelContext;
    }

    protected ChannelContext getChannelContext() {
        return this.channelContext_;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration_ = configuration;
        this.logger_ = ((org.jacorb.config.Configuration)configuration).getNamedLogger(this.getClass().getName());
        this.lazyDefaultAdminInit_ = configuration.getAttribute("jacorb.notification.admin.lazy_initialization", "on").equals("on");
        this.subscriptionManager_.configure(configuration);
        this.offerManager_.configure(configuration);
        this.adminSettings_ = new AdminPropertySet(configuration);
        this.qosSettings_ = new QoSPropertySet(configuration, 0);
    }

    public void preActivate() {
    }

    public void setKey(int n) {
        this.key_ = n;
    }

    public void setORB(ORB oRB) {
        this.orb_ = oRB;
    }

    protected ORB getORB() {
        return this.orb_;
    }

    public void setPOA(POA pOA) {
        this.poa_ = pOA;
    }

    protected POA getPOA() {
        return this.poa_;
    }

    private void addConsumer() throws AdminLimitExceeded {
        if (this.maxNumberOfConsumers_ != 0 && this.numberOfConsumers_.compareTo(this.maxNumberOfConsumers_) >= 0) {
            Any any = this.orb_.create_any();
            any.insert_long(this.maxNumberOfConsumers_);
            AdminLimit adminLimit = new AdminLimit("consumer limit", any);
            throw new AdminLimitExceeded("Consumer creation request exceeds AdminLimit.", adminLimit);
        }
        this.numberOfConsumers_.increment();
    }

    private void removeConsumer() {
        this.numberOfConsumers_.decrement();
    }

    private void addSupplier() throws AdminLimitExceeded {
        if (this.maxNumberOfSuppliers_ != 0 && this.numberOfSuppliers_.compareTo(this.maxNumberOfSuppliers_) >= 0) {
            Any any = this.orb_.create_any();
            any.insert_long(this.maxNumberOfSuppliers_);
            AdminLimit adminLimit = new AdminLimit("suppliers limit", any);
            throw new AdminLimitExceeded("supplier creation request exceeds AdminLimit.", adminLimit);
        }
        this.numberOfSuppliers_.increment();
    }

    private void removeSupplier() {
        this.numberOfSuppliers_.decrement();
    }

    final int getAdminId() {
        return this.adminIdPool_.increment();
    }

    protected final void fireAdminCreatedEvent(AbstractAdmin abstractAdmin) {
        Iterator iterator = this.listAdminEventListeners_.iterator();
        AdminEvent adminEvent = new AdminEvent(abstractAdmin);
        while (iterator.hasNext()) {
            ((AdminEventListener)iterator.next()).actionAdminCreated(adminEvent);
        }
    }

    protected final void fireAdminDestroyedEvent(AbstractAdmin abstractAdmin) {
        Iterator iterator = this.listAdminEventListeners_.iterator();
        AdminEvent adminEvent = new AdminEvent(abstractAdmin);
        while (iterator.hasNext()) {
            ((AdminEventListener)iterator.next()).actionAdminDestroyed(adminEvent);
        }
    }

    public final void addAdminEventListener(AdminEventListener adminEventListener) {
        this.listAdminEventListeners_.add(adminEventListener);
    }

    public final void removeAdminEventListener(AdminEventListener adminEventListener) {
        this.listAdminEventListeners_.remove(adminEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isDefaultConsumerAdminActive() {
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            return this.consumerAdminServants_.containsKey(DEFAULT_ADMIN_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isDefaultSupplierAdminActive() {
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            return this.supplierAdminServants_.containsKey(DEFAULT_ADMIN_KEY);
        }
    }

    public final FilterFactory default_filter_factory() {
        return this.defaultFilterFactory_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] get_all_consumeradmins() {
        int[] nArray;
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            nArray = new int[this.consumerAdminServants_.size()];
            Iterator iterator = this.consumerAdminServants_.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                nArray[n++] = (Integer)iterator.next();
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] get_all_supplieradmins() {
        int[] nArray;
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            nArray = new int[this.supplierAdminServants_.size()];
            Iterator iterator = this.supplierAdminServants_.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                nArray[n++] = (Integer)iterator.next();
            }
        }
        return nArray;
    }

    public final Property[] get_admin() {
        return this.adminSettings_.toArray();
    }

    public final Property[] get_qos() {
        return this.qosSettings_.toArray();
    }

    public final void set_qos(Property[] propertyArray) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, new NamedPropertyRangeSeqHolder());
        this.qosSettings_.set_qos(propertyArray);
    }

    public final void validate_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, new NamedPropertyRangeSeqHolder());
    }

    public final void set_admin(Property[] propertyArray) throws UnsupportedAdmin {
        this.adminSettings_.validate_admin(propertyArray);
        this.adminSettings_.set_admin(propertyArray);
        this.configureAdminLimits(this.adminSettings_);
    }

    private void configureAdminLimits(PropertySet propertySet) {
        Any any = propertySet.get("MaxConsumers");
        this.maxNumberOfConsumers_ = any.extract_long();
        Any any2 = propertySet.get("MaxSuppliers");
        this.maxNumberOfSuppliers_ = any2.extract_long();
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set MaxNumberOfConsumers=" + this.maxNumberOfConsumers_);
            this.logger_.info("set MaxNumberOfSuppliers=" + this.maxNumberOfSuppliers_);
        }
    }

    public final void destroy() {
        this.dispose();
    }

    public void setDisposeHook(Runnable runnable) {
        this.disposeHook_ = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Disposable disposable;
        Iterator iterator;
        this.logger_.info("destroy channel");
        this.deactivate();
        this.disposeHook_.run();
        this.logger_.info("destroy ConsumerAdmins");
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            iterator = this.consumerAdminServants_.values().iterator();
            while (iterator.hasNext()) {
                disposable = (Disposable)iterator.next();
                iterator.remove();
                disposable.dispose();
            }
        }
        this.logger_.info("destroy SupplierAdmins");
        object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            iterator = this.supplierAdminServants_.values().iterator();
            while (iterator.hasNext()) {
                disposable = (Disposable)iterator.next();
                iterator.remove();
                disposable.dispose();
            }
        }
        this.listAdminEventListeners_.clear();
    }

    public final POA _default_POA() {
        return this.getPOA();
    }

    public int getKey() {
        return this.key_;
    }

    public String getIOR() {
        return this.ior_;
    }

    public boolean isPersistent() {
        return false;
    }

    public final int getNumberOfConnectedClients() {
        return this.numberOfConsumers_.get() + this.numberOfSuppliers_.get();
    }

    public final int getMaxNumberOfSuppliers() {
        return this.maxNumberOfSuppliers_;
    }

    public final int getMaxNumberOfConsumers() {
        return this.maxNumberOfConsumers_;
    }

    public final void deactivate() {
        try {
            this.poa_.deactivate_object(this.poa_.servant_to_id(this.thisServant_));
        }
        catch (Exception exception) {
            this.logger_.error("Unable to deactivate EventChannel Object", (Throwable)exception);
            throw new RuntimeException();
        }
    }

    private Property[] createQoSPropertiesForAdmin() {
        HashMap hashMap = new HashMap(this.qosSettings_.toMap());
        hashMap.remove("EventReliability");
        return PropertySet.map2Props(hashMap);
    }

    private void configureAdmin(AbstractAdmin abstractAdmin) {
        this.getChannelContext().resolveDependencies(abstractAdmin);
        abstractAdmin.configure(this.configuration_);
        abstractAdmin.setSubscriptionManager(this.subscriptionManager_);
        abstractAdmin.setOfferManager(this.offerManager_);
    }

    protected AbstractAdmin get_consumeradmin_internal(int n) throws AdminNotFound {
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            Integer n2 = new Integer(n);
            if (this.consumerAdminServants_.containsKey(n2)) {
                AbstractAdmin abstractAdmin = (AbstractAdmin)this.consumerAdminServants_.get(n2);
                return abstractAdmin;
            }
            throw new AdminNotFound("ID " + n + " does not exist.");
        }
    }

    protected AbstractAdmin get_supplieradmin_internal(int n) throws AdminNotFound {
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            Integer n2 = new Integer(n);
            if (this.supplierAdminServants_.containsKey(n2)) {
                AbstractAdmin abstractAdmin = (AbstractAdmin)this.supplierAdminServants_.get(n2);
                return abstractAdmin;
            }
            throw new AdminNotFound("ID " + n + " does not exist.");
        }
    }

    private List getAllConsumerAdmins() {
        return this.listManager_.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractAdmin getDefaultConsumerAdminServant() {
        AbstractAdmin abstractAdmin;
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            abstractAdmin = (AbstractAdmin)this.consumerAdminServants_.get(DEFAULT_ADMIN_KEY);
            if (abstractAdmin == null) {
                abstractAdmin = this.newConsumerAdminServant(DEFAULT_ADMIN_KEY);
                try {
                    abstractAdmin.set_qos(this.createQoSPropertiesForAdmin());
                }
                catch (UnsupportedQoS unsupportedQoS) {
                    this.logger_.fatalError("unable to set qos", (Throwable)unsupportedQoS);
                }
                this.addToConsumerAdmins(abstractAdmin);
                this.fireAdminCreatedEvent(abstractAdmin);
            }
        }
        return abstractAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToConsumerAdmins(AbstractAdmin abstractAdmin) {
        final Integer n = abstractAdmin.getID();
        abstractAdmin.setDisposeHook(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = AbstractEventChannel.this.modifyConsumerAdminsLock_;
                synchronized (object) {
                    AbstractEventChannel.this.consumerAdminServants_.remove(n);
                    AbstractEventChannel.this.listManager_.actionSourceModified();
                }
            }
        });
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            this.consumerAdminServants_.put(n, abstractAdmin);
            this.listManager_.actionSourceModified();
        }
    }

    protected AbstractAdmin new_for_consumers_servant(InterFilterGroupOperator interFilterGroupOperator, IntHolder intHolder) {
        AbstractAdmin abstractAdmin = this.newConsumerAdminServant();
        abstractAdmin.setInterFilterGroupOperator(interFilterGroupOperator);
        intHolder.value = abstractAdmin.getID();
        abstractAdmin.setIsIDPublic(true);
        try {
            abstractAdmin.set_qos(this.createQoSPropertiesForAdmin());
        }
        catch (UnsupportedQoS unsupportedQoS) {
            this.logger_.error("unable to set QoS", (Throwable)unsupportedQoS);
        }
        abstractAdmin.addProxyEventListener(this.proxySupplierEventListener_);
        this.addToConsumerAdmins(abstractAdmin);
        this.fireAdminCreatedEvent(abstractAdmin);
        return abstractAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSupplierAdmins(AbstractAdmin abstractAdmin) {
        final Integer n = abstractAdmin.getID();
        abstractAdmin.setDisposeHook(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = AbstractEventChannel.this.modifySupplierAdminsLock_;
                synchronized (object) {
                    AbstractEventChannel.this.supplierAdminServants_.remove(n);
                }
            }
        });
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            this.supplierAdminServants_.put(n, abstractAdmin);
        }
    }

    protected AbstractAdmin new_for_suppliers_servant(InterFilterGroupOperator interFilterGroupOperator, IntHolder intHolder) {
        AbstractAdmin abstractAdmin = this.newSupplierAdminServant();
        intHolder.value = abstractAdmin.getID();
        abstractAdmin.setInterFilterGroupOperator(interFilterGroupOperator);
        abstractAdmin.setIsIDPublic(true);
        try {
            abstractAdmin.set_qos(this.createQoSPropertiesForAdmin());
        }
        catch (UnsupportedQoS unsupportedQoS) {
            this.logger_.fatalError("error setting qos", (Throwable)unsupportedQoS);
        }
        abstractAdmin.addProxyEventListener(this.proxyConsumerEventListener_);
        this.addToSupplierAdmins(abstractAdmin);
        this.fireAdminCreatedEvent(abstractAdmin);
        return abstractAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractAdmin getDefaultSupplierAdminServant() {
        AbstractAdmin abstractAdmin;
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            abstractAdmin = (AbstractAdmin)this.supplierAdminServants_.get(DEFAULT_ADMIN_KEY);
            if (abstractAdmin == null) {
                abstractAdmin = this.newSupplierAdminServant(DEFAULT_ADMIN_KEY);
                try {
                    abstractAdmin.set_qos(this.createQoSPropertiesForAdmin());
                }
                catch (UnsupportedQoS unsupportedQoS) {
                    this.logger_.fatalError("unable to set qos", (Throwable)unsupportedQoS);
                }
                this.addToSupplierAdmins(abstractAdmin);
                this.fireAdminCreatedEvent(abstractAdmin);
            }
        }
        return abstractAdmin;
    }

    private AbstractAdmin newConsumerAdminServant() {
        return this.newConsumerAdminServant(new Integer(this.adminIdPool_.increment()));
    }

    private AbstractAdmin newConsumerAdminServant(Integer n) {
        AbstractAdmin abstractAdmin = this.newConsumerAdmin();
        this.configureAdmin(abstractAdmin);
        abstractAdmin.setID(n);
        return abstractAdmin;
    }

    protected abstract AbstractAdmin newConsumerAdmin();

    private AbstractAdmin newSupplierAdminServant() {
        return this.newSupplierAdminServant(new Integer(this.adminIdPool_.increment()));
    }

    private AbstractAdmin newSupplierAdminServant(Integer n) {
        AbstractSupplierAdmin abstractSupplierAdmin = this.newSupplierAdmin();
        abstractSupplierAdmin.setSubsequentFilterStageSource(new FilterStageSource(){

            public List getSubsequentFilterStages() {
                return AbstractEventChannel.this.getAllConsumerAdmins();
            }
        });
        this.configureAdmin(abstractSupplierAdmin);
        abstractSupplierAdmin.setID(n);
        return abstractSupplierAdmin;
    }

    protected abstract AbstractSupplierAdmin newSupplierAdmin();
}

