/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.navtree;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jboss.console.manager.interfaces.SimpleTreeNodeMenuEntry;
import org.jboss.console.manager.interfaces.TreeAction;
import org.jboss.console.manager.interfaces.TreeNodeMenuEntry;
import org.jboss.console.manager.interfaces.impl.SeparatorTreeNodeMenuEntry;
import org.jboss.console.navtree.ConsoleTreeModel;
import org.jboss.console.navtree.NodeWrapper;
import org.jboss.console.navtree.TreeCellRenderer;
import org.jboss.console.navtree.TreeContext;

public class AdminTreeBrowser {
    TreeContext ctx = null;
    ConsoleTreeModel tm = null;
    TreeCellRenderer cellRenderer = null;
    TreeSelectionListener selectionListener = null;
    OpenNodeAccounter openNodeAccounter = null;
    String webHost = null;
    public static final String RIGHT_FRAME_NAME = "right";
    private JTree tree;

    public AdminTreeBrowser(TreeContext ctx) throws Exception {
        this.ctx = ctx;
        this.tm = new ConsoleTreeModel(ctx);
        this.cellRenderer = new TreeCellRenderer(ctx);
        this.initComponents();
        this.openNodeAccounter = new OpenNodeAccounter(this.getTree());
        this.getTree().addMouseListener(new PopupMenuMgr());
        this.getTree().getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.getTree());
    }

    public void refreshTree(boolean force) {
        try {
            this.tm.refreshTree(force);
        }
        catch (Exception displayed) {
            displayed.printStackTrace();
        }
    }

    private void initComponents() {
        this.tree = new JTree();
        this.tree.setCellRenderer(this.getCellRenderer());
        this.tree.setModel(this.getTreeModel());
        this.tree.setAutoscrolls(true);
    }

    public TreeCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public TreeModel getTreeModel() {
        return this.tm;
    }

    public TreeSelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    public JTree getTree() {
        return this.tree;
    }

    public class PopupMenuMgr
    extends MouseAdapter {
        HashMap menus = new HashMap();

        public void mousePressed(MouseEvent e) {
            this.mouseReleased(e);
        }

        public void mouseReleased(MouseEvent e) {
            TreePath loc = AdminTreeBrowser.this.getTree().getPathForLocation(e.getX(), e.getY());
            if (loc == null) {
                return;
            }
            AdminTreeBrowser.this.getTree().setSelectionPath(loc);
            if (e.isPopupTrigger()) {
                NodeWrapper who;
                TreeNodeMenuEntry[] entries;
                Object node = AdminTreeBrowser.this.getTree().getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                JPopupMenu popup = null;
                if (this.menus.containsKey(node)) {
                    popup = (JPopupMenu)this.menus.get(node);
                } else if (node instanceof NodeWrapper && (entries = (who = (NodeWrapper)node).getMenuEntries()) != null && entries.length > 0) {
                    popup = new JPopupMenu();
                    popup.setOpaque(true);
                    popup.setLightWeightPopupEnabled(true);
                    this.menus.put(node, popup);
                    for (int i = 0; i < entries.length; ++i) {
                        if (entries[i] instanceof SeparatorTreeNodeMenuEntry) {
                            popup.addSeparator();
                            continue;
                        }
                        if (!(entries[i] instanceof SimpleTreeNodeMenuEntry)) continue;
                        SimpleTreeNodeMenuEntry txt = (SimpleTreeNodeMenuEntry)entries[i];
                        JMenuItem mi = new JMenuItem(txt.getText());
                        mi.addActionListener(new ActionListener(this, txt){
                            private final /* synthetic */ SimpleTreeNodeMenuEntry val$txt;
                            private final /* synthetic */ PopupMenuMgr this$1;
                            {
                                this.this$1 = this$1;
                                this.val$txt = val$txt;
                            }

                            public void actionPerformed(ActionEvent e) {
                                PopupMenuMgr.access$000((PopupMenuMgr)this.this$1).ctx.doPopupMenuAction(this.val$txt);
                            }
                        });
                        popup.add(mi);
                    }
                }
                if (popup != null) {
                    popup.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            } else {
                Object node = AdminTreeBrowser.this.getTree().getLastSelectedPathComponent();
                if (node != null && node instanceof NodeWrapper) {
                    NodeWrapper who = (NodeWrapper)node;
                    TreeAction act = who.getAssociatedAction();
                    AdminTreeBrowser.this.ctx.doAdminTreeAction(act);
                }
            }
        }

        static /* synthetic */ AdminTreeBrowser access$000(PopupMenuMgr x0) {
            return x0.AdminTreeBrowser.this;
        }
    }

    public class OpenNodeAccounter
    implements TreeExpansionListener,
    TreeModelListener {
        protected TreeSet openNodes = new TreeSet();

        public OpenNodeAccounter(JTree tree) {
            tree.getModel().addTreeModelListener(this);
        }

        public void treeExpanded(TreeExpansionEvent event) {
            this.openNodes.add(((NodeWrapper)event.getSource()).getPath());
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            this.openNodes.remove(((NodeWrapper)event.getSource()).getPath());
        }

        public void treeNodesChanged(TreeModelEvent e) {
        }

        public void recursivelyOpen(NodeWrapper son) {
        }

        public void treeNodesInserted(TreeModelEvent e) {
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }
    }
}

