/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.manager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.console.manager.DeploymentFileRepositoryMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;

public class DeploymentFileRepository
extends ServiceMBeanSupport
implements DeploymentFileRepositoryMBean {
    private String baseDir;
    private File base;
    protected File serverHome;
    protected URL serverHomeURL;

    public void store(String folder, String name, String fileExtension, String data, boolean noHotDeploy) throws IOException {
        this.log.debug((Object)"store called");
        File dir = new File(this.base, folder);
        this.log.debug((Object)("respository folder: " + dir.toString()));
        this.log.debug((Object)("absolute: " + dir.getAbsolutePath()));
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Failed to create directory: " + dir.toString());
        }
        String filename = name.replace(' ', '_') + fileExtension;
        File file = new File(dir, filename);
        File tmpfile = new File(dir, filename + ".tmp");
        PrintWriter writer = new PrintWriter(new FileOutputStream(tmpfile));
        writer.write(data);
        writer.close();
        if (file.exists() && noHotDeploy) {
            long modified = file.lastModified();
            tmpfile.setLastModified(modified);
            file.delete();
        }
        if (!tmpfile.renameTo(file)) {
            throw new RuntimeException("Failed to rename tmpfile to " + file.toString());
        }
    }

    public void remove(String folder, String name, String fileExtension) {
        File dir = new File(this.base, folder);
        String filename = name.replace(' ', '_') + fileExtension;
        File file = new File(dir, filename);
        file.delete();
    }

    public boolean isStored(String folder, String name, String fileExtension) {
        File dir = new File(this.base, folder);
        String filename = name.replace(' ', '_') + fileExtension;
        File file = new File(dir, filename);
        return file.exists();
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
        this.base = new File(this.serverHome, baseDir);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        ServerConfig serverConfig = ServerConfigLocator.locate();
        this.serverHome = serverConfig.getServerHomeDir();
        return super.preRegister(server, name);
    }
}

