/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.transport.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Message;
import org.jboss.axis.MessageContext;
import org.jboss.axis.MessagePart;
import org.jboss.axis.components.net.BooleanHolder;
import org.jboss.axis.components.net.SocketFactory;
import org.jboss.axis.components.net.SocketFactoryFactory;
import org.jboss.axis.encoding.Base64;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.axis.soap.SOAPConstants;
import org.jboss.axis.transport.http.ChunkedInputStream;
import org.jboss.axis.transport.http.ChunkedOutputStream;
import org.jboss.axis.transport.http.HTTPConstants;
import org.jboss.axis.transport.http.SocketInputStream;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public class HTTPSender
extends BasicHandler {
    private static Logger log = Logger.getLogger((String)HTTPSender.class.getName());

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("enter00", "HTTPSender::invoke"));
        }
        try {
            BooleanHolder useFullURL = new BooleanHolder(false);
            StringBuffer otherHeaders = new StringBuffer();
            URL targetURL = new URL(msgContext.getStrProp("transport.url"));
            String host = targetURL.getHost();
            int port = targetURL.getPort();
            Socket sock = null;
            log.debug((Object)("TargetURL: " + targetURL));
            sock = this.getSocket(targetURL.getProtocol(), host, port, otherHeaders, useFullURL, msgContext.getTransportOptions());
            if (msgContext.getTimeout() != 0) {
                sock.setSoTimeout(msgContext.getTimeout());
            }
            InputStream inp = this.writeToSocket(sock, msgContext, targetURL, otherHeaders, host, port, useFullURL);
            MimeHeaders headers = new MimeHeaders();
            inp = this.readHeadersFromSocket(sock, msgContext, inp, headers);
            this.readFromSocket(sock, msgContext, inp, headers);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("exit00", "HTTPDispatchHandler::invoke"));
        }
    }

    private Socket getSocket(String protocol, String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL, HashMap options) throws Exception {
        SocketFactory factory = SocketFactoryFactory.getFactory(protocol, options);
        return factory.create(host, port, otherHeaders, useFullURL);
    }

    private InputStream writeToSocket(Socket sock, MessageContext msgContext, URL tmpURL, StringBuffer otherHeaders, String host, int port, BooleanHolder useFullURL) throws IOException {
        MimeHeaders mimeHeaders;
        String action;
        String userID = null;
        String passwd = null;
        userID = msgContext.getUsername();
        passwd = msgContext.getPassword();
        String string = action = msgContext.useSOAPAction() ? msgContext.getSOAPActionURI() : "";
        if (action == null) {
            action = "";
        }
        if (userID == null && tmpURL.getUserInfo() != null) {
            String info = tmpURL.getUserInfo();
            int sep = info.indexOf(58);
            if (sep >= 0 && sep + 1 < info.length()) {
                userID = info.substring(0, sep);
                passwd = info.substring(sep + 1);
            } else {
                userID = info;
            }
        }
        if (userID != null) {
            StringBuffer tmpBuf = new StringBuffer();
            tmpBuf.append(userID).append(":").append(passwd == null ? "" : passwd);
            otherHeaders.append("Authorization").append(": Basic ").append(Base64.encode(tmpBuf.toString().getBytes())).append("\r\n");
        }
        if (msgContext.getMaintainSession()) {
            String cookie = msgContext.getStrProp("Cookie");
            String cookie2 = msgContext.getStrProp("Cookie2");
            if (cookie != null) {
                otherHeaders.append("Cookie").append(": ").append(cookie).append("\r\n");
            }
            if (cookie2 != null) {
                otherHeaders.append("Cookie2").append(": ").append(cookie2).append("\r\n");
            }
        }
        StringBuffer header = new StringBuffer();
        String webMethod = null;
        boolean posting = true;
        if (msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
            webMethod = msgContext.getStrProp("soap12.webmethod");
        }
        if (webMethod == null) {
            webMethod = "POST";
        } else {
            posting = webMethod.equals("POST");
        }
        header.append(webMethod).append(" ");
        if (useFullURL.value) {
            header.append(tmpURL.toExternalForm());
        } else {
            header.append(tmpURL.getFile() == null || tmpURL.getFile().equals("") ? "/" : tmpURL.getFile());
        }
        Message requestMsg = msgContext.getRequestMessage();
        boolean http10 = true;
        boolean httpChunkStream = false;
        boolean httpContinueExpected = false;
        String httpConnection = null;
        String httpver = msgContext.getStrProp("axis.transport.version");
        if (null == httpver) {
            httpver = HTTPConstants.HEADER_PROTOCOL_V10;
        }
        if ((httpver = httpver.trim()).equals(HTTPConstants.HEADER_PROTOCOL_V11)) {
            http10 = false;
        }
        if ((mimeHeaders = requestMsg.getMimeHeaders()) != null) {
            Iterator i = mimeHeaders.getAllHeaders();
            while (i.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)i.next();
                String name = mimeHeader.getName();
                String value = mimeHeader.getValue();
                if (name.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING)) {
                    if (http10 || null == value || !value.trim().equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    httpChunkStream = true;
                    continue;
                }
                if (name.equalsIgnoreCase("Host") || name.equalsIgnoreCase("Content-Type")) continue;
                if (name.equalsIgnoreCase("SOAPAction")) {
                    action = value;
                    continue;
                }
                if (name.equalsIgnoreCase("Content-Length") || name.equalsIgnoreCase("Cookie") || name.equalsIgnoreCase("Cookie2") || name.equalsIgnoreCase("Authorization") || name.equalsIgnoreCase("Proxy-Authorization")) continue;
                if (name.equalsIgnoreCase("Connection")) {
                    if (http10 || !value.trim().equalsIgnoreCase(HTTPConstants.HEADER_CONNECTION_CLOSE)) continue;
                    httpConnection = HTTPConstants.HEADER_CONNECTION_CLOSE;
                    continue;
                }
                if (!http10 && name.equalsIgnoreCase("Expect")) {
                    if (null == value || !value.trim().equalsIgnoreCase("100-continue")) continue;
                    httpContinueExpected = true;
                    continue;
                }
                otherHeaders.append(name).append(": ").append(value + "\r\n");
            }
        }
        if (action.length() == 0 || action.charAt(0) != '\"') {
            action = "\"" + action + "\"";
        }
        if (!http10) {
            httpConnection = HTTPConstants.HEADER_CONNECTION_CLOSE;
        }
        header.append(" ");
        header.append(http10 ? "HTTP/1.0" : "HTTP/1.1").append("\r\n");
        if (posting) {
            header.append("Content-Type").append(": ").append(requestMsg.getContentType(msgContext.getSOAPConstants())).append("\r\n");
        }
        header.append("Accept").append(": ").append("application/soap+xml").append(", ").append("application/dime").append(", ").append("multipart/related").append(", ").append("text/*").append("\r\n").append("User-Agent").append(": ").append(Messages.getMessage("axisUserAgent")).append("\r\n").append("Host").append(": ").append(host).append(port == -1 ? "" : ":" + port).append("\r\n").append("Cache-Control").append(": ").append("no-cache").append("\r\n").append("Pragma").append(": ").append("no-cache").append("\r\n").append("SOAPAction").append(": ").append(action).append("\r\n");
        if (posting) {
            if (!httpChunkStream) {
                header.append("Content-Length").append(": ").append(requestMsg.getContentLength()).append("\r\n");
            } else {
                header.append(HTTPConstants.HEADER_TRANSFER_ENCODING).append(": ").append(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED).append("\r\n");
            }
        }
        if (null != httpConnection) {
            header.append("Connection");
            header.append(": ");
            header.append(httpConnection);
            header.append("\r\n");
        }
        if (null != otherHeaders) {
            header.append(otherHeaders.toString());
        }
        header.append("\r\n");
        OutputStream out = sock.getOutputStream();
        if (!posting) {
            out.write(header.toString().getBytes("iso-8859-1"));
            out.flush();
            return null;
        }
        InputStream inp = null;
        if (httpChunkStream) {
            out.write(header.toString().getBytes("iso-8859-1"));
        }
        if (httpContinueExpected) {
            out.flush();
            MimeHeaders cheaders = new MimeHeaders();
            inp = this.readHeadersFromSocket(sock, msgContext, null, cheaders);
            int returnCode = -1;
            Integer Irc = (Integer)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
            if (null != Irc) {
                returnCode = Irc;
            }
            if (100 == returnCode) {
                msgContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                msgContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            } else {
                String statusMessage = (String)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
                fault.setFaultDetailString(Messages.getMessage("return01", "" + returnCode, ""));
                throw fault;
            }
        }
        try {
            if (!httpChunkStream) {
                out = new BufferedOutputStream(out, 8192);
                out.write(header.toString().getBytes("iso-8859-1"));
                requestMsg.writeTo(out);
                out.flush();
            } else {
                ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(out);
                out = new BufferedOutputStream(chunkedOutputStream, 8192);
                requestMsg.writeTo(out);
                out.flush();
                chunkedOutputStream.eos();
            }
        }
        catch (SOAPException e) {
            log.debug((Object)"Cannot serialize request message", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"XML request sent");
            log.debug((Object)"----------------------------------------------");
            MessagePart msgPart = (MessagePart)requestMsg.getSOAPPart();
            String xmlMessage = msgPart.getAsString();
            log.debug((Object)"----------------------------------------------");
            log.debug((Object)xmlMessage);
            log.debug((Object)"----------------------------------------------");
        }
        return inp;
    }

    private InputStream readHeadersFromSocket(Socket sock, MessageContext msgContext, InputStream inp, MimeHeaders headers) throws IOException {
        int b = 0;
        int len = 0;
        int colonIndex = -1;
        int returnCode = 0;
        if (null == inp) {
            inp = new BufferedInputStream(sock.getInputStream());
        }
        if (headers == null) {
            headers = new MimeHeaders();
        }
        boolean readTooMuch = false;
        ByteArrayOutputStream buf = new ByteArrayOutputStream(4097);
        while (true) {
            String value;
            String name;
            if (!readTooMuch) {
                b = (byte)inp.read();
            }
            if (b == -1) break;
            readTooMuch = false;
            if (b != 13 && b != 10) {
                if (b == 58 && colonIndex == -1) {
                    colonIndex = len;
                }
                ++len;
                buf.write(b);
                continue;
            }
            if (b == 13) continue;
            if (len == 0) break;
            b = (byte)inp.read();
            readTooMuch = true;
            if (b == 32 || b == 9) continue;
            buf.close();
            byte[] hdata = buf.toByteArray();
            buf.reset();
            if (colonIndex != -1) {
                name = new String(hdata, 0, colonIndex, "iso-8859-1");
                value = new String(hdata, colonIndex + 1, len - 1 - colonIndex, "iso-8859-1");
                colonIndex = -1;
            } else {
                name = new String(hdata, 0, len, "iso-8859-1");
                value = "";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(name + value));
            }
            if (msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE) == null) {
                int start = name.indexOf(32) + 1;
                String tmp = name.substring(start).trim();
                int end = tmp.indexOf(32);
                if (end != -1) {
                    tmp = tmp.substring(0, end);
                }
                returnCode = Integer.parseInt(tmp);
                msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, new Integer(returnCode));
                msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, name.substring(start + end + 1));
            } else {
                headers.addHeader(name, value.trim());
            }
            len = 0;
        }
        return inp;
    }

    private void readFromSocket(Socket sock, MessageContext msgContext, InputStream inp, MimeHeaders headers) throws IOException {
        Message responseMsg = null;
        Integer rc = (Integer)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
        int returnCode = 0;
        if (rc != null) {
            returnCode = rc;
        }
        String contentType = HTTPSender.getFirstTrimmedHeader(headers, "Content-Type");
        if (!(returnCode > 199 && returnCode < 300 || msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS || contentType != null && !contentType.startsWith("text/html") && returnCode > 499 && returnCode < 600)) {
            byte b;
            ByteArrayOutputStream buf = new ByteArrayOutputStream(4097);
            while (-1 != (b = (byte)inp.read())) {
                buf.write(b);
            }
            String statusMessage = msgContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
            fault.setFaultDetailString(Messages.getMessage("return01", "" + returnCode, buf.toString()));
            throw fault;
        }
        String transferEncoding = HTTPSender.getFirstTrimmedHeader(headers, HTTPConstants.HEADER_TRANSFER_ENCODING);
        if (HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED.equals(transferEncoding)) {
            inp = new ChunkedInputStream(inp);
        }
        SocketInputStream inputStream = new SocketInputStream(inp, sock);
        responseMsg = new Message(inputStream, false, headers);
        responseMsg.setMessageType("response");
        msgContext.setResponseMessage(responseMsg);
        if (msgContext.getMaintainSession()) {
            this.handleCookie("Cookie", "Set-Cookie", headers, msgContext);
            this.handleCookie("Cookie2", "Set-Cookie2", headers, msgContext);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"XML response received");
            log.debug((Object)"----------------------------------------------");
            MessagePart msgPart = (MessagePart)responseMsg.getSOAPPart();
            String xmlMessage = new String(msgPart.getAsBytes());
            log.debug((Object)"----------------------------------------------");
            log.debug((Object)xmlMessage);
            log.debug((Object)"----------------------------------------------");
        }
    }

    public void handleCookie(String cookieName, String setCookieName, MimeHeaders headers, MessageContext msgContext) {
        String cookie = HTTPSender.getFirstTrimmedHeader(headers, setCookieName);
        if (cookie == null) {
            return;
        }
        int index = cookie.indexOf(59);
        if (index != -1) {
            cookie = cookie.substring(0, index);
        }
        msgContext.setProperty(cookieName, cookie);
    }

    private static String getFirstTrimmedHeader(MimeHeaders headers, String name) {
        if (headers == null) {
            return null;
        }
        String[] values = headers.getHeader(name);
        if (values == null) {
            return null;
        }
        return values[0] == null ? null : values[0].trim();
    }
}

