/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.message;

import javax.xml.namespace.QName;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Constants;
import org.jboss.axis.MessageContext;
import org.jboss.axis.description.FaultDesc;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.encoding.Callback;
import org.jboss.axis.encoding.CallbackTarget;
import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.encoding.Deserializer;
import org.jboss.axis.encoding.DeserializerImpl;
import org.jboss.axis.message.SOAPFaultBuilder;
import org.jboss.axis.message.SOAPHandler;
import org.jboss.axis.soap.SOAPConstants;
import org.jboss.axis.utils.ClassUtils;
import org.jboss.axis.utils.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPFaultDetailsBuilder
extends SOAPHandler
implements Callback {
    protected SOAPFaultBuilder builder;

    public SOAPFaultDetailsBuilder(SOAPFaultBuilder builder) {
        this.builder = builder;
    }

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        SOAPConstants soapConstants = Constants.DEFAULT_SOAP_VERSION;
        if (context.getMessageContext() != null) {
            soapConstants = context.getMessageContext().getSOAPConstants();
        }
        if (soapConstants == SOAPConstants.SOAP12_CONSTANTS && attributes.getValue("http://www.w3.org/2002/12/soap-envelope", "encodingStyle") != null) {
            AxisFault fault = new AxisFault(Constants.FAULT_SOAP12_SENDER, null, Messages.getMessage("noEncodingStyleAttrAppear", "Detail"), null, null, null);
            throw new SAXException(fault);
        }
        super.startElement(namespace, localName, prefix, attributes, context);
    }

    public SOAPHandler onStartChild(String namespace, String name, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        QName qn = new QName(namespace, name);
        if (name.equals("exceptionName")) {
            Deserializer dser = context.getDeserializerForType(Constants.XSD_STRING);
            dser.registerValueTarget(new CallbackTarget(this, "exceptionName"));
            return (SOAPHandler)((Object)dser);
        }
        MessageContext msgContext = context.getMessageContext();
        SOAPConstants soapConstants = msgContext.getSOAPConstants();
        OperationDesc op = msgContext.getOperation();
        Class faultClass = null;
        QName faultXmlType = null;
        if (op != null) {
            FaultDesc faultDesc = null;
            faultXmlType = context.getTypeFromAttributes(namespace, name, attributes);
            if (faultXmlType != null) {
                faultDesc = op.getFaultByXmlType(faultXmlType);
            }
            if (faultDesc == null) {
                faultDesc = op.getFaultByQName(qn);
                if (faultXmlType == null && faultDesc != null) {
                    faultXmlType = faultDesc.getXmlType();
                }
            }
            if (faultDesc != null) {
                try {
                    faultClass = ClassUtils.forName(faultDesc.getClassName());
                }
                catch (ClassNotFoundException e) {}
            }
        } else {
            faultXmlType = context.getTypeFromAttributes(namespace, name, attributes);
        }
        if (faultClass == null) {
            faultClass = context.getTypeMapping().getClassForQName(faultXmlType);
        }
        if (faultClass != null && faultXmlType != null) {
            this.builder.setFaultClass(faultClass);
            this.builder.setWaiting(true);
            Deserializer dser = null;
            if (attributes.getValue(soapConstants.getAttrHref()) == null) {
                dser = context.getDeserializerForType(faultXmlType);
            } else {
                dser = new DeserializerImpl();
                dser.setDefaultType(faultXmlType);
            }
            if (dser != null) {
                dser.registerValueTarget(new CallbackTarget(this, "faultData"));
            }
            return (SOAPHandler)((Object)dser);
        }
        return null;
    }

    public void setValue(Object value, Object hint) {
        if ("faultData".equals(hint)) {
            this.builder.setFaultData(value);
        } else if ("exceptionName".equals(hint)) {
            String faultClassName = (String)value;
            try {
                Class faultClass = ClassUtils.forName(faultClassName);
                this.builder.setFaultClass(faultClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }
}

