/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.io.IOException;
import java.util.HashMap;
import javax.ejb.EJBException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardManager;
import org.jboss.ha.httpsession.interfaces.SerializableHttpSession;
import org.jboss.ha.httpsession.server.ClusteredHTTPSessionServiceMBean;
import org.jboss.logging.Logger;
import org.jboss.metadata.WebMetaData;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.web.tomcat.tc5.session.AbstractJBossManager;
import org.jboss.web.tomcat.tc5.session.ClusteredSession;
import org.jboss.web.tomcat.tc5.session.ClusteredSessionCMP;
import org.jboss.web.tomcat.tc5.session.ClusteredSessionValve;
import org.jboss.web.tomcat.tc5.session.ClusteringNotSupportedException;
import org.jboss.web.tomcat.tc5.session.JBossManagerCMPMBean;

public class JBossManagerCMP
extends StandardManager
implements AbstractJBossManager,
JBossManagerCMPMBean {
    private static final String info = "JBossManagerCMP/1.0";
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$web$tomcat$tc5$session$JBossManagerCMP == null ? (class$org$jboss$web$tomcat$tc5$session$JBossManagerCMP = JBossManagerCMP.class$("org.jboss.web.tomcat.tc5.session.JBossManagerCMP")) : class$org$jboss$web$tomcat$tc5$session$JBossManagerCMP));
    private ClusteredHTTPSessionServiceMBean proxy;
    private ObjectName clusteredHttpServiceName;
    protected ObjectName objectName;
    protected boolean started = false;
    private boolean useLocalCache = true;
    protected int invalidateSessionPolicy = 2;
    protected int replicationType = 0;
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$session$JBossManagerCMP;
    static /* synthetic */ Class class$org$jboss$ha$httpsession$server$ClusteredHTTPSessionServiceMBean;

    public void init(String name, WebMetaData webMetaData, boolean useJK, boolean useLocalCache) throws ClusteringNotSupportedException {
        this.useLocalCache = useLocalCache;
        this.setDistributable(true);
        this.invalidateSessionPolicy = webMetaData.getInvalidateSessionPolicy();
        this.replicationType = webMetaData.getReplicationType();
        try {
            this.clusteredHttpServiceName = new ObjectName("jboss", "service", "ClusteredHttpSession");
            this.proxy = (ClusteredHTTPSessionServiceMBean)MBeanProxyExt.create((Class)(class$org$jboss$ha$httpsession$server$ClusteredHTTPSessionServiceMBean == null ? (class$org$jboss$ha$httpsession$server$ClusteredHTTPSessionServiceMBean = JBossManagerCMP.class$("org.jboss.ha.httpsession.server.ClusteredHTTPSessionServiceMBean")) : class$org$jboss$ha$httpsession$server$ClusteredHTTPSessionServiceMBean), (ObjectName)this.clusteredHttpServiceName);
        }
        catch (Throwable e) {
            log.info((Object)"ClusteredHTTPSessionService not found");
            throw new ClusteringNotSupportedException("ClusteredHTTPSessionService not found");
        }
        try {
            this.proxy.setSessionTimeout(14400000L);
            this.objectName = new ObjectName("jboss.web:service=ClusterManager,WebModule=" + name);
            log.info((Object)"ClusteredHTTPSessionService found");
        }
        catch (Throwable e) {
            log.error((Object)"Could not create ObjectName", e);
            throw new ClusteringNotSupportedException(e.toString());
        }
    }

    public boolean isUseLocalCache() {
        return this.useLocalCache;
    }

    public Integer getLocalActiveSessionCount() {
        return new Integer(this.sessions.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredSession[] getSessions() {
        ClusteredSession[] sess = new ClusteredSession[]{};
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            sess = this.sessions.values().toArray(sess);
        }
        return sess;
    }

    public int getInvalidateSessionPolicy() {
        return this.invalidateSessionPolicy;
    }

    public int getReplicationType() {
        return this.replicationType;
    }

    public Session createSession() {
        ClusteredSessionCMP session = new ClusteredSessionCMP(this);
        session.setNew(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        String sessionId = this.getNextId();
        String jvmRoute = this.getJvmRoute();
        if (jvmRoute != null) {
            sessionId = sessionId + '.' + jvmRoute;
        }
        session.setValid(true);
        session.setId(sessionId);
        return session;
    }

    public String getJvmRouteId(String id) {
        String sessid = null;
        if (id != null && this.getJvmRoute() != null) {
            if (!this.getJvmRoute().equals(id.substring(id.indexOf(46) + 1, id.length()))) {
                sessid = id.substring(0, id.indexOf(46) + 1) + this.getJvmRoute();
                log.debug((Object)("JvmRoute id is :" + sessid));
            } else {
                return id;
            }
        }
        return sessid;
    }

    public void setSessionCookie(String sessionId) {
        HttpServletResponse response = (HttpServletResponse)ClusteredSessionValve.responseThreadLocal.get();
        this.setNewSessionCookie(sessionId, response);
    }

    public void setNewSessionCookie(String sessionId, HttpServletResponse response) {
        Context context;
        if (response != null && (context = (Context)this.container).getCookies()) {
            Cookie newCookie = new Cookie("JSESSIONID", sessionId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting cookie with session id:" + sessionId + " & name:" + "JSESSIONID"));
            }
            newCookie.setMaxAge(-1);
            newCookie.setPath(context.getPath());
            response.addCookie(newCookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session findSession(String id) throws IOException {
        ClusteredSessionCMP session = null;
        if (id == null) {
            return null;
        }
        log.debug((Object)("Looking for session with id=" + id));
        if (this.useLocalCache) {
            HashMap hashMap = this.sessions;
            synchronized (hashMap) {
                session = (ClusteredSessionCMP)((Object)this.sessions.get(id));
            }
            if (session == null && this.getJvmRoute() != null) {
                String key = this.getJvmRouteId(id);
                HashMap hashMap2 = this.sessions;
                synchronized (hashMap2) {
                    session = (ClusteredSessionCMP)((Object)this.sessions.get(key));
                }
                if (session != null) {
                    this.setSessionCookie(session.getId());
                }
            }
            if (session == null) {
                session = this.loadSession(id);
                if (session == null && this.getJvmRoute() != null) {
                    session = this.loadSession(this.getJvmRouteId(id));
                }
                if (session != null) {
                    if (this.getJvmRoute() != null) {
                        String sessionid = this.getJvmRouteId(id);
                        session.setId(sessionid);
                        this.setSessionCookie(sessionid);
                    } else {
                        log.debug((Object)"Found in distributed store - adding to local store");
                        this.add((Session)session);
                    }
                }
            }
        } else {
            String sessionId;
            session = this.loadSession(id);
            if (session == null && this.getJvmRoute() != null && (session = this.loadSession(sessionId = this.getJvmRouteId(id))) != null) {
                session.setId(sessionId);
                this.setSessionCookie(sessionId);
                id = sessionId;
            }
            if (session != null) {
                HashMap hashMap = this.sessions;
                synchronized (hashMap) {
                    this.sessions.put(id, session);
                }
            }
        }
        if (session != null) {
            log.debug((Object)"Found");
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session) {
        if (session == null) {
            return;
        }
        if (!session.isValid()) {
            log.error((Object)("Cannot add session with id=" + session.getId() + " because it is invalid"));
            return;
        }
        if (session instanceof ClusteredSessionCMP) {
            HashMap hashMap = this.sessions;
            synchronized (hashMap) {
                this.sessions.put(session.getId(), session);
                try {
                    this.storeSession(session);
                }
                catch (Exception e) {
                    log.error((Object)"Adding a session to the clustered store failed", (Throwable)e);
                }
                log.debug((Object)("Session with id=" + session.getId() + " added"));
            }
        }
        throw new IllegalArgumentException("You can only add ClusteredSessionCMPs to this Manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session) {
        if (session == null) {
            return;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            try {
                this.removeSession(session.getId());
            }
            catch (Exception e) {
                log.warn((Object)"Removing a session from the clustered store failed", (Throwable)e);
            }
            this.sessions.remove(session.getId());
            log.debug((Object)("Session with id=" + session.getId() + " removed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocal(Session session) {
        if (session == null) {
            return;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(session.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocal(String id) {
        if (id == null) {
            return;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(id);
        }
    }

    protected void recycle(Session session) {
    }

    public String getInfo() {
        return info;
    }

    public void start() throws LifecycleException {
        this.startManager();
    }

    public void stop() throws LifecycleException {
        this.stopManager();
    }

    protected void startManager() throws LifecycleException {
        log.info((Object)"Starting");
        if (this.started) {
            throw new LifecycleException(sm.getString("standardManager.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            server.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            log.error((Object)"Could not register ClusterManagerMBean to MBeanServer", (Throwable)e);
        }
    }

    protected void stopManager() throws LifecycleException {
        log.info((Object)"Stopping");
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardManager.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            server.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            log.error((Object)"Could not unregister ClusterManagerMBean from MBeanServer", (Throwable)e);
        }
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public void run() {
    }

    private String getNextId() {
        return this.proxy.getSessionId();
    }

    public boolean storeSession(Session session) {
        if (session == null) {
            return false;
        }
        if (session.isValid()) {
            ClusteredSessionCMP cmpSession = (ClusteredSessionCMP)session;
            cmpSession.passivate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replicating session with id " + session.getId()));
            }
            if (!cmpSession.isReplicationTypeAlreadySet()) {
                cmpSession.setReplicationTypeForSession(this.replicationType);
            }
            this.proxy.setHttpSession(session.getId(), (SerializableHttpSession)session);
        }
        return true;
    }

    protected ClusteredSessionCMP loadSession(String id) {
        ClusteredSessionCMP session = null;
        if (id == null) {
            return null;
        }
        try {
            ClassLoader ctxCL = super.getContainer().getLoader().getClassLoader();
            session = (ClusteredSessionCMP)this.proxy.getHttpSession(id, ctxCL);
            if (session != null) {
                session.initAfterLoad(this);
            }
        }
        catch (EJBException e) {
            log.debug((Object)"Loading a session out of the clustered store failed", (Throwable)e);
        }
        return session;
    }

    protected void removeSession(String id) {
        if (id == null) {
            return;
        }
        try {
            this.proxy.removeHttpSession(id);
        }
        catch (EJBException e) {
            log.debug((Object)"Removing a session out of the clustered store failed", (Throwable)e);
        }
    }

    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        log.debug((Object)"Looking for sessions that have expired");
        for (int i = 0; i < sessions.length; ++i) {
            int timeIdle;
            int maxInactiveInterval;
            ClusteredSessionCMP session = (ClusteredSessionCMP)sessions[i];
            if (!session.isValid() || (maxInactiveInterval = session.getMaxInactiveInterval()) < 0 || (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) < maxInactiveInterval) continue;
            try {
                log.debug((Object)("Session with id = " + session.getId() + " has expired on local node"));
                ClusteredSessionCMP clusteredSession = this.loadSession(session.getId());
                if (clusteredSession != null) {
                    int timeIdleCluster = (int)((timeNow - clusteredSession.getLastAccessedTime()) / 1000L);
                    if (timeIdleCluster < maxInactiveInterval) {
                        log.debug((Object)("Session " + session.getId() + " has only expired on local node but is alive on another node - removing only from local store"));
                        this.removeLocal((Session)session);
                        continue;
                    }
                    log.debug((Object)("Session " + session.getId() + " has also expired on all other nodes - removing globally"));
                }
                session.expire();
                continue;
            }
            catch (Throwable t) {
                log.error((Object)("Problems while expiring session with id = " + session.getId()), t);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

