/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.web.tomcat.tc5.session.JBossCacheClusterMBean;
import org.jboss.web.tomcat.tc5.session.JBossCacheManager;

public class JBossCacheCluster
implements JBossCacheClusterMBean,
Lifecycle {
    protected static final String info = "JBossCacheCluster/2.1";
    public static Log log = LogFactory.getLog((Class)(class$org$jboss$web$tomcat$tc5$session$JBossCacheCluster == null ? (class$org$jboss$web$tomcat$tc5$session$JBossCacheCluster = JBossCacheCluster.class$("org.jboss.web.tomcat.tc5.session.JBossCacheCluster")) : class$org$jboss$web$tomcat$tc5$session$JBossCacheCluster));
    public static final String DEFAULT_CLUSTER_NAME = "Tomcat-Cluster";
    public static final String DEFAULT_ISOLATION_LEVEL = "REPEATABLE_READ";
    public static final String DEFAULT_CACHE_MODE = "REPL_ASYNC";
    public static final long DEFAULT_LOCK_TIMEOUT = 15000L;
    public static final String DEFAULT_TM_LOOKUP = (class$org$jboss$cache$DummyTransactionManagerLookup == null ? (class$org$jboss$cache$DummyTransactionManagerLookup = JBossCacheCluster.class$("org.jboss.cache.DummyTransactionManagerLookup")) : class$org$jboss$cache$DummyTransactionManagerLookup).getName();
    public static final String DEFAULT_CACHE_CONFIG_PATH = "conf/cluster-cache.xml";
    private Container container = null;
    private MBeanServer mserver = null;
    private ObjectName objectName = null;
    private boolean started = false;
    private LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private TreeCacheMBean treeCache = null;
    private String treeCacheObjectName = "jboss.cache:service=TomcatClusteringCache";
    private boolean treeCacheLocal = false;
    private String clusterName = null;
    private String cacheConfigPath = null;
    private TransactionManager tm = null;
    private String managerClassName = (class$org$jboss$web$tomcat$tc5$session$JBossCacheManager == null ? (class$org$jboss$web$tomcat$tc5$session$JBossCacheManager = JBossCacheCluster.class$("org.jboss.web.tomcat.tc5.session.JBossCacheManager")) : class$org$jboss$web$tomcat$tc5$session$JBossCacheManager).getName();
    private boolean useJK = false;
    private boolean useLocalCache = false;
    private String defaultReplicationTrigger = null;
    private String defaultReplicationGranularity = null;
    private String snapshotMode = null;
    private int snapshotInterval = 0;
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$session$JBossCacheCluster;
    static /* synthetic */ Class class$org$jboss$cache$DummyTransactionManagerLookup;
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$session$JBossCacheManager;
    static /* synthetic */ Class class$org$jboss$cache$TreeCacheMBean;

    public String getCacheObjectName() {
        return this.treeCacheObjectName;
    }

    public void setCacheObjectName(String objectName) {
        this.treeCacheObjectName = objectName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getCacheConfigPath() {
        return this.cacheConfigPath;
    }

    public void setCacheConfigPath(String cacheConfigPath) {
        this.cacheConfigPath = cacheConfigPath;
    }

    public String getManagerClassName() {
        return this.managerClassName;
    }

    public void setManagerClassName(String managerClassName) {
        this.managerClassName = managerClassName;
    }

    public boolean isUseJK() {
        return this.useJK;
    }

    public void setUseJK(boolean useJK) {
        this.useJK = useJK;
    }

    public boolean isUseLocalCache() {
        return this.useLocalCache;
    }

    public void setUseLocalCache(boolean useLocalCache) {
        this.useLocalCache = useLocalCache;
    }

    public String getDefaultReplicationGranularity() {
        return this.defaultReplicationGranularity;
    }

    public void setDefaultReplicationGranularity(String defaultReplicationGranularity) {
        this.defaultReplicationGranularity = defaultReplicationGranularity;
    }

    public String getDefaultReplicationTrigger() {
        return this.defaultReplicationTrigger;
    }

    public void setDefaultReplicationTrigger(String defaultTrigger) {
        this.defaultReplicationTrigger = defaultTrigger;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public int getSnapshotInterval() {
        return this.snapshotInterval;
    }

    public void setSnapshotInterval(int snapshotInterval) {
        this.snapshotInterval = snapshotInterval;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manager createManager(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating ClusterManager for context " + name + " using class " + this.getManagerClassName()));
        }
        Manager manager = null;
        try {
            manager = (Manager)this.getClass().getClassLoader().loadClass(this.getManagerClassName()).newInstance();
        }
        catch (Exception x) {
            log.error((Object)"Unable to load class for replication manager", (Throwable)x);
            manager = new JBossCacheManager();
        }
        finally {
            manager.setDistributable(true);
        }
        if (manager instanceof JBossCacheManager) {
            this.configureManager((JBossCacheManager)manager);
        }
        return manager;
    }

    public void backgroundProcess() {
    }

    public String getProtocol() {
        return null;
    }

    public void setProtocol(String protocol) {
    }

    public void startContext(String contextPath) throws IOException {
    }

    public void installContext(String contextPath, URL war) {
    }

    public void stop(String contextPath) throws IOException {
    }

    public void configureManager(JBossCacheManager manager) {
        manager.setSnapshotMode(this.snapshotMode);
        manager.setSnapshotInterval(this.snapshotInterval);
        manager.setUseJK(this.useJK);
        manager.setUseLocalCache(this.useLocalCache);
        manager.setTransactionManager(this.tm);
        manager.setCacheObjectNameString(this.treeCacheObjectName);
        if (manager.getReplicationGranularityString() == null) {
            manager.setReplicationGranularityString(this.defaultReplicationGranularity);
        }
        if (manager.getReplicationTriggerString() == null) {
            manager.setReplicationTriggerString(this.defaultReplicationTrigger);
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException("Cluster already started");
        }
        this.lifecycle.fireLifecycleEvent("before_start", (Object)this);
        try {
            MBeanServerLocator.setJBoss((MBeanServer)this.getMBeanServer());
            TreeCacheMBean cache = this.getTreeCache();
            if (this.treeCacheLocal) {
                cache.createService();
                cache.startService();
            }
            this.tm = cache.getTransactionManager();
            if (this.tm == null) {
                throw new LifecycleException("TreeCache does not have a transaction manager; please configure a valid TransactionManagerLookupClass");
            }
            this.registerMBeans();
            this.started = true;
            this.lifecycle.fireLifecycleEvent("after_start", (Object)this);
        }
        catch (LifecycleException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"Unable to start cluster.", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new IllegalStateException("Cluster not started");
        }
        this.lifecycle.fireLifecycleEvent("before_stop", (Object)this);
        if (this.treeCacheLocal) {
            this.treeCache.stopService();
            this.treeCache.destroyService();
        }
        this.started = false;
        this.lifecycle.fireLifecycleEvent("after_stop", (Object)this);
        this.unregisterMBeans();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    private TreeCacheMBean getTreeCache() throws Exception {
        if (this.treeCache == null) {
            ObjectName objName;
            MBeanServer server = this.getMBeanServer();
            if (server.isRegistered(objName = new ObjectName(this.treeCacheObjectName))) {
                this.treeCache = (TreeCacheMBean)MBeanProxyExt.create((Class)(class$org$jboss$cache$TreeCacheMBean == null ? (class$org$jboss$cache$TreeCacheMBean = JBossCacheCluster.class$("org.jboss.cache.TreeCacheMBean")) : class$org$jboss$cache$TreeCacheMBean), (ObjectName)objName);
            } else {
                this.treeCache = new TreeCache();
                InputStream configIS = this.getCacheConfigStream();
                if (configIS != null) {
                    PropertyConfigurator config = new PropertyConfigurator();
                    config.configure((Object)this.treeCache, configIS);
                    try {
                        configIS.close();
                    }
                    catch (IOException io) {
                        // empty catch block
                    }
                    if (this.clusterName != null) {
                        this.treeCache.setClusterName(this.clusterName);
                    }
                } else {
                    String channelName = this.clusterName == null ? DEFAULT_CLUSTER_NAME : this.clusterName;
                    this.treeCache.setClusterName(channelName);
                    this.treeCache.setIsolationLevel(DEFAULT_ISOLATION_LEVEL);
                    this.treeCache.setCacheMode(DEFAULT_CACHE_MODE);
                    this.treeCache.setLockAcquisitionTimeout(15000L);
                    this.treeCache.setTransactionManagerLookupClass(DEFAULT_TM_LOOKUP);
                }
                this.treeCacheLocal = true;
            }
        }
        return this.treeCache;
    }

    private InputStream getCacheConfigStream() throws FileNotFoundException {
        boolean useDefault = this.cacheConfigPath == null;
        String path = useDefault ? DEFAULT_CACHE_CONFIG_PATH : this.cacheConfigPath;
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), path);
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fnf) {
            if (useDefault) {
                return null;
            }
            log.error((Object)("No tree cache config file found at " + file.getAbsolutePath()));
            throw fnf;
        }
    }

    private void registerMBeans() {
        try {
            MBeanServer server = this.getMBeanServer();
            String domain = this.container instanceof ContainerBase ? ((ContainerBase)this.container).getDomain() : server.getDefaultDomain();
            String name = ":type=Cluster";
            if (this.container instanceof Host) {
                name = name + ",host=" + this.container.getName();
            } else if (this.container instanceof Engine) {
                name = name + ",engine=" + this.container.getName();
            }
            ObjectName clusterName = new ObjectName(domain + name);
            if (server.isRegistered(clusterName)) {
                log.warn((Object)("MBean " + clusterName + " already registered"));
            } else {
                this.objectName = clusterName;
                server.registerMBean(this, this.objectName);
            }
            if (this.treeCacheLocal) {
                ObjectName treeCacheName = new ObjectName(this.treeCacheObjectName);
                server.registerMBean(this.getTreeCache(), treeCacheName);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void unregisterMBeans() {
        if (this.mserver != null) {
            try {
                if (this.objectName != null) {
                    this.mserver.unregisterMBean(this.objectName);
                }
                if (this.treeCacheLocal) {
                    this.mserver.unregisterMBean(new ObjectName(this.treeCacheObjectName));
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    private MBeanServer getMBeanServer() throws Exception {
        if (this.mserver == null) {
            ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
            this.mserver = servers.size() > 0 ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        }
        return this.mserver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

