/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.catalina.Session;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.tc5.session.AbstractJBossManager;
import org.jboss.web.tomcat.tc5.session.SnapshotManager;

public class IntervalSnapshotManager
extends SnapshotManager
implements Runnable {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$web$tomcat$tc5$session$IntervalSnapshotManager == null ? (class$org$jboss$web$tomcat$tc5$session$IntervalSnapshotManager = IntervalSnapshotManager.class$("org.jboss.web.tomcat.tc5.session.IntervalSnapshotManager")) : class$org$jboss$web$tomcat$tc5$session$IntervalSnapshotManager));
    protected int interval = 1000;
    protected HashMap sessions = new HashMap();
    protected Thread thread = null;
    protected boolean threadDone = false;
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$session$IntervalSnapshotManager;

    public IntervalSnapshotManager(AbstractJBossManager manager, String path) {
        super(manager, path);
    }

    public IntervalSnapshotManager(AbstractJBossManager manager, String path, int interval) {
        super(manager, path);
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshot(String id) {
        try {
            Session session = this.manager.findSession(id);
            HashMap hashMap = this.sessions;
            synchronized (hashMap) {
                this.sessions.put(id, session);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to replicate sessionID:" + id), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSessions() {
        HashMap copy = new HashMap(this.sessions.size());
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            copy.putAll(this.sessions);
            this.sessions.clear();
        }
        Iterator iter = copy.values().iterator();
        while (iter.hasNext()) {
            Session session = (Session)iter.next();
            this.manager.storeSession(session);
        }
        copy.clear();
    }

    public void start() {
        this.startThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopThread();
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.clear();
        }
    }

    protected void startThread() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "ClusteredSessionDistributor[" + this.contextPath + "]");
        this.thread.setDaemon(true);
        this.thread.setContextClassLoader(this.manager.getContainer().getLoader().getClassLoader());
        this.threadDone = false;
        this.thread.start();
    }

    protected void stopThread() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    protected void threadSleep() {
        try {
            Thread.sleep(this.interval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processSessions();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

