/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.management.Attribute;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.Loader;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.metadata.WebMetaData;
import org.jboss.web.AbstractWebContainer;
import org.jboss.web.AbstractWebDeployer;
import org.jboss.web.WebApplication;
import org.jboss.web.tomcat.security.CustomPrincipalValve;
import org.jboss.web.tomcat.security.JaccContextValve;
import org.jboss.web.tomcat.security.RunAsListener;
import org.jboss.web.tomcat.security.SecurityAssociationValve;
import org.jboss.web.tomcat.tc5.DeployerConfig;
import org.jboss.web.tomcat.tc5.WebAppLoader;
import org.jboss.web.tomcat.tc5.WebCtxLoader;
import org.jboss.web.tomcat.tc5.session.AbstractJBossManager;
import org.jboss.web.tomcat.tc5.session.ClusteringNotSupportedException;
import org.jboss.web.tomcat.tc5.session.JBossCacheManager;

public class TomcatDeployer
extends AbstractWebDeployer {
    private static final String CONTEXT_CONFIG_FILE = "WEB-INF/context.xml";
    private DeployerConfig config;
    private String[] javaVMs = new String[]{" jboss.management.local:J2EEServer=Local,j2eeType=JVM,name=localhost"};
    private String serverName = "jboss";
    private HashMap vhostToHostNames = new HashMap();

    public void init(Object containerConfig) throws Exception {
        this.config = (DeployerConfig)containerConfig;
        super.setJava2ClassLoadingCompliance(this.config.isJava2ClassLoadingCompliance());
        super.setUnpackWars(this.config.isUnpackWars());
        super.setLenientEjbLink(this.config.isLenientEjbLink());
        super.setDefaultSecurityDomain(this.config.getDefaultSecurityDomain());
    }

    protected void performDeploy(WebApplication appInfo, String warUrl, AbstractWebContainer.WebDescriptorParser webAppParser) throws Exception {
        WebMetaData metaData = appInfo.getMetaData();
        String hostName = null;
        Iterator vhostNames = metaData.getVirtualHosts();
        Iterator hostNames = this.mapVirtualHosts(vhostNames);
        if (hostNames.hasNext()) {
            hostName = hostNames.next().toString();
        }
        this.performDeployInternal(hostName, appInfo, warUrl, webAppParser);
        while (hostNames.hasNext()) {
            String additionalHostName = hostNames.next().toString();
            this.performDeployInternal(additionalHostName, appInfo, warUrl, webAppParser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performDeployInternal(String hostName, WebApplication appInfo, String warUrl, AbstractWebContainer.WebDescriptorParser webAppParser) throws Exception {
        WebMetaData metaData = appInfo.getMetaData();
        String ctxPath = metaData.getContextRoot();
        if (ctxPath.equals("/") || ctxPath.equals("/ROOT") || ctxPath.equals("")) {
            this.log.debug((Object)("deploy root context=" + ctxPath));
            ctxPath = "/";
            metaData.setContextRoot(ctxPath);
        }
        this.log.info((Object)("deploy, ctxPath=" + ctxPath + ", warUrl=" + this.shortWarUrlFromServerHome(warUrl)));
        URL url = new URL(warUrl);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Object webLoader = null;
        if (this.config.isUseJBossWebLoader()) {
            WebCtxLoader jbossLoader = new WebCtxLoader(loader);
            jbossLoader.setWarURL(url);
            webLoader = jbossLoader;
        } else {
            String[] pkgs = this.config.getFilteredPackages();
            WebAppLoader jbossLoader = new WebAppLoader(loader, pkgs);
            webLoader = jbossLoader;
        }
        if (appInfo.getAppData() == null) {
            webAppParser.parseWebAppDescriptors(loader, appInfo.getMetaData());
        }
        appInfo.setName(url.getPath());
        appInfo.setClassLoader(loader);
        appInfo.setURL(url);
        String objectNameS = this.config.getCatalinaDomain() + ":j2eeType=WebModule,name=//" + (hostName == null ? "localhost" : hostName) + ctxPath + ",J2EEApplication=none,J2EEServer=none";
        ObjectName objectName = new ObjectName(objectNameS);
        if (this.server.isRegistered(objectName)) {
            this.log.debug((Object)("Already exists, destroying " + objectName));
            this.server.invoke(objectName, "destroy", new Object[0], new String[0]);
        }
        this.server.createMBean("org.apache.commons.modeler.BaseModelMBean", objectName, new Object[]{this.config.getContextClassName()}, new String[]{"java.lang.String"});
        String ctxConfig = null;
        try {
            ctxConfig = this.findConfig(url);
        }
        catch (IOException e) {
            this.log.debug((Object)("No WEB-INF/context.xml in " + url), (Throwable)e);
        }
        this.server.setAttribute(objectName, new Attribute("docBase", url.getFile()));
        this.server.setAttribute(objectName, new Attribute("configFile", ctxConfig));
        this.server.setAttribute(objectName, new Attribute("defaultContextXml", "context.xml"));
        this.server.setAttribute(objectName, new Attribute("defaultWebXml", "conf/web.xml"));
        this.server.setAttribute(objectName, new Attribute("javaVMs", this.javaVMs));
        this.server.setAttribute(objectName, new Attribute("server", this.serverName));
        this.server.setAttribute(objectName, new Attribute("saveConfig", Boolean.FALSE));
        if (webLoader != null) {
            this.server.setAttribute(objectName, new Attribute("loader", webLoader));
        } else {
            this.server.setAttribute(objectName, new Attribute("parentClassLoader", loader));
        }
        this.server.setAttribute(objectName, new Attribute("delegate", new Boolean(this.getJava2ClassLoadingCompliance())));
        String[] jspCP = this.getCompileClasspath(loader);
        StringBuffer classpath = new StringBuffer();
        for (int u = 0; u < jspCP.length; ++u) {
            String repository = jspCP[u];
            if (repository == null) continue;
            if (repository.startsWith("file://")) {
                repository = repository.substring(7);
            } else {
                if (!repository.startsWith("file:")) continue;
                repository = repository.substring(5);
            }
            if (repository == null) continue;
            File fp = new File(repository);
            if (!fp.isDirectory()) {
                try {
                    if (fp.getName().toLowerCase().endsWith(".xml")) continue;
                    ZipFile zip = new ZipFile(fp);
                    zip.close();
                }
                catch (IOException e) {
                    continue;
                }
            }
            if (u > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(repository);
        }
        this.server.setAttribute(objectName, new Attribute("compilerClasspath", classpath.toString()));
        switch (metaData.getSessionCookies()) {
            case 1: {
                this.server.setAttribute(objectName, new Attribute("cookies", new Boolean(true)));
                this.log.debug((Object)"Enabling session cookies");
                break;
            }
            case 2: {
                this.server.setAttribute(objectName, new Attribute("cookies", new Boolean(false)));
                this.log.debug((Object)"Disabling session cookies");
                break;
            }
            default: {
                this.log.debug((Object)"Using session cookies default setting");
            }
        }
        Certificate[] certs = null;
        CodeSource cs = new CodeSource(url, certs);
        JaccContextValve jaccValve = new JaccContextValve(metaData.getJaccContextID(), cs);
        this.server.invoke(objectName, "addValve", new Object[]{jaccValve}, new String[]{"org.apache.catalina.Valve"});
        RunAsListener.metaDataLocal.set(metaData);
        try {
            this.server.invoke(objectName, "init", new Object[0], new String[0]);
        }
        finally {
            RunAsListener.metaDataLocal.set(null);
        }
        Loader ctxLoader = (Loader)this.server.getAttribute(objectName, "loader");
        metaData.setContextLoader(ctxLoader.getClassLoader());
        if (metaData.getDistributable()) {
            try {
                AbstractJBossManager manager = null;
                String managerClassName = this.config.getManagerClass();
                Class<?> managerClass = Thread.currentThread().getContextClassLoader().loadClass(managerClassName);
                manager = (AbstractJBossManager)managerClass.newInstance();
                String name = "//" + (hostName == null ? "localhost" : hostName) + ctxPath;
                manager.init(name, metaData, this.config.isUseJK(), this.config.isUseLocalCache());
                if (manager instanceof JBossCacheManager) {
                    String snapshotMode = this.config.getSnapshotMode();
                    int snapshotInterval = this.config.getSnapshotInterval();
                    JBossCacheManager jbcm = (JBossCacheManager)manager;
                    jbcm.setSnapshotMode(snapshotMode);
                    jbcm.setSnapshotInterval(snapshotInterval);
                }
                this.server.setAttribute(objectName, new Attribute("manager", manager));
                this.log.debug((Object)("Enabled clustering support for ctxPath=" + ctxPath));
            }
            catch (ClusteringNotSupportedException e) {
                this.log.error((Object)"Failed to setup clustering, clustering disabled");
            }
        }
        SecurityAssociationValve valve = new SecurityAssociationValve(metaData, this.config.getSecurityManagerService());
        valve.setSubjectAttributeName(this.config.getSubjectAttributeName());
        this.server.invoke(objectName, "addValve", new Object[]{valve}, new String[]{"org.apache.catalina.Valve"});
        CustomPrincipalValve cpvalve = new CustomPrincipalValve();
        this.server.invoke(objectName, "addValve", new Object[]{cpvalve}, new String[]{"org.apache.catalina.Valve"});
        Integer state = (Integer)this.server.getAttribute(objectName, "state");
        if (state != 1) {
            throw new DeploymentException("URL " + warUrl + " deployment failed");
        }
        appInfo.setAppData((Object)objectName);
        DeploymentInfo di = webAppParser.getDeploymentInfo();
        di.deployedObject = objectName;
        ObjectName servletQuery = new ObjectName(this.config.getCatalinaDomain() + ":j2eeType=Servlet,WebModule=" + objectName.getKeyProperty("name") + ",*");
        Iterator<ObjectInstance> iterator = this.server.queryMBeans(servletQuery, null).iterator();
        while (iterator.hasNext()) {
            di.mbeans.add(iterator.next().getObjectName());
        }
        this.log.debug((Object)("Initialized: " + appInfo + " " + objectName));
    }

    protected void performUndeploy(String warUrl, WebApplication appInfo) throws Exception {
        if (appInfo == null) {
            this.log.debug((Object)("performUndeploy, no WebApplication found for URL " + warUrl));
            return;
        }
        this.log.info((Object)("undeploy, ctxPath=" + appInfo.getMetaData().getContextRoot() + ", warUrl=" + this.shortWarUrlFromServerHome(warUrl)));
        WebMetaData metaData = appInfo.getMetaData();
        String hostName = null;
        Iterator hostNames = metaData.getVirtualHosts();
        if (hostNames.hasNext()) {
            hostName = hostNames.next().toString();
        }
        this.performUndeployInternal(hostName, warUrl, appInfo);
        while (hostNames.hasNext()) {
            String additionalHostName = hostNames.next().toString();
            this.performUndeployInternal(additionalHostName, warUrl, appInfo);
        }
    }

    protected void performUndeployInternal(String hostName, String warUrl, WebApplication appInfo) throws Exception {
        WebMetaData metaData = appInfo.getMetaData();
        String ctxPath = metaData.getContextRoot();
        if (this.server == null) {
            return;
        }
        ObjectName objectName = new ObjectName(this.config.getCatalinaDomain() + ":j2eeType=WebModule,name=//" + (hostName == null ? "localhost" : hostName) + ctxPath + ",J2EEApplication=none,J2EEServer=none");
        if (this.server.isRegistered(objectName)) {
            this.server.invoke(objectName, "destroy", new Object[0], new String[0]);
        }
    }

    protected synchronized Iterator mapVirtualHosts(Iterator vhostNames) throws Exception {
        if (this.vhostToHostNames.size() == 0) {
            String hostQuery = this.config.getCatalinaDomain() + ":type=Host,*";
            ObjectName query = new ObjectName(hostQuery);
            Set<ObjectName> hosts = this.server.queryNames(query, null);
            Iterator<ObjectName> iter = hosts.iterator();
            while (iter.hasNext()) {
                ObjectName host = iter.next();
                String name = host.getKeyProperty("host");
                if (name == null) continue;
                this.vhostToHostNames.put(name, name);
                String[] aliases = (String[])this.server.invoke(host, "findAliases", null, null);
                int count = aliases != null ? aliases.length : 0;
                for (int n = 0; n < count; ++n) {
                    this.vhostToHostNames.put(aliases[n], name);
                }
            }
        }
        HashSet<String> hosts = new HashSet<String>();
        while (vhostNames.hasNext()) {
            String vhost = (String)vhostNames.next();
            String host = (String)this.vhostToHostNames.get(vhost);
            if (host == null) {
                this.log.warn((Object)("Failed to map vhost: " + vhost));
                host = vhost;
            }
            hosts.add(host);
        }
        return hosts.iterator();
    }

    private String findConfig(URL warURL) throws IOException {
        String result = null;
        File warFile = new File(warURL.getFile());
        if (warURL.getProtocol().equals("file") && warFile.isDirectory()) {
            File webDD = new File(warFile, CONTEXT_CONFIG_FILE);
            if (webDD.exists()) {
                result = webDD.getAbsolutePath();
            }
        } else {
            ZipFile zipFile = new ZipFile(warFile);
            ZipEntry entry = zipFile.getEntry(CONTEXT_CONFIG_FILE);
            if (entry != null) {
                int bytes;
                InputStream zipIS = zipFile.getInputStream(entry);
                byte[] buffer = new byte[512];
                result = warFile.getAbsolutePath() + "-context.xml";
                FileOutputStream fos = new FileOutputStream(result);
                while ((bytes = zipIS.read(buffer)) > 0) {
                    fos.write(buffer, 0, bytes);
                }
                zipIS.close();
                fos.close();
            }
            zipFile.close();
        }
        return result;
    }

    private String shortWarUrlFromServerHome(String warUrl) {
        String serverHomeUrl = System.getProperty("jboss.server.home.url");
        if (warUrl == null || serverHomeUrl == null) {
            return warUrl;
        }
        if (warUrl.startsWith(serverHomeUrl)) {
            return ".../" + warUrl.substring(serverHomeUrl.length());
        }
        return warUrl;
    }
}

