/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import javax.persistence.EntityTransaction;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ejb.AbstractEntityManagerImpl;

public class TransactionImpl
implements EntityTransaction {
    private AbstractEntityManagerImpl entityManager;
    private Transaction tx;

    public TransactionImpl(AbstractEntityManagerImpl entityManager) {
        this.entityManager = entityManager;
    }

    private Session getSession() {
        return this.entityManager.getSession();
    }

    public void begin() {
        if (this.tx != null && this.tx.isActive()) {
            throw new IllegalStateException("Transaction already active");
        }
        this.tx = this.getSession().beginTransaction();
    }

    public void commit() {
        if (this.tx == null || !this.tx.isActive()) {
            throw new IllegalStateException("Transaction not active");
        }
        this.tx.commit();
    }

    public void rollback() {
        if (this.tx == null || !this.tx.isActive()) {
            throw new IllegalStateException("Transaction not active");
        }
        this.tx.rollback();
    }

    public boolean isActive() {
        return this.tx != null && this.tx.isActive();
    }
}

