/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContextType;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.CurrentEntityManagerImpl;
import org.hibernate.ejb.EntityManagerImpl;
import org.hibernate.ejb.HibernateEntityManagerFactory;

public class EntityManagerFactoryImpl
implements HibernateEntityManagerFactory {
    private SessionFactory sessionFactory;

    public EntityManagerFactoryImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public EntityManager createEntityManager() {
        return this.createEntityManager(PersistenceContextType.TRANSACTION);
    }

    public EntityManager createEntityManager(PersistenceContextType type) {
        return new EntityManagerImpl(this.sessionFactory, type);
    }

    public EntityManager getEntityManager() {
        return new CurrentEntityManagerImpl(this.sessionFactory);
    }

    public void close() {
        this.sessionFactory.close();
    }

    public boolean isOpen() {
        return !this.sessionFactory.isClosed();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }
}

