/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.util.ArrayList;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;
import org.jboss.util.NestedRuntimeException;

public class TransactionSynchronizer
implements Synchronization {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$resource$connectionmanager$TransactionSynchronizer == null ? (class$org$jboss$resource$connectionmanager$TransactionSynchronizer = TransactionSynchronizer.class$("org.jboss.resource.connectionmanager.TransactionSynchronizer")) : class$org$jboss$resource$connectionmanager$TransactionSynchronizer));
    protected static TransactionLocal txSynchs;
    protected Transaction tx;
    protected Thread enlistingThread;
    protected ArrayList unenlisted;
    protected ArrayList enlisted;
    protected Synchronization ccmSynch;
    static /* synthetic */ Class class$org$jboss$resource$connectionmanager$TransactionSynchronizer;

    public static void setTransactionManager(TransactionManager tm) {
        txSynchs = new TransactionLocal(tm);
    }

    private TransactionSynchronizer(Transaction tx) {
        this.tx = tx;
    }

    synchronized void addUnenlisted(Synchronization synch) {
        if (this.unenlisted == null) {
            this.unenlisted = new ArrayList();
        }
        this.unenlisted.add(synch);
    }

    synchronized ArrayList getUnenlisted() {
        Thread currentThread = Thread.currentThread();
        while (this.enlistingThread != null && this.enlistingThread != currentThread) {
            boolean interrupted = false;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            if (!interrupted) continue;
            currentThread.interrupt();
        }
        ArrayList result = this.unenlisted;
        this.unenlisted = null;
        if (result != null) {
            this.enlistingThread = currentThread;
        }
        return result;
    }

    synchronized void addEnlisted(Synchronization synch) {
        if (this.enlisted == null) {
            this.enlisted = new ArrayList();
        }
        this.enlisted.add(synch);
    }

    synchronized boolean removeEnlisted(Synchronization synch) {
        return this.enlisted.remove(synch);
    }

    synchronized void enlisted() {
        Thread currentThread = Thread.currentThread();
        if (this.enlistingThread == null || this.enlistingThread != currentThread) {
            log.warn((Object)("Thread " + currentThread + " not the enlisting thread " + this.enlistingThread), (Throwable)new Exception("STACKTRACE"));
            return;
        }
        this.enlistingThread = null;
        this.notifyAll();
    }

    static TransactionSynchronizer getRegisteredSynchronizer(Transaction tx) throws RollbackException, SystemException {
        TransactionSynchronizer result = (TransactionSynchronizer)txSynchs.get(tx);
        if (result == null) {
            result = new TransactionSynchronizer(tx);
            tx.registerSynchronization((Synchronization)result);
            txSynchs.set(tx, (Object)result);
        }
        return result;
    }

    static Synchronization getCCMSynchronization(Transaction tx) {
        TransactionSynchronizer ts = (TransactionSynchronizer)txSynchs.get(tx);
        if (ts != null) {
            return ts.ccmSynch;
        }
        return null;
    }

    static void registerCCMSynchronization(Transaction tx, Synchronization synch) throws RollbackException, SystemException {
        TransactionSynchronizer ts = TransactionSynchronizer.getRegisteredSynchronizer(tx);
        ts.ccmSynch = synch;
    }

    static void lock(Transaction tx) {
        try {
            txSynchs.lock(tx);
        }
        catch (InterruptedException e) {
            throw new NestedRuntimeException("Unable to get synchronization", (Throwable)e);
        }
    }

    static void unlock(Transaction tx) {
        txSynchs.unlock(tx);
    }

    public void beforeCompletion() {
        if (this.enlisted != null) {
            for (int i = 0; i < this.enlisted.size(); ++i) {
                Synchronization synch = (Synchronization)this.enlisted.get(i);
                this.invokeBefore(synch);
            }
        }
        if (this.ccmSynch != null) {
            this.invokeBefore(this.ccmSynch);
        }
    }

    public void afterCompletion(int status) {
        if (this.enlisted != null) {
            for (int i = 0; i < this.enlisted.size(); ++i) {
                Synchronization synch = (Synchronization)this.enlisted.get(i);
                this.invokeAfter(synch, status);
            }
        }
        if (this.ccmSynch != null) {
            this.invokeAfter(this.ccmSynch, status);
        }
    }

    protected void invokeBefore(Synchronization synch) {
        try {
            synch.beforeCompletion();
        }
        catch (Throwable t) {
            log.warn((Object)("Transaction " + this.tx + " error in before completion " + synch), t);
        }
    }

    protected void invokeAfter(Synchronization synch, int status) {
        try {
            synch.afterCompletion(status);
        }
        catch (Throwable t) {
            log.warn((Object)("Transaction " + this.tx + " error in after completion " + synch), t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

