/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut.ast;

import java.util.ArrayList;
import org.jboss.aop.pointcut.ast.ASTAllParameter;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTException;
import org.jboss.aop.pointcut.ast.ASTParameter;
import org.jboss.aop.pointcut.ast.ClassExpression;
import org.jboss.aop.pointcut.ast.IdentifierExpression;
import org.jboss.aop.pointcut.ast.Node;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
import org.jboss.aop.pointcut.ast.PointcutExpressionParserVisitor;
import org.jboss.aop.pointcut.ast.SimpleNode;
import org.jboss.aop.pointcut.ast.TypeExpressionParserVisitor;

public class ASTMethod
extends SimpleNode {
    String returnTypeExpr;
    ClassExpression returnType;
    String classExpr;
    ClassExpression clazz;
    String methodExpr;
    IdentifierExpression methodIdentifier;
    boolean anyParameters = false;
    ArrayList parameters = new ArrayList();
    ArrayList attributes = new ArrayList();
    ArrayList exceptions = new ArrayList();

    public ASTMethod(int id) {
        super(id);
    }

    public ASTMethod(PointcutExpressionParser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(PointcutExpressionParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object jjtAccept(TypeExpressionParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        if (n instanceof ASTAttribute) {
            this.attributes.add(n);
        } else if (n instanceof ASTException) {
            this.exceptions.add(n);
        } else if (n instanceof ASTAllParameter) {
            this.anyParameters = true;
        } else if (n instanceof ASTParameter && !this.anyParameters) {
            this.parameters.add(0, n);
        } else {
            if (n instanceof ASTParameter && this.anyParameters) {
                throw new RuntimeException("AST grammar error, you should not be able to add a parameter to a constructor that already has '..' in param list.");
            }
            super.jjtAddChild(n, i);
        }
    }

    public void setMethodExpression(String expression) {
        this.methodExpr = expression;
        this.methodIdentifier = new IdentifierExpression(expression);
    }

    public void setReturnTypeExpression(String exp) {
        this.returnTypeExpr = exp;
        this.returnType = new ClassExpression(exp);
    }

    public void setClassExpression(String exp) {
        this.classExpr = exp;
        this.clazz = new ClassExpression(exp);
    }

    public String getReturnTypeExpression() {
        return this.returnTypeExpr;
    }

    public String getClassExpr() {
        return this.classExpr;
    }

    public String getMethodExpr() {
        return this.methodExpr;
    }

    public boolean isAnyParameters() {
        return this.anyParameters;
    }

    public ArrayList getParameters() {
        return this.parameters;
    }

    public ArrayList getExceptions() {
        return this.exceptions;
    }

    public ArrayList getAttributes() {
        return this.attributes;
    }

    public ClassExpression getReturnType() {
        return this.returnType;
    }

    public ClassExpression getClazz() {
        return this.clazz;
    }

    public IdentifierExpression getMethodIdentifier() {
        return this.methodIdentifier;
    }
}

