/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.components.encoding;

import java.io.UnsupportedEncodingException;
import org.jboss.axis.components.encoding.EncodedByteArray;
import org.jboss.axis.components.encoding.XMLEncoder;
import org.jboss.axis.utils.Messages;

public abstract class AbstractXMLEncoder
implements XMLEncoder {
    private static final byte[] AMP = "&amp;".getBytes();
    private static final byte[] QUOTE = "&quot;".getBytes();
    private static final byte[] LESS = "&lt;".getBytes();
    private static final byte[] GREATER = "&gt;".getBytes();
    private static final byte[] LF = "\n".getBytes();
    private static final byte[] CR = "\r".getBytes();
    private static final byte[] TAB = "\t".getBytes();

    public String encode(String xmlString) {
        if (xmlString == null) {
            return "";
        }
        char[] characters = xmlString.toCharArray();
        EncodedByteArray out = null;
        block11: for (int i = 0; i < characters.length; ++i) {
            char character = characters[i];
            switch (character) {
                case '&': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(AMP);
                    continue block11;
                }
                case '\"': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(QUOTE);
                    continue block11;
                }
                case '<': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(LESS);
                    continue block11;
                }
                case '>': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(GREATER);
                    continue block11;
                }
                case '\n': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(LF);
                    continue block11;
                }
                case '\r': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(CR);
                    continue block11;
                }
                case '\t': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(TAB);
                    continue block11;
                }
                default: {
                    if (character < ' ') {
                        throw new IllegalArgumentException(Messages.getMessage("invalidXmlCharacter00", Integer.toHexString(character), xmlString));
                    }
                    if (this.needsEncoding(character)) {
                        if (out == null) {
                            out = this.getInitialByteArray(xmlString, i);
                        }
                        this.appendEncoded(out, character);
                        continue block11;
                    }
                    if (out == null) continue block11;
                    out.append(character);
                }
            }
        }
        if (out == null) {
            return xmlString;
        }
        try {
            return out.toString(this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(Messages.getMessage("encodingDisappeared00", this.getEncoding()));
        }
    }

    public abstract String getEncoding();

    public abstract boolean needsEncoding(char var1);

    public abstract void appendEncoded(EncodedByteArray var1, char var2);

    private EncodedByteArray getInitialByteArray(String aXmlString, int pos) {
        try {
            return new EncodedByteArray(aXmlString.getBytes(this.getEncoding()), 0, pos);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(Messages.getMessage("encodingDisappeared00", this.getEncoding()));
        }
    }
}

