/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.client;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.holders.Holder;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Constants;
import org.jboss.axis.client.Call;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.description.ParameterDesc;
import org.jboss.axis.enums.Style;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.logging.Logger;

public class AxisClientProxy
implements InvocationHandler {
    private static Logger log = Logger.getLogger((String)AxisClientProxy.class.getName());
    private Call call;
    private QName portName;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;

    AxisClientProxy(Call call, QName portName) {
        this.call = call;
        this.portName = portName;
    }

    private Object[] proxyParams2CallParams(Object[] proxyParams) throws JavaUtils.HolderException, ServiceException {
        ArrayList<Object> callParams = new ArrayList<Object>();
        OperationDesc opDesc = this.call.getOperation();
        if (opDesc == null || proxyParams == null) {
            return proxyParams;
        }
        for (int i = 0; proxyParams != null && i < proxyParams.length; ++i) {
            Object param = proxyParams[i];
            ParameterDesc paramDesc = opDesc.getParameter(i);
            if (paramDesc == null) {
                throw new ServiceException("Cannot obtain parameter " + i + " for: " + opDesc);
            }
            if (paramDesc.getMode() == 3) {
                callParams.add(JavaUtils.getHolderValue((Holder)param));
                continue;
            }
            if (paramDesc.getMode() != 1) continue;
            callParams.add(param);
        }
        return callParams.toArray();
    }

    private void proxyReturn2CallReturn(Class proxyReturn) {
        OperationDesc operationDesc = this.call.getOperation();
        if (operationDesc != null) {
            Class operationReturn = operationDesc.getReturnClass();
            if (proxyReturn != null && operationReturn != null) {
                Style style;
                if (proxyReturn.equals(DataHandler.class)) {
                    operationDesc.setReturnClass(DataHandler.class);
                    operationDesc.setReturnType(Constants.MIME_DATA_HANDLER);
                }
                if ((style = this.call.getOperation().getStyle()) != Style.DOCUMENT && !JavaUtils.isConvertable(operationReturn, proxyReturn)) {
                    log.debug((Object)("Fixing return class: " + operationReturn + " -> " + proxyReturn));
                    operationDesc.setReturnClass(proxyReturn);
                }
            }
            if (proxyReturn == null && operationReturn != null) {
                log.debug((Object)("Forcing return class to null: " + operationReturn));
                operationDesc.setReturnClass(null);
            }
        }
    }

    private void callOutputParams2proxyParams(Object[] proxyParams) throws JavaUtils.HolderException {
        OperationDesc operationDesc = this.call.getOperation();
        if (operationDesc == null || proxyParams == null) {
            return;
        }
        Map outputParams = this.call.getOutputParams();
        for (int i = 0; i < operationDesc.getNumParams(); ++i) {
            Object value;
            Object param = proxyParams[i];
            ParameterDesc paramDesc = operationDesc.getParameter(i);
            if (paramDesc.getMode() == 1) continue;
            if ((class$javax$xml$rpc$holders$Holder == null ? AxisClientProxy.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder).isAssignableFrom((value = outputParams.get(paramDesc.getQName())).getClass())) {
                value = JavaUtils.getHolderValue(value);
            }
            JavaUtils.setHolderValue((Holder)param, value);
        }
    }

    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        try {
            if (method.getName().equals("_setProperty")) {
                this.call.setProperty((String)objects[0], objects[1]);
                return null;
            }
            if (method.getName().equals("_getProperty")) {
                return this.call.getProperty((String)objects[0]);
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.call.hashCode());
            }
            if (method.getName().equals("toString")) {
                return this.call.toString();
            }
            if (method.getName().equals("equals")) {
                return new Boolean(o == objects[0]);
            }
            this.setupCallOperation(method);
            Object retObj = this.invokeSEIMethod(method, objects);
            return retObj;
        }
        catch (AxisFault af) {
            if (af.detail != null) {
                throw af.detail;
            }
            throw af;
        }
    }

    public Object invokeSEIMethod(Method method, Object[] args) throws Throwable {
        try {
            Object outValue;
            if (this.call.getTargetEndpointAddress() != null && this.call.getPortName() != null) {
                Object[] paramsCall = this.proxyParams2CallParams(args);
                this.proxyReturn2CallReturn(method.getReturnType());
                outValue = this.call.invoke(paramsCall);
            } else if (this.portName != null) {
                Object[] paramsCall = this.proxyParams2CallParams(args);
                this.proxyReturn2CallReturn(method.getReturnType());
                outValue = this.call.invoke(paramsCall);
            } else {
                Object[] paramsCall = args;
                this.proxyReturn2CallReturn(method.getReturnType());
                outValue = this.call.invoke(method.getName(), paramsCall);
            }
            this.callOutputParams2proxyParams(args);
            outValue = this.callReturn2ProxyReturn(outValue, method.getReturnType());
            return outValue;
        }
        catch (AxisFault af) {
            if (af.detail != null) {
                throw af.detail;
            }
            throw af;
        }
    }

    public void setupCallOperation(Method method) {
        if (this.call.getTargetEndpointAddress() != null && this.call.getPortName() != null) {
            this.call.setOperation(method.getName());
        } else if (this.portName != null) {
            this.call.setOperation(this.portName, method.getName());
        }
    }

    private Object callReturn2ProxyReturn(Object callReturn, Class proxyReturnType) {
        if (callReturn == null) {
            return callReturn;
        }
        Style style = this.call.getOperation().getStyle();
        if (style != Style.DOCUMENT && JavaUtils.isConvertable(callReturn, proxyReturnType)) {
            Object retObj = JavaUtils.convert(callReturn, proxyReturnType);
            log.debug((Object)("Converted to: " + retObj.getClass().getName()));
            return retObj;
        }
        if (callReturn instanceof ArrayList) {
            Object retObj = this.convertArrayList(callReturn);
            log.debug((Object)("Converted to: " + retObj.getClass().getName()));
            return retObj;
        }
        return callReturn;
    }

    private Object convertArrayList(Object outValue) {
        Object value = ((ArrayList)outValue).toArray();
        if (value.getClass().isArray() && !value.getClass().getComponentType().isPrimitive()) {
            int len = Array.getLength(value);
            Class<?> type = null;
            for (int x = 0; x < len; ++x) {
                Object o = Array.get(value, x);
                if (o == null) continue;
                if (type == null) {
                    type = o.getClass();
                    continue;
                }
                if (type.getName().equals(o.getClass().getName())) continue;
                type = null;
                break;
            }
            if (type != null) {
                Object convertedArray = Array.newInstance(type, len);
                System.arraycopy(value, 0, convertedArray, 0, len);
                value = convertedArray;
            }
        }
        return value;
    }

    public Call getCall() {
        return this.call;
    }
}

