/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.plugins;

import java.net.URL;
import java.util.Set;
import org.jboss.classloading.plugins.WrappingClassLoader;
import org.jboss.classloading.spi.ClassLoadingDomain;
import org.jboss.classloading.spi.DomainClassLoader;
import org.jboss.util.ClassLoading;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class DelegatingDomainClassLoader
extends JBossObject
implements DomainClassLoader {
    protected ClassLoadingDomain domain;
    protected WrappingClassLoader delegate;

    public DelegatingDomainClassLoader(ClassLoader delegate) {
        this.delegate = new WrappingClassLoader(delegate);
    }

    public ClassLoadingDomain getDomain() {
        return this.domain;
    }

    public void setDomain(ClassLoadingDomain domain) {
        this.domain = domain;
    }

    public Class loadClassLocally(String name, boolean resolve) throws ClassNotFoundException {
        return this.delegate.getParent().loadClass(name);
    }

    public URL loadResourceLocally(String name) {
        return this.delegate.getParent().getResource(name);
    }

    public Set getPackages() {
        return ClassLoading.getClassLoaderSpecificPackages(this.delegate);
    }

    public Package getPackage(String name) {
        return this.delegate.getPackage(name);
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("classLoader=" + this.delegate.getParent());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append((Object)this.delegate.getParent());
    }
}

