/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import org.apache.catalina.Realm;

public class GenericPrincipal
implements Principal {
    protected String name = null;
    protected String password = null;
    protected Realm realm = null;
    protected String[] roles = new String[0];

    public GenericPrincipal(Realm realm, String name, String password) {
        this(realm, name, password, null);
    }

    public GenericPrincipal(Realm realm, String name, String password, List roles) {
        this.realm = realm;
        this.name = name;
        this.password = password;
        if (roles != null) {
            this.roles = new String[roles.size()];
            this.roles = roles.toArray(this.roles);
            if (this.roles.length > 0) {
                Arrays.sort(this.roles);
            }
        }
    }

    public GenericPrincipal(String name, String password, List roles) {
        this.name = name;
        this.password = password;
        if (roles != null) {
            this.roles = new String[roles.size()];
            this.roles = roles.toArray(this.roles);
            if (this.roles.length > 0) {
                Arrays.sort(this.roles);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public Realm getRealm() {
        return this.realm;
    }

    void setRealm(Realm realm) {
        this.realm = realm;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public boolean hasRole(String role) {
        if ("*".equals(role)) {
            return true;
        }
        if (role == null) {
            return false;
        }
        return Arrays.binarySearch(this.roles, role) >= 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("GenericPrincipal[");
        sb.append(this.name);
        sb.append("(");
        for (int i = 0; i < this.roles.length; ++i) {
            sb.append(this.roles[i]).append(",");
        }
        sb.append(")]");
        return sb.toString();
    }
}

