/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.composite;

import com.clustercontrol.bean.FacilityImageConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import java.text.DateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class LogFilterInfoTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof LogFilterInfo) {
            LogFilterInfo filterInfo = (LogFilterInfo)element;
            if (columnIndex == 0) {
                return Integer.toString(filterInfo.getOrderNo());
            }
            if (columnIndex == 1) {
                return ProcessConstant.typeToString((int)filterInfo.getProcessType());
            }
            if (columnIndex == 2) {
                if (filterInfo.getMonitorId() != null) {
                    return filterInfo.getMonitorId();
                }
            } else if (columnIndex == 3) {
                if (filterInfo.getDescription() != null) {
                    return filterInfo.getDescription();
                }
            } else if (columnIndex == 4) {
                if (filterInfo.getScope() != null) {
                    return filterInfo.getScope();
                }
            } else if (columnIndex == 5) {
                if (filterInfo.getCalendarId() != null) {
                    return filterInfo.getCalendarId();
                }
            } else {
                if (columnIndex == 6) {
                    return ValidConstant.typeToString((int)ValidConstant.booleanToType((boolean)filterInfo.isValidFlg()));
                }
                if (columnIndex == 7) {
                    if (filterInfo.getRegUser() != null) {
                        return filterInfo.getRegUser();
                    }
                } else if (columnIndex == 9) {
                    if (filterInfo.getUpdateUser() != null) {
                        return filterInfo.getUpdateUser();
                    }
                } else if (columnIndex == 8) {
                    if (filterInfo.getRegDate() != null) {
                        return DateFormat.getDateTimeInstance().format(filterInfo.getRegDate());
                    }
                } else if (columnIndex == 10 && filterInfo.getUpdateDate() != null) {
                    return DateFormat.getDateTimeInstance().format(filterInfo.getUpdateDate());
                }
            }
        }
        return "";
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof LogFilterInfo) {
            LogFilterInfo filterInfo = (LogFilterInfo)element;
            if (columnIndex == 4 && filterInfo.getFacilityId() != null) {
                Pattern p = Pattern.compile(".*>");
                Matcher m = p.matcher(filterInfo.getFacilityId());
                if (m.matches()) {
                    return FacilityImageConstant.typeToImage((int)0);
                }
                return FacilityImageConstant.typeToImage((int)1);
            }
        }
        return null;
    }
}

