/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.transaction.xa.Xid;
import org.jboss.tm.XidFactoryMBean;
import org.jboss.tm.XidImpl;

public class XidFactory
implements XidFactoryMBean {
    private String baseGlobalId;
    private long globalIdNumber = 0L;
    private boolean pad = false;
    private byte[] noBranchQualifier = new byte[1];
    private byte[] baseGlobalIdBytes;

    public XidFactory() {
        try {
            this.baseGlobalId = InetAddress.getLocalHost().getHostName();
            if (this.baseGlobalId.length() > 49) {
                this.baseGlobalId = this.baseGlobalId.substring(0, 49);
            }
            this.baseGlobalId = this.baseGlobalId + "/";
        }
        catch (UnknownHostException e) {
            this.baseGlobalId = "localhost/";
        }
        this.baseGlobalIdBytes = this.baseGlobalId.getBytes();
    }

    public String getBaseGlobalId() {
        return this.baseGlobalId;
    }

    public void setBaseGlobalId(String baseGlobalId) {
        this.baseGlobalId = baseGlobalId;
        this.baseGlobalIdBytes = baseGlobalId.getBytes();
    }

    public synchronized long getGlobalIdNumber() {
        return this.globalIdNumber;
    }

    public synchronized void setGlobalIdNumber(long globalIdNumber) {
        this.globalIdNumber = globalIdNumber;
    }

    public boolean isPad() {
        return this.pad;
    }

    public void setPad(boolean pad) {
        this.pad = pad;
        this.noBranchQualifier = pad ? new byte[64] : new byte[1];
    }

    public XidFactoryMBean getInstance() {
        return this;
    }

    public XidImpl newXid() {
        long localId = this.getNextId();
        String id = Long.toString(localId);
        int len = this.pad ? 64 : id.length() + this.baseGlobalIdBytes.length;
        byte[] globalId = new byte[len];
        System.arraycopy(this.baseGlobalIdBytes, 0, globalId, 0, this.baseGlobalIdBytes.length);
        id.getBytes(0, id.length(), globalId, this.baseGlobalIdBytes.length);
        return new XidImpl(globalId, this.noBranchQualifier, (int)localId, localId);
    }

    public XidImpl newBranch(XidImpl xid, long branchIdNum) {
        String id = Long.toString(branchIdNum);
        int len = this.pad ? 64 : id.length();
        byte[] branchId = new byte[len];
        id.getBytes(0, id.length(), branchId, 0);
        return new XidImpl(xid, branchId);
    }

    public long extractLocalIdFrom(byte[] globalId) {
        int len = globalId.length;
        int i = 0;
        while (globalId[i++] != 47) {
        }
        int start = i;
        while (i < len && globalId[i] != 0) {
            ++i;
        }
        String globalIdNumber = new String(globalId, 0, start, i - start);
        return Long.parseLong(globalIdNumber);
    }

    public String toString(Xid xid) {
        if (xid instanceof XidImpl) {
            return XidImpl.toString(xid);
        }
        return xid.toString();
    }

    private synchronized long getNextId() {
        return ++this.globalIdNumber;
    }
}

