/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.action;

import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.SyslogNGController;
import com.clustercontrol.syslogng.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.eclipse.jface.dialogs.MessageDialog;

public class LogManager {
    private static LogManager INSTANCE = null;
    private Map cashe = null;
    private List orderList = null;
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<LogManager> clazz = LogManager.class;
        synchronized (LogManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new LogManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private LogManager() {
    }

    public void initialize() {
        this.loadLog();
    }

    public Object[] get() {
        Object[] records = this.orderList.toArray();
        return records;
    }

    public LogFilterInfo get(String logId) {
        return (LogFilterInfo)this.cashe.get(logId);
    }

    public boolean add(LogFilterInfo log) {
        if (!this.checkMonitorId(log.getMonitorId())) {
            Object[] args = new String[]{log.getMonitorId()};
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.monitor.53", (Object[])args));
            return false;
        }
        int order = this.cashe.size() + 1;
        log.setOrderNo(order);
        log.setLogId("newLog" + order);
        this.cashe.put(log.getLogId(), log);
        this.orderList.add(log);
        return true;
    }

    private boolean checkMonitorId(String monitorId) {
        boolean check = true;
        if (monitorId == null) {
            return check;
        }
        Object[] records = this.get();
        int i = 0;
        while (i < records.length) {
            LogFilterInfo info = (LogFilterInfo)records[i];
            if (monitorId.equals(info.getMonitorId())) {
                check = false;
                break;
            }
            ++i;
        }
        return check;
    }

    public boolean modify(LogFilterInfo log) {
        if (!this.cashe.containsKey(log.getLogId())) {
            return false;
        }
        this.cashe.put(log.getLogId(), log);
        this.orderList.set(log.getOrderNo() - 1, log);
        return true;
    }

    public boolean delete(String logId) {
        if (!this.cashe.containsKey(logId)) {
            return false;
        }
        LogFilterInfo log = (LogFilterInfo)this.cashe.remove(logId);
        this.orderList.remove(log.getOrderNo() - 1);
        int order = 0;
        Iterator ite = this.orderList.iterator();
        while (ite.hasNext()) {
            ((LogFilterInfo)ite.next()).setOrderNo(++order);
        }
        return true;
    }

    public boolean upOrder(String logId) {
        if (!this.cashe.containsKey(logId)) {
            return false;
        }
        LogFilterInfo log = (LogFilterInfo)this.cashe.get(logId);
        int oldOrder = log.getOrderNo();
        int newOrder = oldOrder - 1;
        if (newOrder < 1) {
            return false;
        }
        return this.change(oldOrder, newOrder);
    }

    public boolean downOrder(String logId) {
        if (!this.cashe.containsKey(logId)) {
            return false;
        }
        LogFilterInfo log = (LogFilterInfo)this.cashe.get(logId);
        int oldOrder = log.getOrderNo();
        int newOrder = oldOrder + 1;
        if (newOrder > this.cashe.size()) {
            return false;
        }
        return this.change(oldOrder, newOrder);
    }

    public boolean commit() {
        SyslogNGController syslog = EjbConnectionManager.getConnectionManager().getSyslogNGController();
        try {
            return syslog.createMonitorRuleList((ArrayList)this.orderList);
        }
        catch (RemoteException e) {
            if (e instanceof AccessException) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
        }
        catch (CreateException createException) {
        }
        catch (RemoveException removeException) {
        }
        catch (FinderException finderException) {
        }
        catch (NamingException namingException) {}
        return true;
    }

    public boolean rollback() {
        this.loadLog();
        return true;
    }

    private void loadLog() {
        this.cashe = new HashMap();
        this.orderList = new ArrayList();
        SyslogNGController syslog = EjbConnectionManager.getConnectionManager().getSyslogNGController();
        ArrayList records = new ArrayList();
        try {
            records = syslog.getFilterInfoList();
        }
        catch (RemoteException e) {
            if (e instanceof AccessException) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
        }
        catch (CreateException createException) {
        }
        catch (FinderException finderException) {
        }
        catch (NamingException namingException) {}
        int index = 0;
        for (Object o : records) {
            LogFilterInfo log = (LogFilterInfo)o;
            log.setLogId("newLog" + index);
            this.cashe.put(log.getLogId(), log);
            this.orderList.add(log);
            ++index;
        }
    }

    private boolean change(int index1, int index2) {
        LogFilterInfo log1 = (LogFilterInfo)this.orderList.get(--index1);
        LogFilterInfo log2 = (LogFilterInfo)this.orderList.get(--index2);
        int order1 = log1.getOrderNo();
        int order2 = log2.getOrderNo();
        log1.setOrderNo(order2);
        log2.setOrderNo(order1);
        this.orderList.set(index1, log2);
        this.orderList.set(index2, log1);
        return true;
    }
}

