/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite.action;

import com.clustercontrol.collectiverun.action.DeleteMaster;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.composite.action.BaseTreeItemSelectionListener;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;

public class DeleteTreeItemSelectionListener
extends BaseTreeItemSelectionListener {
    public DeleteTreeItemSelectionListener(TreeComposite composite) {
        super(composite);
    }

    public void widgetSelected(SelectionEvent e) {
        if (!this.checkCreateItem()) {
            return;
        }
        if (!this.checkUpdateItem()) {
            return;
        }
        TreeItem item = this.composite.getSelectItem();
        if (item instanceof TreeItem) {
            TreeItem parent = item.getParent();
            ItemInfo info = item.getInfo();
            ItemInfo parentInfo = parent.getInfo();
            if (info.getType() == -2 || info.getType() == -3) {
                return;
            }
            Object[] args = new Object[]{item.getInfo().getName()};
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.collective.run.10", (Object[])args))) {
                DeleteMaster delete = new DeleteMaster();
                if (delete.delete(info, parentInfo)) {
                    parent.removeChildren(item);
                    this.composite.setCreateItem(null);
                    this.composite.getTreeViewer().refresh((Object)parent);
                    this.composite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)parent), true);
                } else {
                    this.composite.getTreeViewer().refresh((Object)parent);
                    this.composite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)item), true);
                }
            }
        }
    }
}

