/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;
import javax.management.relation.RoleUnresolved;
import javax.management.relation.RoleUnresolvedList;

class RoleValidator {
    RoleValidator() {
    }

    public static int checkRole(ObjectName relationService, MBeanServer server, String relationTypeName, Role role, boolean write) throws RelationTypeNotFoundException {
        RoleInfo roleInfo = null;
        try {
            roleInfo = (RoleInfo)server.invoke(relationService, "getRoleInfo", new Object[]{relationTypeName, role.getRoleName()}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (MBeanException mbe) {
            Exception e = mbe.getTargetException();
            if (e instanceof RelationTypeNotFoundException) {
                throw (RelationTypeNotFoundException)e;
            }
            if (e instanceof RoleInfoNotFoundException) {
                return 1;
            }
            throw new RuntimeException(e.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        if (write && !roleInfo.isWritable()) {
            return 3;
        }
        ArrayList mbeans = (ArrayList)role.getRoleValue();
        int beanCount = mbeans.size();
        int minimum = roleInfo.getMinDegree();
        if (minimum != RoleInfo.ROLE_CARDINALITY_INFINITY && minimum > beanCount) {
            return 4;
        }
        int maximum = roleInfo.getMaxDegree();
        if (maximum != RoleInfo.ROLE_CARDINALITY_INFINITY && maximum < beanCount) {
            return 5;
        }
        String className = roleInfo.getRefMBeanClassName();
        Iterator iterator = mbeans.iterator();
        while (iterator.hasNext()) {
            try {
                ObjectName objectName = (ObjectName)iterator.next();
                if (server.isInstanceOf(objectName, className)) continue;
                return 6;
            }
            catch (Exception e) {
                return 7;
            }
        }
        return 0;
    }

    public static RoleResult checkRoles(ObjectName relationService, MBeanServer server, String relationTypeName, RoleList roleList, boolean write) throws RelationTypeNotFoundException {
        RoleList resolved = new RoleList();
        RoleUnresolvedList unresolved = new RoleUnresolvedList();
        RoleResult result = new RoleResult(resolved, unresolved);
        Iterator iterator = roleList.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            int status = RoleValidator.checkRole(relationService, server, relationTypeName, role, write);
            if (status == 0) {
                resolved.add(role);
                continue;
            }
            unresolved.add(new RoleUnresolved(role.getRoleName(), role.getRoleValue(), status));
        }
        return result;
    }

    public static void validateRole(ObjectName relationService, MBeanServer server, String relationTypeName, Role role, boolean write) throws InvalidRoleValueException, RelationTypeNotFoundException, RoleNotFoundException {
        int status = RoleValidator.checkRole(relationService, server, relationTypeName, role, write);
        if (status == 1) {
            throw new RoleNotFoundException(role.getRoleName());
        }
        if (status == 3) {
            throw new RoleNotFoundException(role.getRoleName() + " not writable");
        }
        if (status != 0) {
            throw new InvalidRoleValueException(role.getRoleName());
        }
    }

    public static void validateRoles(ObjectName relationService, MBeanServer server, String relationTypeName, RoleList roleList, boolean write) throws InvalidRoleValueException, RelationTypeNotFoundException, RoleNotFoundException {
        HashSet roleNames = new HashSet();
        Iterator iterator = roleList.iterator();
        while (iterator.hasNext()) {
            Object roleName = iterator.next();
            if (roleNames.contains(roleName)) {
                throw new InvalidRoleValueException("Duplicate role " + roleName);
            }
            roleNames.add(roleName);
        }
        RoleResult result = RoleValidator.checkRoles(relationService, server, relationTypeName, roleList, write);
        RoleUnresolvedList errors = result.getRolesUnresolved();
        iterator = errors.iterator();
        if (iterator.hasNext()) {
            RoleUnresolved unresolved = (RoleUnresolved)iterator.next();
            int status = unresolved.getProblemType();
            if (status == 1) {
                throw new RoleNotFoundException(unresolved.getRoleName());
            }
            if (status == 3) {
                throw new RoleNotFoundException(unresolved.getRoleName() + " not writable");
            }
            throw new InvalidRoleValueException(unresolved.getRoleName());
        }
    }
}

