/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite;

import com.clustercontrol.collectiverun.action.ModifyMaster;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.composite.action.MasterInfoModifyListener;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ParameterSelectComposite
extends Composite {
    private Text name = null;
    private Text value = null;
    private TreeItem selectItem = null;
    private TreeComposite composite = null;

    public ParameterSelectComposite(Composite parent, int style, TreeComposite composite) {
        super(parent, style);
        this.composite = composite;
        this.selectItem = composite.getSelectItem();
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(10, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        GridData gridData = null;
        Label label = null;
        Group group = new Group((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 10;
        group.setLayoutData((Object)gridData);
        group.setText(Messages.getString((String)"select.item"));
        layout = new GridLayout(10, true);
        group.setLayout((Layout)layout);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"name")) + " : ");
        this.name = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.name.setLayoutData((Object)gridData);
        this.name.addModifyListener((ModifyListener)new MasterInfoModifyListener(this.composite));
        this.name.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"value")) + " : ");
        this.value = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.value.setLayoutData((Object)gridData);
        this.value.addModifyListener((ModifyListener)new MasterInfoModifyListener(this.composite));
        this.value.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        label.setLayoutData((Object)gridData);
        Button buttonCreate = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        buttonCreate.setLayoutData((Object)gridData);
        buttonCreate.setText(Messages.getString((String)"apply"));
        buttonCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValidateResult result = ParameterSelectComposite.this.validate();
                if (result != null) {
                    ParameterSelectComposite.this.displayError(result);
                }
            }
        });
        this.update();
    }

    public void update() {
        if (this.selectItem instanceof TreeItem && this.selectItem.getInfo() instanceof ParameterSelectInfo) {
            ParameterSelectInfo info = (ParameterSelectInfo)this.selectItem.getInfo();
            if (info.getName() != null) {
                this.name.setText(info.getName());
            }
            if (info.getValue() != null) {
                this.value.setText(info.getValue());
            }
        }
        this.composite.setUpdateItem(null);
    }

    public ValidateResult createParameterSelectInfo() {
        ValidateResult result = null;
        if (this.selectItem instanceof TreeItem && this.selectItem.getInfo() instanceof ParameterSelectInfo) {
            ParameterSelectInfo info = (ParameterSelectInfo)this.selectItem.getInfo();
            ParameterSelectInfo cloneInfo = (ParameterSelectInfo)info.clone();
            ItemInfo parentInfo = this.selectItem.getParent().getInfo();
            cloneInfo.setId(((ParameterInfo)parentInfo).getId());
            if (this.name.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.collective.run.3"));
                return result;
            }
            cloneInfo.setName(this.name.getText());
            if (this.value.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.collective.run.7"));
                return result;
            }
            cloneInfo.setValue(this.value.getText());
            ModifyMaster modify = new ModifyMaster();
            if (modify.update((ItemInfo)cloneInfo, parentInfo)) {
                this.selectItem.setInfo((ItemInfo)cloneInfo);
                this.composite.setCreateItem(null);
                this.composite.setUpdateItem(null);
                this.composite.getTreeViewer().refresh((Object)this.selectItem);
            } else {
                Object[] args = new Object[]{cloneInfo.getName()};
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.collective.run.14", (Object[])args));
            }
        }
        return null;
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createParameterSelectInfo();
        if (result != null) {
            return result;
        }
        return null;
    }

    protected void displayError(ValidateResult result) {
        MessageDialog.openWarning(null, (String)result.getID(), (String)result.getMessage());
    }

    public TreeItem getSelectItem() {
        return this.selectItem;
    }

    public void setSelectItem(TreeItem selectItem) {
        this.selectItem = selectItem;
    }
}

