/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands.contexts;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextEvent;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextListener;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.core.internal.commands.util.Util;

public final class ContextManager
implements IContextListener {
    public static boolean DEBUG = false;
    private Set activeContextIds = new HashSet();
    private Collection listeners = null;
    private final Map contextsById = new HashMap();
    private final Set definedContextIds = new HashSet();

    public final void addActiveContext(String contextId) {
        if (this.activeContextIds.contains(contextId)) {
            return;
        }
        HashSet previouslyActiveContextIds = new HashSet(this.activeContextIds);
        this.activeContextIds.add(contextId);
        if (DEBUG) {
            System.out.println("CONTEXTS >> " + this.activeContextIds);
        }
        this.fireContextManagerChanged(new ContextManagerEvent(this, null, false, true, previouslyActiveContextIds));
    }

    public final void addContextManagerListener(IContextManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    public final void contextChanged(ContextEvent contextEvent) {
        if (contextEvent.isDefinedChanged()) {
            Context context = contextEvent.getContext();
            String contextId = context.getId();
            boolean contextIdAdded = context.isDefined();
            if (contextIdAdded) {
                this.definedContextIds.add(contextId);
            } else {
                this.definedContextIds.remove(contextId);
            }
            this.fireContextManagerChanged(new ContextManagerEvent(this, contextId, contextIdAdded, false, null));
        }
    }

    private final void fireContextManagerChanged(ContextManagerEvent contextManagerEvent) {
        if (contextManagerEvent == null) {
            throw new NullPointerException();
        }
        if (this.listeners != null) {
            Iterator listenerItr = this.listeners.iterator();
            while (listenerItr.hasNext()) {
                IContextManagerListener listener = (IContextManagerListener)listenerItr.next();
                listener.contextManagerChanged(contextManagerEvent);
            }
        }
    }

    public final Set getActiveContextIds() {
        return Collections.unmodifiableSet(this.activeContextIds);
    }

    public final Context getContext(String contextId) {
        if (contextId == null) {
            throw new NullPointerException();
        }
        Context context = (Context)this.contextsById.get(contextId);
        if (context == null) {
            context = new Context(contextId);
            this.contextsById.put(contextId, context);
            context.addContextListener(this);
        }
        return context;
    }

    public final Set getDefinedContextIds() {
        return Collections.unmodifiableSet(this.definedContextIds);
    }

    public final void removeActiveContext(String contextId) {
        if (!this.activeContextIds.contains(contextId)) {
            return;
        }
        HashSet previouslyActiveContextIds = new HashSet(this.activeContextIds);
        this.activeContextIds.remove(contextId);
        if (DEBUG) {
            System.out.println("CONTEXTS >> " + this.activeContextIds);
        }
        this.fireContextManagerChanged(new ContextManagerEvent(this, null, false, true, previouslyActiveContextIds));
    }

    public final void removeContextManagerListener(IContextManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public final void setActiveContextIds(Set activeContextIds) {
        if (Util.equals(this.activeContextIds, activeContextIds)) {
            return;
        }
        Set previouslyActiveContextIds = this.activeContextIds;
        if (activeContextIds != null) {
            this.activeContextIds = new HashSet();
            this.activeContextIds.addAll(activeContextIds);
        } else {
            this.activeContextIds = null;
        }
        if (DEBUG) {
            System.out.println("CONTEXTS >> " + activeContextIds);
        }
        this.fireContextManagerChanged(new ContextManagerEvent(this, null, false, true, previouslyActiveContextIds));
    }
}

