/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterValuesException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.internal.commands.util.Util;

public final class ParameterizedCommand
implements Comparable {
    private static final int HASH_CODE_NOT_COMPUTED = -1;
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL;
    public static final int INDEX_PARAMETER_ID = 0;
    public static final int INDEX_PARAMETER_NAME = 1;
    public static final int INDEX_PARAMETER_VALUE_NAME = 2;
    public static final int INDEX_PARAMETER_VALUE_VALUE = 3;
    private final Command command;
    private transient int hashCode = -1;
    private final Parameterization[] parameterizations;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.commands.ParameterizedCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    private static final Collection expandParameters(int startIndex, IParameter[] parameters) {
        boolean noMoreParameters = startIndex + 1 >= parameters.length;
        IParameter parameter = parameters[startIndex];
        IParameterValues values = null;
        try {
            values = parameter.getValues();
        }
        catch (ParameterValuesException parameterValuesException) {
            if (noMoreParameters) {
                return Collections.EMPTY_LIST;
            }
            return ParameterizedCommand.expandParameters(startIndex, parameters);
        }
        Map parameterValues = values.getParameterValues();
        ArrayList<Object> parameterizations = new ArrayList<Object>(parameterValues.size());
        Iterator parameterValueItr = parameterValues.entrySet().iterator();
        while (parameterValueItr.hasNext()) {
            Map.Entry entry = parameterValueItr.next();
            Parameterization parameterization = new Parameterization(parameter, (String)entry.getValue());
            parameterizations.add(parameterization);
        }
        if (parameter.isOptional()) {
            parameterizations.add(null);
        }
        int parameterizationCount = parameterizations.size();
        if (noMoreParameters) {
            int i = 0;
            while (i < parameterizationCount) {
                Parameterization parameterization = (Parameterization)parameterizations.get(i);
                ArrayList<Parameterization> combination = new ArrayList<Parameterization>(1);
                combination.add(parameterization);
                parameterizations.set(i, combination);
                ++i;
            }
            return parameterizations;
        }
        Collection suffixes = ParameterizedCommand.expandParameters(startIndex + 1, parameters);
        if (suffixes.isEmpty()) {
            int i = 0;
            while (i < parameterizationCount) {
                Parameterization parameterization = (Parameterization)parameterizations.get(i);
                ArrayList<Parameterization> combination = new ArrayList<Parameterization>(1);
                combination.add(parameterization);
                parameterizations.set(i, combination);
                ++i;
            }
            return parameterizations;
        }
        ArrayList returnValue = new ArrayList();
        Iterator suffixItr = suffixes.iterator();
        while (suffixItr.hasNext()) {
            List combination = (List)suffixItr.next();
            int combinationSize = combination.size();
            int i = 0;
            while (i < parameterizationCount) {
                Parameterization parameterization = (Parameterization)parameterizations.get(i);
                ArrayList<Parameterization> newCombination = new ArrayList<Parameterization>(combinationSize + 1);
                newCombination.add(parameterization);
                newCombination.addAll(combination);
                returnValue.add(newCombination);
                ++i;
            }
        }
        return returnValue;
    }

    public static final Collection generateCombinations(Command command) throws NotDefinedException {
        IParameter[] parameters = command.getParameters();
        if (parameters == null) {
            return Collections.singleton(new ParameterizedCommand(command, null));
        }
        Collection expansion = ParameterizedCommand.expandParameters(0, parameters);
        ArrayList<ParameterizedCommand> combinations = new ArrayList<ParameterizedCommand>(expansion.size());
        Iterator expansionItr = expansion.iterator();
        while (expansionItr.hasNext()) {
            List combination = (List)expansionItr.next();
            while (combination.remove(null)) {
            }
            if (combination.isEmpty()) {
                combinations.add(new ParameterizedCommand(command, null));
                continue;
            }
            Parameterization[] parameterizations = combination.toArray(new Parameterization[combination.size()]);
            combinations.add(new ParameterizedCommand(command, parameterizations));
        }
        return combinations;
    }

    public ParameterizedCommand(Command command, Parameterization[] parameterizations) {
        if (command == null) {
            throw new NullPointerException("A parameterized command cannot have a null command");
        }
        this.command = command;
        this.parameterizations = parameterizations;
    }

    public final int compareTo(Object object) {
        ParameterizedCommand command = (ParameterizedCommand)object;
        boolean thisDefined = this.command.isDefined();
        boolean otherDefined = command.command.isDefined();
        if (!thisDefined || !otherDefined) {
            return Util.compare(thisDefined, otherDefined);
        }
        try {
            return this.getName().compareTo(command.getName());
        }
        catch (NotDefinedException notDefinedException) {
            throw new Error("Concurrent modification of a command's defined state");
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ParameterizedCommand)) {
            return false;
        }
        ParameterizedCommand command = (ParameterizedCommand)object;
        if (!Util.equals(this.command, command.command)) {
            return false;
        }
        return Util.equals(this.parameterizations, command.parameterizations);
    }

    public final Command getCommand() {
        return this.command;
    }

    public final String getId() {
        return this.command.getId();
    }

    public final String getName() throws NotDefinedException {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(this.command.getName());
        if (this.parameterizations != null) {
            nameBuffer.append(" (");
            int parameterizationCount = this.parameterizations.length;
            int i = 0;
            while (i < parameterizationCount) {
                Parameterization parameterization = this.parameterizations[i];
                nameBuffer.append(parameterization.getParameter().getName());
                nameBuffer.append(": ");
                try {
                    nameBuffer.append(parameterization.getValueName());
                }
                catch (ParameterValuesException parameterValuesException) {}
                if (i + 1 < parameterizationCount) {
                    nameBuffer.append(", ");
                }
                ++i;
            }
            nameBuffer.append(')');
        }
        return nameBuffer.toString();
    }

    public final Map getParameterMap() {
        if (this.parameterizations == null || this.parameterizations.length == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        int i = 0;
        while (i < this.parameterizations.length) {
            Parameterization parameterization = this.parameterizations[i];
            parameterMap.put(parameterization.getParameter().getId(), parameterization.getValue());
            ++i;
        }
        return parameterMap;
    }

    public final Object execute(Object trigger, Object applicationContext) throws ExecutionException, NotHandledException {
        return this.command.execute(new ExecutionEvent(this.getParameterMap(), trigger, applicationContext));
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = HASH_INITIAL * 89 + Util.hashCode(this.command);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.parameterizations);
            if (this.hashCode == -1) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ParameterizedCommand(");
        buffer.append(this.command);
        buffer.append(',');
        buffer.append(this.parameterizations);
        buffer.append(')');
        return buffer.toString();
    }
}

