/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.dialog;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.calendar.composite.CalendarIdListComposite;
import com.clustercontrol.composite.ComboModifyListener;
import com.clustercontrol.composite.NumberKeyListener;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.maintenance.action.AddMaintenance;
import com.clustercontrol.maintenance.action.GetMaintenance;
import com.clustercontrol.maintenance.action.ModifyMaintenance;
import com.clustercontrol.maintenance.bean.MaintenanceKeepMstConstant;
import com.clustercontrol.maintenance.bean.MaintenanceTypeMstConstant;
import com.clustercontrol.maintenance.bean.ScheduleInfo;
import com.clustercontrol.maintenance.composite.MaintenanceKeepListComposite;
import com.clustercontrol.maintenance.composite.MaintenanceTypeListComposite;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoData;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.util.Messages;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MaintenanceDialog
extends CommonDialog {
    protected Text m_textMaintenanceId = null;
    protected Text m_textDescription = null;
    protected MaintenanceTypeListComposite m_maintenance_type = null;
    protected MaintenanceKeepListComposite m_maintenance_keep = null;
    protected CalendarIdListComposite m_calendarId = null;
    protected Button m_type1 = null;
    protected Button m_type2 = null;
    protected Combo m_comboMonth = null;
    protected Combo m_comboDay = null;
    protected Combo m_comboHours1 = null;
    protected Combo m_comboMinutes1 = null;
    protected Combo m_comboDayOfWeek = null;
    protected Combo m_comboHours2 = null;
    protected Combo m_comboMinutes2 = null;
    protected Shell m_shell = null;
    protected ArrayList m_schedule = null;
    protected String maintenanceId = null;
    private NotifyInfoComposite notifyInfo = null;
    private Button confirmValid = null;
    private MaintenanceInfoData maintenanceInfo = null;
    private ScheduleInfo scheduleInfo = null;
    private Date scheduleDate = null;
    private boolean referenceFlg = false;

    public MaintenanceDialog(Shell parent) {
        super(parent);
    }

    public MaintenanceDialog(Shell parent, String maintenanceId, boolean referenceFlg) {
        super(parent);
        this.maintenanceId = maintenanceId;
        this.referenceFlg = referenceFlg;
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.maintenance.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"maintenance.id")) + " : ");
        this.m_textMaintenanceId = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textMaintenanceId.setLayoutData((Object)gridData);
        if (this.maintenanceId != null && !"".equals(this.maintenanceId.trim())) {
            this.m_textMaintenanceId.setEnabled(false);
        }
        this.m_textMaintenanceId.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"description")) + " : ");
        this.m_textDescription = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textDescription.setLayoutData((Object)gridData);
        this.m_textDescription.addVerifyListener((VerifyListener)new StringVerifyListener(120));
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_maintenance_type = new MaintenanceTypeListComposite(parent, 0, true);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_maintenance_type.setLayoutData(gridData);
        this.m_maintenance_keep = new MaintenanceKeepListComposite(parent, 0, true);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_maintenance_keep.setLayoutData(gridData);
        this.m_calendarId = new CalendarIdListComposite(parent, 0, true);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_calendarId.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"schedule")) + " : ");
        Group group1 = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 20;
        group1.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group1.setLayoutData((Object)gridData);
        this.createType1(group1);
        this.createType2(group1);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"notify.attribute")) + " : ");
        Group groupNotifyAttribute = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupNotifyAttribute.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupNotifyAttribute.setLayoutData((Object)gridData);
        this.notifyInfo = new NotifyInfoComposite((Composite)groupNotifyAttribute, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.notifyInfo.setLayoutData((Object)gridData);
        this.confirmValid = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData((Object)gridData);
        this.confirmValid.setText(Messages.getString((String)"setting.valid.confirmed"));
        this.confirmValid.setSelection(true);
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        MaintenanceInfoData info = null;
        if (this.maintenanceId != null) {
            info = new GetMaintenance().getMaintenanceInfo(this.maintenanceId);
            this.setInputData(info);
        }
        this.reflectScheduleInfo();
    }

    protected void createType1(Group parent) {
        this.m_type1 = new Button((Composite)parent, 16);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_type1.setLayoutData((Object)gridData);
        this.m_type1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    MaintenanceDialog.this.m_type2.setSelection(false);
                    MaintenanceDialog.this.m_comboMonth.setEnabled(true);
                    MaintenanceDialog.this.m_comboDay.setEnabled(true);
                    MaintenanceDialog.this.m_comboHours1.setEnabled(true);
                    MaintenanceDialog.this.m_comboMinutes1.setEnabled(true);
                    MaintenanceDialog.this.m_comboDayOfWeek.setEnabled(false);
                    MaintenanceDialog.this.m_comboHours2.setEnabled(false);
                    MaintenanceDialog.this.m_comboMinutes2.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_comboMonth = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboMonth.setLayoutData((Object)gridData);
        this.m_comboMonth.setTextLimit(2);
        this.m_comboMonth.setVisibleItemCount(10);
        this.m_comboMonth.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboMonth.addModifyListener((ModifyListener)new ComboModifyListener());
        DecimalFormat format = new DecimalFormat("00");
        this.m_comboMonth.add("");
        int month = 1;
        while (month <= 12) {
            this.m_comboMonth.add(format.format(month));
            ++month;
        }
        Label labelMonth = new Label((Composite)parent, 0);
        labelMonth.setText(Messages.getString((String)"month"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelMonth.setLayoutData((Object)gridData);
        this.m_comboDay = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboDay.setLayoutData((Object)gridData);
        this.m_comboDay.setTextLimit(2);
        this.m_comboDay.setVisibleItemCount(10);
        this.m_comboDay.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboDay.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.m_comboDay.add("");
        int day = 1;
        while (day <= 31) {
            this.m_comboDay.add(format.format(day));
            ++day;
        }
        Label labelDay = new Label((Composite)parent, 0);
        labelDay.setText(Messages.getString((String)"monthday"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelDay.setLayoutData((Object)gridData);
        this.m_comboHours1 = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboHours1.setLayoutData((Object)gridData);
        this.m_comboHours1.setTextLimit(2);
        this.m_comboHours1.setVisibleItemCount(10);
        this.m_comboHours1.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboHours1.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.m_comboHours1.add("");
        int hour = 0;
        while (hour < 24) {
            this.m_comboHours1.add(format.format(hour));
            ++hour;
        }
        Label labelHours = new Label((Composite)parent, 0);
        labelHours.setText(Messages.getString((String)"hour"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelHours.setLayoutData((Object)gridData);
        this.m_comboMinutes1 = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboMinutes1.setLayoutData((Object)gridData);
        this.m_comboMinutes1.setTextLimit(2);
        this.m_comboMinutes1.setVisibleItemCount(10);
        this.m_comboMinutes1.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboMinutes1.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.m_comboMinutes1.add("");
        int minutes = 0;
        while (minutes < 60) {
            this.m_comboMinutes1.add(format.format(minutes));
            ++minutes;
        }
        Label labelMinutes = new Label((Composite)parent, 0);
        labelMinutes.setText(Messages.getString((String)"minute"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutes.setLayoutData((Object)gridData);
        Label label = new Label((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    protected void createType2(Group parent) {
        this.m_type2 = new Button((Composite)parent, 16);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_type2.setLayoutData((Object)gridData);
        this.m_type2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    MaintenanceDialog.this.m_type1.setSelection(false);
                    MaintenanceDialog.this.m_comboMonth.setEnabled(false);
                    MaintenanceDialog.this.m_comboDay.setEnabled(false);
                    MaintenanceDialog.this.m_comboHours1.setEnabled(false);
                    MaintenanceDialog.this.m_comboMinutes1.setEnabled(false);
                    MaintenanceDialog.this.m_comboDayOfWeek.setEnabled(true);
                    MaintenanceDialog.this.m_comboHours2.setEnabled(true);
                    MaintenanceDialog.this.m_comboMinutes2.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label labelDayOfWeek = new Label((Composite)parent, 0);
        labelDayOfWeek.setText(Messages.getString((String)"weekday"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelDayOfWeek.setLayoutData((Object)gridData);
        this.m_comboDayOfWeek = new Combo((Composite)parent, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        this.m_comboDayOfWeek.setLayoutData((Object)gridData);
        this.m_comboDayOfWeek.setTextLimit(3);
        this.m_comboDayOfWeek.setVisibleItemCount(10);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_SUNDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_MONDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_TUESDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_WEDNESDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_THURSDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_FRIDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_SATURDAY);
        Label labelDummy = new Label((Composite)parent, 0);
        labelDummy.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelDummy.setLayoutData((Object)gridData);
        this.m_comboHours2 = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboHours2.setLayoutData((Object)gridData);
        this.m_comboHours2.setTextLimit(2);
        this.m_comboHours2.setVisibleItemCount(10);
        this.m_comboHours2.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboHours2.addModifyListener((ModifyListener)new ComboModifyListener());
        DecimalFormat format = new DecimalFormat("00");
        this.m_comboHours2.add("");
        int hour = 0;
        while (hour < 24) {
            this.m_comboHours2.add(format.format(hour));
            ++hour;
        }
        Label labelHours = new Label((Composite)parent, 0);
        labelHours.setText(Messages.getString((String)"hour"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelHours.setLayoutData((Object)gridData);
        this.m_comboMinutes2 = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboMinutes2.setLayoutData((Object)gridData);
        this.m_comboMinutes2.setTextLimit(2);
        this.m_comboMinutes2.setVisibleItemCount(10);
        this.m_comboMinutes2.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboMinutes2.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.m_comboMinutes2.add("");
        int minutes = 0;
        while (minutes < 60) {
            this.m_comboMinutes2.add(format.format(minutes));
            ++minutes;
        }
        Label labelMinutes = new Label((Composite)parent, 0);
        labelMinutes.setText(Messages.getString((String)"minute"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutes.setLayoutData((Object)gridData);
        Label label = new Label((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    public void setSchedule(ArrayList info) {
        this.m_schedule = info;
    }

    public ArrayList getSchedule() {
        return this.m_schedule;
    }

    protected void reflectScheduleInfo() {
        if (this.m_schedule instanceof ArrayList) {
            Schedule schedule = (Schedule)this.m_schedule.get(5);
            if (schedule.getDate() instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(schedule.getDate());
                DecimalFormat format = new DecimalFormat("00");
                this.m_comboMonth.select(0);
                int i = 0;
                while (i < this.m_comboMonth.getItemCount()) {
                    String month = format.format(calendar.get(2) + 1);
                    if (month.equals(this.m_comboMonth.getItem(i))) {
                        this.m_comboMonth.select(i);
                        break;
                    }
                    ++i;
                }
                this.m_comboDay.select(0);
                i = 0;
                while (i < this.m_comboDay.getItemCount()) {
                    String day = format.format(calendar.get(5));
                    if (day.equals(this.m_comboDay.getItem(i))) {
                        this.m_comboDay.select(i);
                        break;
                    }
                    ++i;
                }
                this.m_comboHours1.select(0);
                i = 0;
                while (i < this.m_comboHours1.getItemCount()) {
                    String hours = format.format(calendar.get(11));
                    if (hours.equals(this.m_comboHours1.getItem(i))) {
                        this.m_comboHours1.select(i);
                        this.m_comboHours2.select(i);
                        break;
                    }
                    ++i;
                }
                this.m_comboMinutes1.select(0);
                i = 0;
                while (i < this.m_comboMinutes1.getItemCount()) {
                    String minutes = format.format(calendar.get(12));
                    if (minutes.equals(this.m_comboMinutes1.getItem(i))) {
                        this.m_comboMinutes1.select(i);
                        this.m_comboMinutes2.select(i);
                        break;
                    }
                    ++i;
                }
                this.m_comboDayOfWeek.select(0);
                i = 0;
                while (i < this.m_comboDayOfWeek.getItemCount()) {
                    String dayOfWeek = DayOfWeekConstant.typeToString((int)schedule.getDayOfWeek());
                    if (dayOfWeek.equals(this.m_comboDayOfWeek.getItem(i))) {
                        this.m_comboDayOfWeek.select(i);
                        break;
                    }
                    ++i;
                }
            }
            this.m_comboMonth.setEnabled(true);
            this.m_comboDay.setEnabled(true);
            this.m_comboHours1.setEnabled(true);
            this.m_comboMinutes1.setEnabled(true);
            this.m_comboDayOfWeek.setEnabled(false);
            this.m_comboHours2.setEnabled(false);
            this.m_comboMinutes2.setEnabled(false);
            if (schedule.getType() == 0) {
                this.m_type1.setSelection(true);
            } else if (schedule.getType() == 1) {
                this.m_type1.setSelection(true);
                this.m_comboMonth.select(0);
            } else if (schedule.getType() == 2) {
                this.m_type1.setSelection(true);
                this.m_comboMonth.select(0);
                this.m_comboDay.select(0);
            } else if (schedule.getType() == 3) {
                this.m_type1.setSelection(true);
                this.m_comboMonth.select(0);
                this.m_comboDay.select(0);
                this.m_comboHours1.select(0);
            } else if (schedule.getType() == 4) {
                this.m_type2.setSelection(true);
                this.m_comboMonth.select(0);
                this.m_comboDay.select(0);
                this.m_comboMonth.setEnabled(false);
                this.m_comboDay.setEnabled(false);
                this.m_comboHours1.setEnabled(false);
                this.m_comboMinutes1.setEnabled(false);
                this.m_comboDayOfWeek.setEnabled(true);
                this.m_comboHours2.setEnabled(true);
                this.m_comboMinutes2.setEnabled(true);
            }
        } else {
            this.m_type1.setSelection(true);
            this.m_comboMonth.setEnabled(true);
            this.m_comboDay.setEnabled(true);
            this.m_comboHours1.setEnabled(true);
            this.m_comboMinutes1.setEnabled(true);
            this.m_comboDayOfWeek.setEnabled(false);
            this.m_comboHours2.setEnabled(false);
            this.m_comboMinutes2.setEnabled(false);
        }
    }

    protected ValidateResult createMaintenanceInfo() {
        ValidateResult result = null;
        this.maintenanceInfo = new MaintenanceInfoData();
        this.scheduleInfo = new ScheduleInfo();
        if (this.m_textMaintenanceId.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.maintenance.9"));
            return result;
        }
        this.maintenanceInfo.setMaintenance_id(this.m_textMaintenanceId.getText());
        this.scheduleInfo.setId(this.m_textMaintenanceId.getText());
        if (this.m_textDescription.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.maintenance.10"));
            return result;
        }
        this.maintenanceInfo.setDescription(this.m_textDescription.getText());
        this.scheduleInfo.setName(this.m_textDescription.getText());
        if (this.m_textMaintenanceId.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.maintenance.9"));
            return result;
        }
        this.scheduleInfo.setJobId(this.m_textMaintenanceId.getText());
        if (this.m_textDescription.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.maintenance.10"));
            return result;
        }
        this.scheduleInfo.setJobName(this.m_textDescription.getText());
        this.maintenanceInfo.setType_id(MaintenanceTypeMstConstant.indexToTypeId((int)this.m_maintenance_type.getIndex()));
        this.maintenanceInfo.setKeep_id(MaintenanceKeepMstConstant.indexToKeepId((int)this.m_maintenance_keep.getIndex()));
        if (this.m_calendarId.getText().length() > 0) {
            this.maintenanceInfo.setCalendar_id(this.m_calendarId.getText());
            this.scheduleInfo.setCalendarId(this.m_calendarId.getText());
        } else {
            this.maintenanceInfo.setCalendar_id("");
            this.scheduleInfo.setCalendarId("");
        }
        Schedule schedule = new Schedule();
        Integer month = null;
        Integer day = null;
        Integer hours = null;
        Integer minutes = null;
        Integer week = null;
        if (this.m_type1.getSelection()) {
            if (this.m_comboMonth.getText().length() > 0) {
                month = new Integer(this.m_comboMonth.getText());
            }
            if (this.m_comboDay.getText().length() > 0) {
                day = new Integer(this.m_comboDay.getText());
            }
            if (this.m_comboHours1.getText().length() > 0) {
                hours = new Integer(this.m_comboHours1.getText());
            }
            if (this.m_comboMinutes1.getText().length() > 0) {
                minutes = new Integer(this.m_comboMinutes1.getText());
            }
            if (this.m_comboMonth.getText().length() == 0 && this.m_comboDay.getText().length() == 0 && this.m_comboHours1.getText().length() == 0) {
                schedule.setType(3);
            } else if (this.m_comboMonth.getText().length() == 0 && this.m_comboDay.getText().length() == 0) {
                schedule.setType(2);
            } else if (this.m_comboMonth.getText().length() == 0) {
                schedule.setType(1);
            } else {
                schedule.setType(0);
            }
            if (!(month instanceof Integer) && schedule.getType() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.26"));
                return result;
            }
            if (!(day instanceof Integer || schedule.getType() != 0 && schedule.getType() != 1)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.27"));
                return result;
            }
            if (!(hours instanceof Integer || schedule.getType() != 0 && schedule.getType() != 1 && schedule.getType() != 2)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.28"));
                return result;
            }
            if (!(minutes instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.29"));
                return result;
            }
        } else if (this.m_type2.getSelection()) {
            schedule.setType(4);
            if (this.m_comboDayOfWeek.getText().length() > 0) {
                week = new Integer(DayOfWeekConstant.stringToType((String)this.m_comboDayOfWeek.getText()));
            }
            if (this.m_comboHours2.getText().length() > 0) {
                hours = new Integer(this.m_comboHours2.getText());
            }
            if (this.m_comboMinutes2.getText().length() > 0) {
                minutes = new Integer(this.m_comboMinutes2.getText());
            }
            if (!(week instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.37"));
                return result;
            }
            if (!(hours instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.28"));
                return result;
            }
            if (!(minutes instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.29"));
                return result;
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 0);
        if (month instanceof Integer) {
            calendar.set(2, month - 1);
        }
        if (day instanceof Integer) {
            calendar.set(5, day);
        }
        if (hours instanceof Integer) {
            calendar.set(11, hours);
        }
        if (week instanceof Integer) {
            calendar.set(7, week);
            schedule.setDayOfWeek(week.intValue());
        }
        calendar.set(12, minutes);
        calendar.set(13, 0);
        schedule.setDate(calendar.getTime());
        this.scheduleInfo.setSchedule(schedule);
        this.maintenanceInfo.setSchedule_date(new Timestamp(schedule.getDate().getTime()));
        this.maintenanceInfo.setNotify_id(this.notifyInfo.getText());
        this.maintenanceInfo.setApplication(this.notifyInfo.getApplication());
        if (this.confirmValid.getSelection()) {
            this.maintenanceInfo.setValid_flg(Integer.valueOf(1));
            this.scheduleInfo.setValid(1);
        } else {
            this.maintenanceInfo.setValid_flg(Integer.valueOf(0));
            this.scheduleInfo.setValid(0);
        }
        if (result == null && this.m_schedule instanceof ArrayList) {
            this.maintenanceInfo.setRegUser((String)this.m_schedule.get(7));
            this.maintenanceInfo.setRegDate(new Timestamp(((Date)this.m_schedule.get(8)).getTime()));
            this.scheduleInfo.setCreateUser((String)this.m_schedule.get(7));
            this.scheduleInfo.setCreateTime((Date)this.m_schedule.get(8));
        }
        return result;
    }

    protected MaintenanceInfoData getMaintenanceInfo() {
        return this.maintenanceInfo;
    }

    protected ScheduleInfo getScheduleInfo() {
        return this.scheduleInfo;
    }

    protected void setInputData(MaintenanceInfoData info) {
        if (info.getMaintenance_id() != null) {
            this.maintenanceId = info.getMaintenance_id();
            this.m_textMaintenanceId.setText(this.maintenanceId);
        }
        if (info.getDescription() != null) {
            this.m_textDescription.setText(info.getDescription());
        }
        if (info.getKeep_id() != null) {
            this.m_maintenance_keep.setText(Messages.getString((String)MaintenanceKeepMstConstant.keepIdToNameId((String)info.getKeep_id())));
        }
        if (info.getCalendar_id() != null) {
            this.m_calendarId.setText(info.getCalendar_id());
        }
        if (info.getType_id() != null) {
            this.m_maintenance_type.setText(Messages.getString((String)MaintenanceTypeMstConstant.typeIdToNameId((String)info.getType_id())));
        }
        if (info.getSchedule_date() != null) {
            this.scheduleDate = info.getSchedule_date();
        }
        if (info.getNotify_id() != null) {
            this.notifyInfo.setText(info.getNotify_id());
        }
        if (info.getApplication() != null) {
            this.notifyInfo.setApplication(info.getApplication());
        }
        if (info.getValid_flg() != null) {
            this.confirmValid.setSelection(ValidConstant.typeToBoolean((int)info.getValid_flg()));
        }
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createMaintenanceInfo();
        if (result != null) {
            return result;
        }
        return null;
    }

    protected boolean action() {
        boolean result = false;
        if (this.maintenanceInfo != null && this.scheduleInfo != null) {
            result = this.maintenanceId == null ? new AddMaintenance().add(this.maintenanceInfo, this.scheduleInfo) : new ModifyMaintenance().modify(this.maintenanceInfo, this.scheduleInfo);
        }
        return result;
    }
}

