#!/bin/sh

#Copyright (C) 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

EXEC_PATH=${0%/*}

echo "###################################################################"
echo "###                                                             ###"
echo "### 運用管理ソフトウェア Hinemos  クライアント                  ###"
echo "###                                   インストーラ   Ver 2.1    ###"
echo "###                                                             ###"
echo "###  2006/9/29                                                  ###"
echo "###  Copyright (C) 2006 NTT DATA Corporation.                   ###"
echo "###################################################################"


#設定情報読み込み
. ${0%/*}/install.cfg

while [ 1 ];
do
	echo "Hinemos クライアント の"
	echo "     1) インストール"
	echo "     9) インストーラの終了"
	echo ""
	echo -n "===> "
	
	read CHOSEN_NUMBER

	case ${CHOSEN_NUMBER} in
	1)
		echo ""
	
		while [ 1 ];
		do
			echo ""
			echo "インストールを開始します。よろしいですか?(Y/N)"
			read ANS
			case ${ANS} in
				y|Y)
					# インストール準備部分
					echo "Hinemos クライアントをインストールするディレクトリを入力してください。(default:${HOME}/hinemos_client)"
					echo "rootユーザ以外でインストールしている場合は、書き込み権限を与えて下さい。"
					read HINEMOS_CLIENT_HOME
					HINEMOS_CLIENT_HOME=${HINEMOS_CLIENT_HOME:-$HOME/hinemos_client}
					if [ ! -d ${HINEMOS_CLIENT_HOME} ]; then
					    echo "${HINEMOS_CLIENT_HOME}は存在しません。作成します。"
					    mkdir -p ${HINEMOS_CLIENT_HOME}
					   if [ $? -ne 0 ] ; then
    					       exit 2
 					   fi
					   echo ""
					fi
	
					# クライアント該当部分をコピーする。
					echo "必要なファイルのコピーを行なっています。"
					cp -pr ${EXEC_PATH}/hinemos_client/* ${HINEMOS_CLIENT_HOME}
					echo "必要なファイルのコピーが終わりました。"


					echo "JREのインストールをおこないます。"
                          		sleep 2
                          		echo ""
                          		cp ${EXEC_PATH}/jre-1_5_0_09-linux-i586.bin ${HINEMOS_CLIENT_HOME}
                          		CURRENT_DIR=`pwd`
                          		cd ${HINEMOS_CLIENT_HOME}
                          		${HINEMOS_CLIENT_HOME}/jre-1_5_0_09-linux-i586.bin
                          		rm ${HINEMOS_CLIENT_HOME}/jre-1_5_0_09-linux-i586.bin
                          		cd $CURRENT_DIR

#起動スクリプト設定
					REPLACE_PATH=`echo $HINEMOS_CLIENT_HOME | sed 's/\//\\\\\//g'`
					sed "s/%%hinemos_client_install_dir%%/$REPLACE_PATH/" $EXEC_PATH/hinemos_client.cfg > $HINEMOS_CLIENT_HOME/hinemos_client.cfg
					sed "s/%%hinemos_client_install_dir%%/$REPLACE_PATH/" $EXEC_PATH/hinemos_client.sh > $HINEMOS_CLIENT_HOME/hinemos_client.sh
					chmod 700 $HINEMOS_CLIENT_HOME/hinemos_client.sh

#					sed -e "s%\%\%HinemosHome\%\%%${HINEMOS_CLIENT_HOME}%" -e "s/%%ClientJRE%%/${JRE_NAME}/" $EXEC_PATH/scripts/hinemos_client.sh > ${HINEMOS_CLIENT_HOME}/hinemos_client.sh
#					chmod +x ${HINEMOS_CLIENT_HOME}/hinemos_client.sh
					echo ""	
					echo ""	
					echo "Hinemos クライアントのインストールが完了しました。"
					echo "${HINEMOS_CLIENT_HOME}/hinemos_client.sh でHinemosクライアントが起動します。"	
					echo ""	
					echo ""	
					break
					;;

				n|N)
					echo "インストールを中止してメニューに戻ります。"
					echo ""
					sleep 1
					break
					;;

			    *)
				;;
			esac

		done
		;;
	9)
		echo "Hinemos インストーラを終了します。"
		exit
		;;
	*)
		echo ""
		sleep 1
		;;
  esac
done
