/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.AbstractWorkingSetManager;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;

public class WorkingSet
implements IAdaptable,
IWorkingSet {
    static final String FACTORY_ID = "org.eclipse.ui.internal.WorkingSetFactory";
    private String name;
    private ArrayList elements;
    private String editPageId;
    private IMemento workingSetMemento;
    private IWorkingSetManager manager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public WorkingSet(String name, IAdaptable[] elements) {
        Assert.isNotNull((Object)name, (String)"name must not be null");
        this.name = name;
        this.internalSetElements(elements);
    }

    WorkingSet(String name, IMemento memento) {
        Assert.isNotNull((Object)name, (String)"name must not be null");
        this.name = name;
        this.workingSetMemento = memento;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WorkingSet) {
            boolean pageIdEqual;
            WorkingSet workingSet = (WorkingSet)object;
            String objectPageId = workingSet.getId();
            String pageId = this.getId();
            boolean bl = pageIdEqual = objectPageId == null && pageId == null || objectPageId != null && objectPageId.equals(pageId);
            return workingSet.getName().equals(this.getName()) && workingSet.getElementsArray().equals(this.getElementsArray()) && pageIdEqual;
        }
        return false;
    }

    public boolean isEditable() {
        WorkingSetRegistry registry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        String id = this.getId();
        if (id == null) {
            return false;
        }
        WorkingSetDescriptor descriptor = registry.getWorkingSetDescriptor(id);
        if (descriptor == null) {
            return false;
        }
        return descriptor.isEditable();
    }

    public Object getAdapter(Class adapter) {
        block12: {
            block11: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.IWorkingSet");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz) break block11;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.IPersistableElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter != clazz2) break block12;
            }
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IAdaptable[] getElements() {
        ArrayList list = this.getElementsArray();
        return list.toArray(new IAdaptable[list.size()]);
    }

    private ArrayList getElementsArray() {
        if (this.elements == null) {
            this.restoreWorkingSet();
            this.workingSetMemento = null;
        }
        return this.elements;
    }

    public String getFactoryId() {
        return FACTORY_ID;
    }

    public String getId() {
        return this.editPageId;
    }

    public ImageDescriptor getImage() {
        WorkingSetRegistry registry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        WorkingSetDescriptor descriptor = null;
        if (this.editPageId == null) {
            this.editPageId = "org.eclipse.ui.resourceWorkingSetPage";
        }
        if ((descriptor = registry.getWorkingSetDescriptor(this.editPageId)) == null) {
            return null;
        }
        return descriptor.getIcon();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int hashCode = this.name.hashCode() & this.getElementsArray().hashCode();
        if (this.editPageId != null) {
            hashCode &= this.editPageId.hashCode();
        }
        return hashCode;
    }

    private void restoreWorkingSet() {
        IMemento[] itemMementos = this.workingSetMemento.getChildren("item");
        HashSet<IAdaptable> items = new HashSet<IAdaptable>();
        int i = 0;
        while (i < itemMementos.length) {
            IMemento itemMemento = itemMementos[i];
            String factoryID = itemMemento.getString("factoryID");
            if (factoryID == null) {
                WorkbenchPlugin.log("Unable to restore working set item - no factory ID.");
            } else {
                IElementFactory factory = PlatformUI.getWorkbench().getElementFactory(factoryID);
                if (factory == null) {
                    WorkbenchPlugin.log("Unable to restore working set item - cannot instantiate factory: " + factoryID);
                } else {
                    IAdaptable item = factory.createElement(itemMemento);
                    if (item == null) {
                        WorkbenchPlugin.log("Unable to restore working set item - cannot instantiate item: " + factoryID);
                    } else {
                        items.add(item);
                    }
                }
            }
            ++i;
        }
        this.internalSetElements(items.toArray(new IAdaptable[items.size()]));
    }

    public void saveState(IMemento memento) {
        if (this.workingSetMemento != null) {
            memento.putMemento(this.workingSetMemento);
        } else {
            memento.putString("name", this.name);
            memento.putString("editPageId", this.editPageId);
            Iterator iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                IPersistableElement persistable;
                IAdaptable adaptable = (IAdaptable)iterator.next();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.IPersistableElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((persistable = (IPersistableElement)adaptable.getAdapter((Class)clazz)) == null) continue;
                IMemento itemMemento = memento.createChild("item");
                itemMemento.putString("factoryID", persistable.getFactoryId());
                persistable.saveState(itemMemento);
            }
        }
    }

    public void setElements(IAdaptable[] newElements) {
        this.internalSetElements(newElements);
        this.fireWorkingSetChanged("workingSetContentChange", null);
    }

    private void internalSetElements(IAdaptable[] newElements) {
        Assert.isNotNull((Object)newElements, (String)"Working set elements array must not be null");
        this.elements = new ArrayList(newElements.length);
        int i = 0;
        while (i < newElements.length) {
            this.elements.add(newElements[i]);
            ++i;
        }
    }

    public void setId(String pageId) {
        this.editPageId = pageId;
    }

    public void setName(String newName) {
        Assert.isNotNull((Object)newName, (String)"Working set name must not be null");
        this.name = newName;
        this.fireWorkingSetChanged("workingSetNameChange", null);
    }

    public void connect(IWorkingSetManager manager) {
        Assert.isTrue((this.manager == null ? 1 : 0) != 0, (String)"A working set can only be connected to one manager");
        this.manager = manager;
    }

    public void disconnect() {
        this.manager = null;
    }

    private void fireWorkingSetChanged(String property, Object oldValue) {
        AbstractWorkingSetManager receiver = this.manager != null ? (AbstractWorkingSetManager)this.manager : (AbstractWorkingSetManager)WorkbenchPlugin.getDefault().getWorkingSetManager();
        receiver.workingSetChanged(this, property, oldValue);
    }
}

