/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextAreaDialog
extends CommonDialog {
    private boolean m_modify = false;
    private Text m_text = null;
    private String m_title = Messages.getString((String)"text");
    private String m_displayString = null;

    public TextAreaDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public TextAreaDialog(Shell parent, String title, boolean modify) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        if (title != null) {
            this.m_title = title;
        }
        this.m_modify = modify;
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    protected void customizeDialog(Composite parent) {
        parent.getShell().setText(this.m_title);
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        this.m_text = new Text(parent, 2818);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.m_text.setLayoutData((Object)gridData);
        this.m_text.setText(this.m_displayString);
        this.m_text.setEditable(this.m_modify);
    }

    public void setText(String displayString) {
        this.m_displayString = displayString;
    }

    public String getText() {
        return this.m_displayString;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    protected ValidateResult validate() {
        this.m_displayString = this.m_text.getText();
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.m_modify) {
            super.createButtonsForButtonBar(parent);
        } else {
            this.createButton(parent, 1, Messages.getString((String)"ok"), false);
        }
    }
}

