/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.dao;

import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.util.ConnectionManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollectorItemDAO {
    protected static Log m_log = LogFactory.getLog(CollectorItemDAO.class);

    public CollectorItemInfo selectCollectorItem(String collectorID, int collectorItemID) throws EJBException {
        m_log.debug((Object)("selectCollectorItem() start : " + collectorID + " " + collectorItemID));
        CollectorItemInfo cinfo = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM COLLECTOR_ITEM WHERE COLLECTORID=? AND ITEMID = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collectorID);
            stmt.setInt(2, collectorItemID);
            res = stmt.executeQuery();
            if (res.next()) {
                cinfo = new CollectorItemInfo(res.getString("COLLECTORID"), res.getInt("ITEMID"), res.getString("ITEM_CODE"), res.getInt("DEVICE_INDEX"), res.getString("DEVICE_NAME"));
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("selectCollectorIte() error :" + collectorID + " " + collectorItemID + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("selectCollectorIte() error :" + collectorID + " " + collectorItemID + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("selectCollectorItem() end   : " + collectorID + " " + collectorItemID));
        return cinfo;
    }

    public void registCollectorItem(CollectorItemInfo cinfo) throws EJBException {
        m_log.debug((Object)("registCollectorItem() start :" + cinfo.getCollectorID() + " " + cinfo.getCollectorItemID()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "INSERT INTO COLLECTOR_ITEM (collectorID, itemID,item_code,device_index,device_name,monitor_flag)values (?,?,?,?,?,?);";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, cinfo.getCollectorID());
            stmt.setInt(2, cinfo.getCollectorItemID());
            stmt.setString(3, cinfo.getCollectorItemCode());
            stmt.setInt(4, cinfo.getDeviceIndex());
            stmt.setString(5, cinfo.getDeviceName());
            stmt.setBoolean(6, false);
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("registCollectorItem() error :" + cinfo.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("registCollectorItem() error :" + cinfo.toString() + " SQLException "));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("registCollectorItem() error :" + cinfo.toString() + " SQLException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("registCollectorItem() end   :" + cinfo.toString()));
        }
    }

    public Collection selectCollectorItemByCollectorID(String collectorID) throws EJBException {
        m_log.debug((Object)("selectCollectorItemByCollectorID() start :" + collectorID));
        ArrayList<CollectorItemInfo> ret = new ArrayList<CollectorItemInfo>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM COLLECTOR_ITEM WHERE COLLECTORID=? ORDER BY ITEMID;";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collectorID);
            res = stmt.executeQuery();
            while (res.next()) {
                CollectorItemInfo cinfo = new CollectorItemInfo(res.getString("COLLECTORID"), res.getInt("ITEMID"), res.getString("ITEM_CODE"), res.getInt("DEVICE_INDEX"), res.getString("DEVICE_NAME"));
                ret.add(cinfo);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("selectCollectorItemByCollectorID() error :" + collectorID + " SQLException "));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("selectCollectorItemByCollectorID() error :" + collectorID + " SQLException "));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("selectCollectorItemByCollectorID() end   :" + collectorID));
        return ret;
    }

    public void deleteCollectorItemByCollectorID(String collectorID) {
        m_log.debug((Object)("deleteCollectorItemByCollectorID() start :" + collectorID));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM COLLECTOR_ITEM WHERE COLLECTORID = ? ";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collectorID);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            m_log.error((Object)("deleteCollectorItemByCollectorID() error :" + collectorID + " SQLException "));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("deleteCollectorItemByCollectorID() error :" + collectorID + " SQLException "));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("deleteCollectorItemByCollectorID() end   :" + collectorID));
    }
}

