/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import java.util.Hashtable;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.interceptor.InterceptorNameConflictException;
import org.jboss.mx.interceptor.SharedInterceptor;
import org.jboss.mx.modelmbean.RequiredModelMBeanInstantiator;
import org.jboss.mx.util.AgentID;

public abstract class AbstractSharedInterceptor
extends AbstractInterceptor
implements SharedInterceptor {
    protected MBeanServer server = null;
    protected ObjectName objectName = null;
    static /* synthetic */ Class class$org$jboss$mx$server$Invocation;
    static /* synthetic */ Class class$java$lang$Object;

    public AbstractSharedInterceptor() {
    }

    public AbstractSharedInterceptor(String name) {
        super(name);
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public synchronized ObjectName register(MBeanServer server) throws InterceptorNameConflictException {
        block5: {
            this.server = server;
            if (this.log == null) {
                this.log = Logger.getLogger("JBossMX.Interceptor." + this.name);
            }
            try {
                this.objectName = this.createObjectName();
                Set names = server.queryNames(this.objectName, null);
                if (names.size() > 0) {
                    throw new InterceptorNameConflictException("A shared interceptor named '" + this.name + "' already registered " + "to this MBean server (" + AgentID.get(server) + ")");
                }
                ModelMBean rmm = RequiredModelMBeanInstantiator.instantiate();
                rmm.setManagedResource(this, "ObjectReference");
                rmm.setModelMBeanInfo(this.getManagementInterface());
                server.registerMBean(rmm, this.objectName);
                this.isShared = true;
            }
            catch (InstanceAlreadyExistsException e) {
                throw new InterceptorNameConflictException("A shared interceptor named '" + this.name + "' already registered " + "to this MBean server (" + AgentID.get(server) + ")");
            }
            catch (Exception e) {
                if (this.log == null) break block5;
                this.log.error(e.toString(), e);
            }
        }
        return this.objectName;
    }

    public void init() throws Exception {
    }

    public void start() {
    }

    public void stop() throws Exception {
    }

    public void destroy() {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName oname) throws Exception {
        this.server = server;
        this.objectName = oname == null ? this.createObjectName() : oname;
        this.init();
        return this.objectName;
    }

    public void postRegister(Boolean registrationSuccesful) {
        this.isShared = true;
        this.start();
    }

    public void preDeregister() throws Exception {
        this.stop();
        this.isShared = false;
        this.objectName = null;
    }

    public void postDeregister() {
        this.destroy();
    }

    public synchronized void setName(String name) {
        if (this.isShared()) {
            throw new IllegalArgumentException("Cannot change the interceptor name. Already registered.");
        }
        this.name = name;
    }

    public String toString() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(46);
        return className.substring(index < 0 ? 0 : index) + "[" + "name=" + this.name + "SHARED " + this.objectName + "]";
    }

    protected ObjectName createObjectName() throws MalformedObjectNameException {
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("type", "Interceptor");
        props.put("name", this.name);
        props.put("ID", "0");
        return new ObjectName("JBossMX", props);
    }

    private ModelMBeanInfo getManagementInterface() {
        return new ModelMBeanInfoSupport(this.getClass().getName(), "Interceptor invocation interface", null, null, new ModelMBeanOperationInfo[]{new ModelMBeanOperationInfo("invoke", "Shared interceptor invoke operation.", new MBeanParameterInfo[]{new MBeanParameterInfo("invocation", (class$org$jboss$mx$server$Invocation == null ? (class$org$jboss$mx$server$Invocation = AbstractSharedInterceptor.class$("org.jboss.mx.server.Invocation")) : class$org$jboss$mx$server$Invocation).getName(), "The invocation object.")}, (class$java$lang$Object == null ? (class$java$lang$Object = AbstractSharedInterceptor.class$("java.lang.Object")) : class$java$lang$Object).getName(), 2)}, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

