/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.internal.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.model.WorkbenchResource;

public class ProjectPersistentPropertyTester
extends PropertyTester {
    private static final String ALLOW_UNSET_PROJECTS = "allowUnsetProjects";
    private static final IActionFilter filter = new WorkbenchResource(){

        protected ImageDescriptor getBaseImage(IResource resource) {
            return null;
        }
    };

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof ResourceMapping) {
            if (property.equals("projectPersistentProperty")) {
                if (args == null) {
                    return false;
                }
                String persitentPropertyEntry = (String)args[0];
                boolean allowUnsetProjects = false;
                if (args.length > 1) {
                    allowUnsetProjects = args[1].equals(ALLOW_UNSET_PROJECTS);
                }
                IProject[] projects = ((ResourceMapping)receiver).getProjects();
                boolean atLeastOne = false;
                int i = 0;
                while (i < projects.length) {
                    IProject project = projects[i];
                    if (filter.testAttribute((Object)project, property, persitentPropertyEntry)) {
                        atLeastOne = true;
                    } else {
                        if (!allowUnsetProjects) {
                            return false;
                        }
                        try {
                            if (project != null && project.isAccessible() && project.getPersistentProperty(this.getPropertyKey(persitentPropertyEntry)) != null) {
                                return false;
                            }
                        }
                        catch (CoreException e) {
                            IDEWorkbenchPlugin.log("Core exception while testing project persistent property", (IStatus)new Status(4, "org.eclipse.ui.ide", 4, "Core exception while testing project persistent property", (Throwable)e));
                        }
                    }
                    ++i;
                }
                return atLeastOne;
            }
        } else if (receiver instanceof IResource && property.equals("projectPersistentProperty")) {
            if (args == null) {
                return false;
            }
            String persitentPropertyEntry = (String)args[0];
            IProject project = ((IResource)receiver).getProject();
            return filter.testAttribute((Object)project, property, persitentPropertyEntry);
        }
        return false;
    }

    private QualifiedName getPropertyKey(String value) {
        int i = value.indexOf(61);
        String propertyName = i != -1 ? value.substring(0, i).trim() : value.trim();
        int dot = propertyName.lastIndexOf(46);
        QualifiedName key = dot != -1 ? new QualifiedName(propertyName.substring(0, dot), propertyName.substring(dot + 1)) : new QualifiedName(null, propertyName);
        return key;
    }
}

