/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling.impl.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.Util;

public class RtUtil {
    private static final Logger log = Logger.getLogger(RtUtil.class);

    private RtUtil() {
    }

    public static void set(Object o, Object value, String prop, String colType, boolean ignoreNotFoundField) {
        Class<?> fieldType;
        Class<?> cls = o.getClass();
        Method getter = null;
        Method setter = null;
        Field field = null;
        try {
            String methodBase = Character.toUpperCase(prop.charAt(0)) + prop.substring(1);
            try {
                getter = cls.getMethod("get" + methodBase, null);
            }
            catch (NoSuchMethodException e) {
                getter = cls.getMethod("is" + methodBase, null);
            }
            fieldType = getter.getReturnType();
            setter = cls.getMethod("set" + methodBase, fieldType);
        }
        catch (NoSuchMethodException e) {
            try {
                field = cls.getField(prop);
                fieldType = field.getType();
            }
            catch (NoSuchFieldException e1) {
                if (ignoreNotFoundField) {
                    log.warn("Neither getter/setter nor field were found for field " + prop + " in " + cls);
                    return;
                }
                throw new JBossXBRuntimeException("Neither getter/setter nor field were found for field " + prop + " in " + cls);
            }
        }
        if (colType != null || Collection.class.isAssignableFrom(fieldType) && !Collection.class.isAssignableFrom(value.getClass())) {
            Collection<Object> col = (ArrayList<Object>)RtUtil.get(o, getter, field);
            if (col == null) {
                if (colType == null) {
                    col = new ArrayList<Object>();
                } else {
                    Class<?> colCls;
                    try {
                        colCls = Thread.currentThread().getContextClassLoader().loadClass(colType);
                    }
                    catch (ClassNotFoundException e) {
                        throw new JBossXBRuntimeException("Failed to load collection type: " + colType);
                    }
                    try {
                        col = (Collection)colCls.newInstance();
                    }
                    catch (Exception e) {
                        throw new JBossXBRuntimeException("Failed to create an instance of " + colCls);
                    }
                }
                RtUtil.set(o, col, setter, field);
            }
            col.add(value);
        } else if (fieldType.isArray() && value != null && !value.getClass().isArray()) {
            Object arr = RtUtil.get(o, getter, field);
            int length = 0;
            if (arr == null) {
                arr = Array.newInstance(fieldType.getComponentType(), 1);
            } else {
                Object tmp = arr;
                length = Array.getLength(arr);
                arr = Array.newInstance(fieldType.getComponentType(), length + 1);
                System.arraycopy(tmp, 0, arr, 0, length);
            }
            Array.set(arr, length, value);
            RtUtil.set(o, arr, setter, field);
        } else {
            RtUtil.set(o, value, setter, field);
        }
    }

    public static void set(Object o, QName elementName, Object value, boolean ignoreLowLine) {
        if (o instanceof Collection) {
            ((Collection)o).add(value);
        } else {
            Class<?> cls = o.getClass();
            String methodBase = Util.xmlNameToClassName(elementName.getLocalPart(), ignoreLowLine);
            Method setter = null;
            Field field = null;
            try {
                Method getter = cls.getMethod("get" + methodBase, null);
                setter = cls.getMethod("set" + methodBase, getter.getReturnType());
            }
            catch (NoSuchMethodException e) {
                try {
                    field = cls.getField(Util.xmlNameToFieldName(elementName.getLocalPart(), ignoreLowLine));
                }
                catch (NoSuchFieldException e1) {
                    throw new JBossXBRuntimeException("Neither getter/setter nor field were found for " + elementName + " in " + cls);
                }
            }
            RtUtil.set(o, value, setter, field);
        }
    }

    private static void set(Object o, Object value, Method setter, Field field) {
        block5: {
            try {
                if (setter != null) {
                    setter.invoke(o, value);
                    break block5;
                }
                if (field != null) {
                    field.set(o, value);
                    break block5;
                }
                throw new JBossXBRuntimeException("Neither setter nor field is available!");
            }
            catch (JBossXBRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JBossXBRuntimeException("Failed to set value " + (value == null ? "null" : value.getClass().getName() + '@' + value.hashCode() + "[" + value + "]") + (field == null ? (setter == null ? "" : " using setter " + setter.getName()) : " using field " + field.getName()) + " on " + (o == null ? "null" : o.getClass().getName() + '@' + o.hashCode() + "[" + o + "]") + " : " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Object get(Object o, Method getter, Field field) {
        void var3_3;
        block5: {
            try {
                Object result;
                if (getter != null) {
                    result = getter.invoke(o, null);
                    break block5;
                }
                if (field != null) {
                    result = field.get(o);
                    break block5;
                }
                throw new JBossXBRuntimeException("Neither getter nor field is available!");
            }
            catch (JBossXBRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JBossXBRuntimeException("Failed to get value " + (field == null ? (getter == null ? "" : " using getter " + getter.getName()) : " using field " + field.getName()) + " on " + (o == null ? "null" : o.getClass().getName() + '@' + o.hashCode() + "[" + o + "]") + " : " + e.getMessage(), e);
            }
        }
        return var3_3;
    }
}

