/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.loading;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;

public class ObjectInputStreamWithClassLoader
extends ObjectInputStream {
    private ClassLoader cl;

    public ObjectInputStreamWithClassLoader(InputStream in, ClassLoader cl) throws IOException, StreamCorruptedException {
        super(in);
        this.cl = cl;
    }

    public void setClassLoader(ClassLoader cl) {
        this.cl = cl;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        if (this.cl == null) {
            return super.resolveClass(v);
        }
        return this.cl.loadClass(v.getName());
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        if (this.cl == null) {
            return super.resolveProxyClass(interfaces);
        }
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            classObjs[i] = this.cl.loadClass(interfaces[i]);
        }
        try {
            return Proxy.getProxyClass(this.cl, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

