/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.ejb;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import javax.naming.InitialContext;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationContext;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.ServiceUnavailableException;
import org.jboss.logging.Logger;
import org.jboss.proxy.Interceptor;

public class RetryInterceptor
extends Interceptor {
    private static final long serialVersionUID = 1L;
    private static final int EXTERNAL_VERSION = 1;
    private static Logger log = Logger.getLogger(RetryInterceptor.class);
    private static Properties retryEnv;
    private transient boolean retry;
    private transient boolean trace;

    public static void setRetryEnv(Properties env) {
        retryEnv = env;
    }

    public void setRetry(boolean flag) {
        this.retry = flag;
    }

    public boolean getRetry() {
        return this.retry;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object result = null;
        InvocationContext ctx = invocation.getInvocationContext();
        this.retry = true;
        while (this.retry) {
            Interceptor next = this.getNext();
            try {
                if (this.trace) {
                    log.trace("invoke, method=" + invocation.getMethod());
                }
                result = next.invoke(invocation);
                break;
            }
            catch (ServiceUnavailableException e) {
                if (this.trace) {
                    log.trace("Invocation failed", e);
                }
                InvocationType type = invocation.getType();
                this.waitOnInvokerProxy(ctx, type);
            }
        }
        return result;
    }

    private void waitOnInvokerProxy(InvocationContext ctx, InvocationType type) {
        if (this.trace) {
            log.trace("Begin waitOnInvokerProxy");
        }
        boolean isRemote = type == InvocationType.REMOTE;
        String jndiName = (String)ctx.getValue(InvocationKey.JNDI_NAME);
        jndiName = isRemote ? jndiName + "-RemoteInvoker" : jndiName + "-HomeInvoker";
        while (this.retry) {
            try {
                Thread.sleep(1000L);
                InitialContext namingCtx = new InitialContext(retryEnv);
                if (this.trace) {
                    log.trace("Looking for invoker: " + jndiName);
                }
                Invoker invoker = (Invoker)namingCtx.lookup(jndiName);
                if (this.trace) {
                    log.trace("Found invoker: " + invoker);
                }
                ctx.setInvoker(invoker);
                break;
            }
            catch (Throwable t) {
                if (!this.trace) continue;
                log.trace("Failed to lookup proxy", t);
            }
        }
        if (this.trace) {
            log.trace("End waitOnInvokerProxy");
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(1);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int version = in.readInt();
        if (version == 1) {
            // empty if block
        }
        this.trace = log.isTraceEnabled();
    }
}

