/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.jobmanagement.dao.JobNoticeInfoDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoPK;
import com.clustercontrol.jobmanagement.util.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobNoticeInfoDAOImpl
implements JobNoticeInfoDAO {
    protected static Log m_log = LogFactory.getLog(JobNoticeInfoDAOImpl.class);

    public void init() {
    }

    public void load(JobNoticeInfoPK pk, JobNoticeInfoBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_notice_info WHERE session_id = ? AND job_id = ? AND notice_type = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                stmt.setInt(3, pk.getNotice_type());
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setJob_id(res.getString("job_id"));
                    ejb.setNotice_type(res.getInt("notice_type"));
                    ejb.setNotify_id(res.getString("notify_id"));
                    ejb.setPriority(res.getInt("priority"));
                    ejb.setSession_id(res.getString("session_id"));
                    break block13;
                }
                String msg = "JobNoticeInfo data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(JobNoticeInfoBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getNotice_type()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE cc_job_notice_info SET ");
            sql.append("priority = ?, ");
            sql.append("notify_id = ? ");
            sql.append("WHERE session_id = ? AND ");
            sql.append("job_id = ? AND ");
            sql.append("notice_type = ?");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setInt(1, ejb.getPriority());
            stmt.setString(2, ejb.getNotify_id());
            stmt.setString(3, ejb.getSession_id());
            stmt.setString(4, ejb.getJob_id());
            stmt.setInt(5, ejb.getNotice_type());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getNotice_type() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getNotice_type() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getNotice_type() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getNotice_type()));
    }

    public void remove(JobNoticeInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_job_notice_info WHERE session_id = ? AND job_id = ? AND notice_type = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            stmt.setInt(3, pk.getNotice_type());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public JobNoticeInfoPK create(JobNoticeInfoBean ejb) throws CreateException, EJBException {
        JobNoticeInfoPK pk;
        m_log.debug((Object)("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getNotice_type()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_job_notice_info (");
            sql.append("session_id, ");
            sql.append("job_id, ");
            sql.append("notice_type, ");
            sql.append("priority, ");
            sql.append("notify_id) ");
            sql.append("VALUES (?,?,?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getSession_id());
            stmt.setString(2, ejb.getJob_id());
            stmt.setInt(3, ejb.getNotice_type());
            stmt.setInt(4, ejb.getPriority());
            stmt.setString(5, ejb.getNotify_id());
            int row = stmt.executeUpdate();
            pk = new JobNoticeInfoPK(ejb.getSession_id(), ejb.getJob_id(), ejb.getNotice_type());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getNotice_type() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getNotice_type() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getNotice_type() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getNotice_type()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobNoticeInfoPK> ret = new ArrayList<JobNoticeInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_notice_info";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                JobNoticeInfoPK pk = new JobNoticeInfoPK(res.getString("session_id"), res.getString("job_id"), res.getInt("notice_type"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobNoticeInfoPK findByPrimaryKey(JobNoticeInfoPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_notice_info WHERE session_id = ? AND job_id = ? AND notice_type = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            stmt.setInt(3, pk.getNotice_type());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobNoticeInfoPK jobNoticeInfoPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobNoticeInfoPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    public Collection findBySessionIdAndJobId(String session_id, String job_id) throws FinderException {
        m_log.debug((Object)("findBySessionIdAndJobId() start : " + session_id + ", " + job_id));
        ArrayList<JobNoticeInfoPK> ret = new ArrayList<JobNoticeInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_notice_info WHERE session_id = ? AND job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, session_id);
            stmt.setString(2, job_id);
            res = stmt.executeQuery();
            while (res.next()) {
                JobNoticeInfoPK pk = new JobNoticeInfoPK(res.getString("session_id"), res.getString("job_id"), res.getInt("notice_type"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("findBySessionIdAndJobId() end : " + session_id + ", " + job_id));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeSession(String sessionId, Collection jobs) throws CreateException {
        m_log.debug((Object)("makeSession() start : " + sessionId));
        Connection conn = null;
        Connection connMaster = null;
        Statement stmt = null;
        Statement stmtMaster = null;
        String jobId = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                connMaster = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_notice_info (");
                sql.append("session_id, ");
                sql.append("job_id, ");
                sql.append("notice_type, ");
                sql.append("priority, ");
                sql.append("notify_id) ");
                sql.append("VALUES (?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, sessionId);
                String sqlMaster = "SELECT * FROM cc_job_notice_mst WHERE job_id = ?";
                stmtMaster = connMaster.prepareStatement(sqlMaster);
                for (Hashtable ht : jobs) {
                    jobId = (String)ht.get("jobId");
                    stmtMaster.setString(1, jobId);
                    ResultSet resMaster = stmtMaster.executeQuery();
                    while (resMaster.next()) {
                        stmt.setString(2, jobId);
                        stmt.setInt(3, resMaster.getInt("notice_type"));
                        stmt.setInt(4, resMaster.getInt("priority"));
                        stmt.setString(5, resMaster.getString("notify_id"));
                        int row = stmt.executeUpdate();
                        if (row == 1) continue;
                        String msg = "result row is not 1";
                        m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                        throw new EJBException(msg);
                    }
                    resMaster.close();
                }
                Object var16_16 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (stmtMaster != null) {
                    stmtMaster.close();
                }
                if (conn != null) {
                    conn.close();
                }
                if (connMaster == null) throw throwable;
                connMaster.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (stmtMaster != null) {
            stmtMaster.close();
        }
        if (conn != null) {
            conn.close();
        }
        if (connMaster != null) {
            connMaster.close();
        }
        m_log.debug((Object)("makeSession() end : " + sessionId));
    }
}

